/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.commons.converter.ConverterBase;
import org.apache.myfaces.commons.util.MessageUtils;
import org.apache.myfaces.commons.util.TagUtils;

public class DateTimeConverter
extends javax.faces.convert.DateTimeConverter {
    public static final String CONVERTER_ID = "org.apache.myfaces.custom.convertDateTime.DateTimeConverter";
    private static final String TYPE_DATE = "date";
    private static final String TYPE_TIME = "time";
    private static final String TYPE_BOTH = "both";
    private static final String STYLE_DEFAULT = "default";
    private static final String STYLE_MEDIUM = "medium";
    private static final String STYLE_SHORT = "short";
    private static final String STYLE_LONG = "long";
    private static final String STYLE_FULL = "full";
    private static final TimeZone TIMEZONE_DEFAULT = TimeZone.getTimeZone("GMT");
    private String _dateStyle;
    private Locale _locale;
    private String _pattern;
    private String _timeStyle;
    private TimeZone _timeZone;
    private String _type;
    private boolean _transient;
    private transient FacesContext _facesContext;
    private Map _valueExpressionMap = null;

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value != null && (value = value.trim()).length() > 0) {
            DateFormat format = this.getDateFormat();
            TimeZone tz = this.getTimeZone();
            if (tz != null) {
                format.setTimeZone(tz);
            }
            try {
                return format.parse(value);
            }
            catch (ParseException e) {
                String type = this.getType();
                Object[] args = new Object[]{value, format.format(new Date()), MessageUtils.getLabel((FacesContext)facesContext, (UIComponent)uiComponent)};
                if (type.equals(TYPE_DATE)) {
                    throw new ConverterException(MessageUtils.getMessage((String)"javax.faces.Messages", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"javax.faces.converter.DateTimeConverter.DATE", (Object[])args, (FacesContext)facesContext));
                }
                if (type.equals(TYPE_TIME)) {
                    throw new ConverterException(MessageUtils.getMessage((String)"javax.faces.Messages", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"javax.faces.converter.DateTimeConverter.TIME", (Object[])args, (FacesContext)facesContext));
                }
                if (type.equals(TYPE_BOTH)) {
                    throw new ConverterException(MessageUtils.getMessage((String)"javax.faces.Messages", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"javax.faces.converter.DateTimeConverter.DATETIME", (Object[])args, (FacesContext)facesContext));
                }
                throw new ConverterException("invalid type '" + this._type + "'");
            }
        }
        return null;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        DateFormat format = this.getDateFormat();
        TimeZone tz = this.getTimeZone();
        if (tz != null) {
            format.setTimeZone(tz);
        }
        try {
            return format.format(value);
        }
        catch (Exception e) {
            throw new ConverterException(MessageUtils.getMessage((String)"javax.faces.Messages", (FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"javax.faces.converter.STRING", (Object[])new Object[]{value, MessageUtils.getLabel((FacesContext)facesContext, (UIComponent)uiComponent)}, (FacesContext)facesContext), (Throwable)e);
        }
    }

    private DateFormat getDateFormat() {
        DateFormat format;
        String type = this.getType();
        if (this._pattern != null) {
            try {
                format = new SimpleDateFormat(this._pattern, this.getLocale());
            }
            catch (IllegalArgumentException iae) {
                throw new ConverterException("Invalid pattern", (Throwable)iae);
            }
        } else if (type.equals(TYPE_DATE)) {
            format = DateFormat.getDateInstance(this.calcStyle(this.getDateStyle()), this.getLocale());
        } else if (type.equals(TYPE_TIME)) {
            format = DateFormat.getTimeInstance(this.calcStyle(this.getTimeStyle()), this.getLocale());
        } else if (type.equals(TYPE_BOTH)) {
            format = DateFormat.getDateTimeInstance(this.calcStyle(this.getDateStyle()), this.calcStyle(this.getTimeStyle()), this.getLocale());
        } else {
            throw new ConverterException("invalid type '" + this._type + "'");
        }
        format.setLenient(false);
        return format;
    }

    private int calcStyle(String name) {
        if (name.equals(STYLE_DEFAULT)) {
            return 2;
        }
        if (name.equals(STYLE_MEDIUM)) {
            return 2;
        }
        if (name.equals(STYLE_SHORT)) {
            return 3;
        }
        if (name.equals(STYLE_LONG)) {
            return 1;
        }
        if (name.equals(STYLE_FULL)) {
            return 0;
        }
        throw new ConverterException("invalid style '" + name + "'");
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this._dateStyle = (String)values[0];
        this._locale = (Locale)values[1];
        this._pattern = (String)values[2];
        this._timeStyle = (String)values[3];
        this._timeZone = (TimeZone)values[4];
        this._type = (String)values[5];
        this.restoreValueExpressionMap(facesContext, values[6]);
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this._dateStyle, this._locale, this._pattern, this._timeStyle, this._timeZone, this._type, this.saveValueExpressionMap(facesContext)};
        return values;
    }

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this._valueExpressionMap == null) {
            return null;
        }
        return (ValueExpression)this._valueExpressionMap.get(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this._valueExpressionMap == null) {
            this._valueExpressionMap = new HashMap();
        }
        this._valueExpressionMap.put(name, binding);
    }

    private Object saveValueExpressionMap(FacesContext context) {
        if (this._valueExpressionMap != null) {
            int initCapacity = (this._valueExpressionMap.size() * 4 + 3) / 3;
            HashMap stateMap = new HashMap(initCapacity);
            for (Map.Entry entry : this._valueExpressionMap.entrySet()) {
                stateMap.put(entry.getKey(), ConverterBase.saveAttachedState(context, entry.getValue()));
            }
            return stateMap;
        }
        return null;
    }

    private void restoreValueExpressionMap(FacesContext context, Object stateObj) {
        if (stateObj != null) {
            Map stateMap = (Map)stateObj;
            int initCapacity = (stateMap.size() * 4 + 3) / 3;
            this._valueExpressionMap = new HashMap(initCapacity);
            for (Map.Entry entry : stateMap.entrySet()) {
                this._valueExpressionMap.put(entry.getKey(), ConverterBase.restoreAttachedState(context, entry.getValue()));
            }
        } else {
            this._valueExpressionMap = null;
        }
    }

    protected FacesContext getFacesContext() {
        if (this._facesContext == null) {
            return FacesContext.getCurrentInstance();
        }
        return this._facesContext;
    }

    boolean isCachedFacesContext() {
        return this._facesContext != null;
    }

    void setCachedFacesContext(FacesContext facesContext) {
        this._facesContext = facesContext;
    }

    public String getDateStyle() {
        if (this._dateStyle != null) {
            return this._dateStyle;
        }
        ValueExpression vb = this.getValueExpression("dateStyle");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return STYLE_DEFAULT;
    }

    public void setDateStyle(String dateStyle) {
        this._dateStyle = dateStyle;
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        ValueExpression vb = this.getValueExpression("locale");
        if (vb != null) {
            Object _localeValue = vb.getValue(this.getFacesContext().getELContext());
            if (_localeValue instanceof String) {
                _localeValue = TagUtils.getLocale((Object)((String)_localeValue));
            }
            return (Locale)_localeValue;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public String getPattern() {
        if (this._pattern != null) {
            return this._pattern;
        }
        ValueExpression vb = this.getValueExpression("pattern");
        if (vb != null) {
            return vb.getValue(this.getFacesContext().getELContext()).toString();
        }
        return null;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public String getTimeStyle() {
        if (this._timeStyle != null) {
            return this._timeStyle;
        }
        ValueExpression vb = this.getValueExpression("timeStyle");
        if (vb != null) {
            return vb.getValue(this.getFacesContext().getELContext()).toString();
        }
        return STYLE_DEFAULT;
    }

    public void setTimeStyle(String timeStyle) {
        this._timeStyle = timeStyle;
    }

    public TimeZone getTimeZone() {
        if (this._timeZone != null) {
            return this._timeZone;
        }
        ValueExpression vb = this.getValueExpression("timeZone");
        if (vb != null) {
            Object _timeZoneValue = vb.getValue(this.getFacesContext().getELContext());
            if (_timeZoneValue instanceof TimeZone) {
                return (TimeZone)_timeZoneValue;
            }
            return TimeZone.getTimeZone(_timeZoneValue.toString());
        }
        return TimeZone.getDefault();
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    public String getType() {
        if (this._type != null) {
            return this._type;
        }
        ValueExpression vb = this.getValueExpression("type");
        if (vb != null) {
            return vb.getValue(this.getFacesContext().getELContext()).toString();
        }
        return TYPE_DATE;
    }

    public void setType(String type) {
        this._type = type;
    }
}

