/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.exporter;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.commons.exporter.util.ComponentUtils;
import org.apache.myfaces.commons.exporter.util.ExcelExporterUtil;
import org.apache.myfaces.commons.exporter.util.PDFExporterUtil;

public class ExporterActionListener
implements ActionListener,
StateHolder {
    private static final Log log = LogFactory.getLog(ExporterActionListener.class);
    public static final String FILENAME_KEY = "filename";
    public static final String FILE_TYPE_KEY = "fileType";
    public static final String FOR_KEY = "for";
    private String _fileType;
    private String _fileName;
    private String _for;

    public ExporterActionListener() {
    }

    public ExporterActionListener(String listenerFor, String fileType, String fileName) {
        this._fileType = fileType;
        this._fileName = fileName;
        this._for = listenerFor;
    }

    public void processAction(ActionEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object response = facesContext.getExternalContext().getResponse();
        if (!(response instanceof HttpServletResponse)) {
            log.error((Object)"ExporteActionListener requires servlet");
        } else {
            try {
                HtmlDataTable dataTable = (HtmlDataTable)ComponentUtils.findComponentById(facesContext, (UIComponent)facesContext.getViewRoot(), this._for);
                if (!(dataTable instanceof HtmlDataTable)) {
                    throw new RuntimeException("exporterActionListener for attribute should contain a dataTable component id");
                }
                if ("XLS".equalsIgnoreCase(this._fileType)) {
                    Object contextResponse = facesContext.getExternalContext().getResponse();
                    if (contextResponse instanceof HttpServletResponse) {
                        ExcelExporterUtil.generateEXCEL(facesContext, (HttpServletResponse)contextResponse, this._fileName, dataTable);
                    }
                } else {
                    HttpServletResponse httpResponse = (HttpServletResponse)facesContext.getExternalContext().getResponse();
                    PDFExporterUtil.generatePDF(facesContext, httpResponse, this._fileName, dataTable);
                }
                facesContext.getApplication().getStateManager().saveSerializedView(facesContext);
                facesContext.responseComplete();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        facesContext.responseComplete();
    }

    public String getFilename() {
        return this._fileName;
    }

    public void setFilename(String filename) {
        this._fileName = filename;
    }

    public String getFileType() {
        return this._fileType;
    }

    public void setFileType(String type) {
        this._fileType = type;
    }

    public String getFor() {
        return this._for;
    }

    public void setFor(String listenerFor) {
        this._for = listenerFor;
    }

    public void restoreState(FacesContext context, Object state) {
        String[] values = (String[])state;
        this._for = values[0];
        this._fileName = values[1];
        this._fileType = values[2];
    }

    public Object saveState(FacesContext context) {
        String[] values = new String[]{this._for, this._fileName, this._fileType};
        return values;
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
        if (newTransientValue) {
            throw new IllegalArgumentException();
        }
    }
}

