/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.ActionSource2;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component._MethodBindingToMethodExpression;
import javax.faces.component._MethodExpressionToMethodBinding;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class UICommand
extends UIComponentBase
implements ActionSource2 {
    public static final String COMPONENT_TYPE = "javax.faces.Command";
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    private boolean _immediate;
    private boolean _immediateSet;
    private Object _value;
    private MethodExpression _actionExpression;
    private MethodBinding _actionListener;

    public UICommand() {
        this.setRendererType("javax.faces.Button");
    }

    public MethodBinding getAction() {
        MethodExpression actionExpression = this.getActionExpression();
        if (actionExpression instanceof _MethodBindingToMethodExpression) {
            return ((_MethodBindingToMethodExpression)actionExpression).getMethodBinding();
        }
        if (actionExpression != null) {
            return new _MethodExpressionToMethodBinding(actionExpression);
        }
        return null;
    }

    public void setAction(MethodBinding action) {
        if (action != null) {
            this.setActionExpression(new _MethodBindingToMethodExpression(action));
        } else {
            this.setActionExpression(null);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ActionEvent) {
            ActionListener defaultActionListener;
            FacesContext context = this.getFacesContext();
            MethodBinding mb = this.getActionListener();
            if (mb != null) {
                mb.invoke(context, new Object[]{event});
            }
            if ((defaultActionListener = context.getApplication().getActionListener()) != null) {
                defaultActionListener.processAction((ActionEvent)event);
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        UIComponent component;
        if (event != null && event instanceof ActionEvent && (component = event.getComponent()) instanceof ActionSource) {
            if (((ActionSource)((Object)component)).isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public boolean isImmediate() {
        if (this._immediateSet) {
            return this._immediate;
        }
        ValueExpression expression = this.getValueExpression("immediate");
        if (expression != null) {
            return (Boolean)expression.getValue(this.getFacesContext().getELContext());
        }
        return false;
    }

    public void setImmediate(boolean immediate) {
        this._immediate = immediate;
        this._immediateSet = true;
    }

    public Object getValue() {
        if (this._value != null) {
            return this._value;
        }
        ValueExpression expression = this.getValueExpression("value");
        if (expression != null) {
            return expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public MethodExpression getActionExpression() {
        if (this._actionExpression != null) {
            return this._actionExpression;
        }
        ValueExpression expression = this.getValueExpression("actionExpression");
        if (expression != null) {
            return (MethodExpression)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setActionExpression(MethodExpression actionExpression) {
        this._actionExpression = actionExpression;
    }

    public MethodBinding getActionListener() {
        if (this._actionListener != null) {
            return this._actionListener;
        }
        ValueExpression expression = this.getValueExpression("actionListener");
        if (expression != null) {
            return (MethodBinding)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setActionListener(MethodBinding actionListener) {
        this._actionListener = actionListener;
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener(listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{super.saveState(facesContext), this._immediate, this._immediateSet, this._value, UICommand.saveAttachedState(facesContext, this._actionExpression), UICommand.saveAttachedState(facesContext, this._actionListener)};
        return values;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(facesContext, values[0]);
        this._immediate = (Boolean)values[1];
        this._immediateSet = (Boolean)values[2];
        this._value = values[3];
        this._actionExpression = (MethodExpression)UICommand.restoreAttachedState(facesContext, values[4]);
        this._actionListener = (MethodBinding)UICommand.restoreAttachedState(facesContext, values[5]);
    }

    public String getFamily() {
        return "javax.faces.Command";
    }
}

