/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.webapp.webxml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.xml.MyFacesErrorHandler;
import org.apache.myfaces.shared.util.xml.XmlUtils;
import org.apache.myfaces.shared.webapp.webxml.WebXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class WebXmlParser {
    private static final Logger log = Logger.getLogger(WebXmlParser.class.getName());
    private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
    private static final String WEB_APP_2_2_J2EE_SYSTEM_ID = "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
    private static final String WEB_APP_2_2_SYSTEM_ID = "http://java.sun.com/dtd/web-app_2_2.dtd";
    private static final String WEB_APP_2_2_RESOURCE = "javax/servlet/resources/web-app_2_2.dtd";
    private static final String WEB_APP_2_3_SYSTEM_ID = "http://java.sun.com/dtd/web-app_2_3.dtd";
    private static final String WEB_APP_2_3_RESOURCE = "javax/servlet/resources/web-app_2_3.dtd";
    private ExternalContext _context;
    private WebXml _webXml;

    public WebXmlParser(ExternalContext context) {
        this._context = context;
    }

    public WebXml parse() {
        this._webXml = new WebXml();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setIgnoringComments(true);
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new _EntityResolver());
            db.setErrorHandler(new MyFacesErrorHandler(log));
            InputSource is = this.createContextInputSource(null, WEB_XML_PATH);
            if (is == null) {
                URL url = this._context.getResource(WEB_XML_PATH);
                log.fine("No web-xml found at : " + (url == null ? " null " : url.toString()));
                return this._webXml;
            }
            Document document = db.parse(is);
            Element webAppElem = document.getDocumentElement();
            if (webAppElem == null || !webAppElem.getNodeName().equals("web-app")) {
                throw new FacesException("No valid web-app root element found!");
            }
            this.readWebApp(webAppElem);
            return this._webXml;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unable to parse web.xml", e);
            throw new FacesException((Throwable)e);
        }
    }

    public static long getWebXmlLastModified(ExternalContext context) {
        try {
            URL url = context.getResource(WEB_XML_PATH);
            if (url != null) {
                return url.openConnection().getLastModified();
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not find web.xml in path /WEB-INF/web.xml");
        }
        return 0L;
    }

    private InputSource createContextInputSource(String publicId, String systemId) {
        InputStream inStream = this._context.getResourceAsStream(systemId);
        if (inStream == null) {
            return null;
        }
        InputSource is = new InputSource(inStream);
        is.setPublicId(publicId);
        is.setSystemId(systemId);
        return is;
    }

    private InputSource createClassloaderInputSource(String publicId, String systemId) {
        InputStream inStream = ClassUtils.getResourceAsStream(systemId);
        if (inStream == null) {
            return null;
        }
        InputSource is = new InputSource(inStream);
        is.setPublicId(publicId);
        is.setSystemId(systemId);
        return is;
    }

    private void readWebApp(Element webAppElem) {
        NodeList nodeList = webAppElem.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("servlet")) {
                    this.readServlet((Element)n);
                }
                if (n.getNodeName().equals("servlet-mapping")) {
                    this.readServletMapping((Element)n);
                }
                if (n.getNodeName().equals("filter")) {
                    this.readFilter((Element)n);
                }
                if (n.getNodeName().equals("filter-mapping")) {
                    this.readFilterMapping((Element)n);
                }
                if (!n.getNodeName().equals("error-page")) continue;
                this._webXml.setErrorPagePresent(true);
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Ignored node '" + n.getNodeName() + "' of type " + n.getNodeType());
        }
    }

    private void readServlet(Element servletElem) {
        String servletName = null;
        String servletClass = null;
        NodeList nodeList = servletElem.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("servlet-name")) {
                    servletName = XmlUtils.getElementText((Element)n);
                    continue;
                }
                if (n.getNodeName().equals("servlet-class")) {
                    servletClass = XmlUtils.getElementText((Element)n).trim();
                    continue;
                }
                if (n.getNodeName().equals("description") || n.getNodeName().equals("load-on-startup") || n.getNodeName().equals("init-param") || !log.isLoggable(Level.FINE)) continue;
                log.fine("Ignored element '" + n.getNodeName() + "' as child of '" + servletElem.getNodeName() + "'.");
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Ignored node '" + n.getNodeName() + "' of type " + n.getNodeType());
        }
        this._webXml.addServlet(servletName, servletClass);
    }

    private void readServletMapping(Element servletMappingElem) {
        String servletName = null;
        String urlPattern = null;
        NodeList nodeList = servletMappingElem.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("servlet-name")) {
                    servletName = XmlUtils.getElementText((Element)n);
                    continue;
                }
                if (n.getNodeName().equals("url-pattern")) {
                    urlPattern = XmlUtils.getElementText((Element)n).trim();
                    continue;
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Ignored element '" + n.getNodeName() + "' as child of '" + servletMappingElem.getNodeName() + "'.");
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Ignored node '" + n.getNodeName() + "' of type " + n.getNodeType());
        }
        urlPattern = urlPattern.trim();
        this._webXml.addServletMapping(servletName, urlPattern);
    }

    private void readFilter(Element filterElem) {
        String filterName = null;
        String filterClass = null;
        NodeList nodeList = filterElem.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("filter-name")) {
                    filterName = XmlUtils.getElementText((Element)n).trim();
                    continue;
                }
                if (n.getNodeName().equals("filter-class")) {
                    filterClass = XmlUtils.getElementText((Element)n).trim();
                    continue;
                }
                if (n.getNodeName().equals("description") || n.getNodeName().equals("init-param") || !log.isLoggable(Level.FINE)) continue;
                log.fine("Ignored element '" + n.getNodeName() + "' as child of '" + filterElem.getNodeName() + "'.");
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Ignored node '" + n.getNodeName() + "' of type " + n.getNodeType());
        }
        this._webXml.addFilter(filterName, filterClass);
    }

    private void readFilterMapping(Element filterMappingElem) {
        String filterName = null;
        String urlPattern = null;
        NodeList nodeList = filterMappingElem.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("filter-name")) {
                    filterName = XmlUtils.getElementText((Element)n).trim();
                    continue;
                }
                if (n.getNodeName().equals("url-pattern")) {
                    urlPattern = XmlUtils.getElementText((Element)n).trim();
                    continue;
                }
                if (n.getNodeName().equals("servlet-name") || !log.isLoggable(Level.FINE)) continue;
                log.fine("Ignored element '" + n.getNodeName() + "' as child of '" + filterMappingElem.getNodeName() + "'.");
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Ignored node '" + n.getNodeName() + "' of type " + n.getNodeType());
        }
        this._webXml.addFilterMapping(filterName, urlPattern);
    }

    private class _EntityResolver
    implements EntityResolver {
        private _EntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException {
            if (systemId == null) {
                throw new UnsupportedOperationException("systemId must not be null");
            }
            if (systemId.equals(WebXmlParser.WEB_APP_2_2_SYSTEM_ID) || systemId.equals(WebXmlParser.WEB_APP_2_2_J2EE_SYSTEM_ID)) {
                return WebXmlParser.this.createClassloaderInputSource(publicId, WebXmlParser.WEB_APP_2_2_RESOURCE);
            }
            if (systemId.equals(WebXmlParser.WEB_APP_2_3_SYSTEM_ID)) {
                return WebXmlParser.this.createClassloaderInputSource(publicId, WebXmlParser.WEB_APP_2_3_RESOURCE);
            }
            return WebXmlParser.this.createContextInputSource(publicId, systemId);
        }
    }
}

