/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PreDestroyViewMapEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.view.ViewScopeCDIMap;
import org.apache.myfaces.cdi.view.ViewScopeContextualStorageHolder;
import org.apache.myfaces.util.ExternalSpecifications;

public class ViewScopeProxyMap
extends HashMap<String, Object>
implements StateHolder {
    private String viewScopeId;
    private transient Map<String, Object> delegate;

    public String getViewScopeId() {
        return this.viewScopeId;
    }

    public void forceDelegateCreation(FacesContext facesContext) {
        this.getDelegate();
    }

    public Map<String, Object> getDelegate() {
        if (this.delegate == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null || !ExternalSpecifications.isCDIAvailable(facesContext.getExternalContext())) {
                this.delegate = new HashMap<String, Object>();
            } else {
                if (this.viewScopeId == null) {
                    BeanManager beanManager = CDIUtils.getBeanManager(facesContext);
                    ViewScopeContextualStorageHolder beanHolder = CDIUtils.get(beanManager, ViewScopeContextualStorageHolder.class);
                    this.viewScopeId = beanHolder.generateUniqueViewScopeId();
                }
                this.delegate = new ViewScopeCDIMap(this.viewScopeId);
            }
        }
        return this.delegate;
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getDelegate().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getDelegate().containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.getDelegate().get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.getDelegate().put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.getDelegate().remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.getDelegate().putAll(m);
    }

    @Override
    public void clear() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getApplication().publishEvent(facesContext, PreDestroyViewMapEvent.class, (Object)facesContext.getViewRoot());
        this.getDelegate().clear();
    }

    @Override
    public Set<String> keySet() {
        return this.getDelegate().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.getDelegate().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.getDelegate().entrySet();
    }

    public void restoreState(FacesContext context, Object state) {
        this.viewScopeId = (String)state;
    }

    public Object saveState(FacesContext context) {
        return this.viewScopeId;
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

