/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces;

import jakarta.el.ValueExpression;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class FaceletState
implements StateHolder,
Serializable {
    private static final long serialVersionUID = -7823771271935942737L;
    private Map<String, Object> stateMap;
    private Map<String, Map<String, ValueExpression>> bindingsMap;

    public Object getState(String key) {
        if (this.stateMap == null) {
            return null;
        }
        return this.stateMap.get(key);
    }

    public Object putState(String key, Object value) {
        if (this.stateMap == null) {
            this.stateMap = new HashMap<String, Object>();
        }
        return this.stateMap.put(key, value);
    }

    @Override
    public Object saveState(FacesContext context) {
        UIViewRoot root = context.getViewRoot();
        if (root != null && root.initialStateMarked()) {
            if (this.stateMap != null) {
                Object[] values = new Object[]{UIComponentBase.saveAttachedState(context, this.stateMap)};
                return values;
            }
            return null;
        }
        Object[] values = new Object[]{UIComponentBase.saveAttachedState(context, this.stateMap), UIComponentBase.saveAttachedState(context, this.bindingsMap)};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            this.stateMap = null;
            this.bindingsMap = null;
            return;
        }
        Object[] values = (Object[])state;
        if (values.length == 2) {
            this.stateMap = (Map)UIComponentBase.restoreAttachedState(context, values[0]);
            this.bindingsMap = (Map)UIComponentBase.restoreAttachedState(context, values[1]);
        } else {
            this.stateMap = values[0] == null ? null : (Map)UIComponentBase.restoreAttachedState(context, values[0]);
        }
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
    }

    public boolean isDynamic() {
        return this.stateMap == null ? false : !this.stateMap.isEmpty();
    }

    public void putBinding(String uniqueId, String key, ValueExpression expr) {
        Map<String, ValueExpression> bindings;
        if (this.bindingsMap == null) {
            this.bindingsMap = new HashMap<String, Map<String, ValueExpression>>();
        }
        if ((bindings = this.bindingsMap.get(uniqueId)) == null) {
            bindings = new HashMap<String, ValueExpression>();
            this.bindingsMap.put(uniqueId, bindings);
        }
        bindings.put(key, expr);
    }

    public ValueExpression getBinding(String uniqueId, String key) {
        if (this.bindingsMap == null) {
            return null;
        }
        Map<String, ValueExpression> bindings = this.bindingsMap.get(uniqueId);
        if (bindings == null) {
            return null;
        }
        return bindings.get(key);
    }

    public Map<String, Map<String, ValueExpression>> getBindings() {
        return this.bindingsMap;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.stateMap != null ? this.stateMap.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FaceletState other = (FaceletState)obj;
        return this.stateMap == other.stateMap || this.stateMap != null && this.stateMap.equals(other.stateMap);
    }
}

