/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.main;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpt.sun.tools.javac.api.BasicJavacTask;
import jpt.sun.tools.javac.file.BaseFileManager;
import jpt.sun.tools.javac.file.CacheFSInfo;
import jpt.sun.tools.javac.file.JavacFileManager;
import jpt.sun.tools.javac.jvm.Target;
import jpt.sun.tools.javac.main.Arguments;
import jpt.sun.tools.javac.main.DelegatingJavaFileManager;
import jpt.sun.tools.javac.main.JavaCompiler;
import jpt.sun.tools.javac.main.Option;
import jpt.sun.tools.javac.main.OptionHelper;
import jpt.sun.tools.javac.processing.AnnotationProcessingError;
import jpt.sun.tools.javac.resources.CompilerProperties;
import jpt.sun.tools.javac.util.ClientCodeException;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.Dependencies;
import jpt.sun.tools.javac.util.FatalError;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.Log;
import jpt.sun.tools.javac.util.Options;
import jpt.sun.tools.javac.util.PropagatedException;
import jpt30.tools.JavaFileManager;

public class Main {
    String ownName;
    PrintWriter stdOut;
    PrintWriter stdErr;
    public Log log;
    boolean apiMode;
    private static final String ENV_OPT_NAME = "JDK_JAVAC_OPTIONS";
    private JavaFileManager fileManager;
    public static final String javacBundleName = "jpt.sun.tools.javac.resources.javac";

    public Main(String name) {
        this.ownName = name;
    }

    public Main(String name, PrintWriter out) {
        this.ownName = name;
        this.stdOut = this.stdErr = out;
    }

    public Main(String name, PrintWriter out, PrintWriter err) {
        this.ownName = name;
        this.stdOut = out;
        this.stdErr = err;
    }

    void reportDiag(JCDiagnostic.DiagnosticInfo diag) {
        if (this.apiMode) {
            String msg = this.log.localize(diag);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.reportHelper(diag);
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", this.ownName);
    }

    void reportHelper(JCDiagnostic.DiagnosticInfo diag) {
        String errorPrefix;
        String msg = this.log.localize(diag);
        msg = msg.startsWith(errorPrefix = this.log.localize(CompilerProperties.Errors.Error)) ? msg : errorPrefix + msg;
        this.log.printRawLines(msg);
    }

    public Result compile(String[] args) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        Result result = this.compile(args, context);
        try {
            if (this.fileManager != null) {
                this.fileManager.close();
            }
        }
        catch (IOException ex) {
            this.bugMessage(ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compile(String[] argv, Context context) {
        String showClass;
        JavaFileManager undel;
        JavaFileManager javaFileManager;
        boolean batchMode;
        if (this.stdOut != null) {
            context.put(Log.outKey, this.stdOut);
        }
        if (this.stdErr != null) {
            context.put(Log.errKey, this.stdErr);
        }
        this.log = Log.instance(context);
        if (argv.length == 0) {
            OptionHelper.GrumpyHelper h = new OptionHelper.GrumpyHelper(this.log){

                @Override
                public String getOwnName() {
                    return Main.this.ownName;
                }

                @Override
                public void put(String name, String value) {
                }
            };
            try {
                Option.HELP.process(h, "-help");
            }
            catch (Option.InvalidValueException invalidValueException) {
                // empty catch block
            }
            return Result.CMDERR;
        }
        java.util.List<String> allArgs = Arrays.asList(argv);
        Arguments args = Arguments.instance(context);
        args.init(this.ownName, allArgs);
        if (this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        Options options = Options.instance(context);
        boolean forceStdOut = options.isSet("stdout");
        if (forceStdOut) {
            this.log.flush();
            this.log.setWriters(new PrintWriter(System.out, true));
        }
        boolean bl = batchMode = options.isUnset("nonBatchMode") && System.getProperty("nonBatchMode") == null;
        if (batchMode) {
            CacheFSInfo.preRegister(context);
        }
        boolean ok = true;
        this.fileManager = context.get(JavaFileManager.class);
        JavaFileManager javaFileManager2 = this.fileManager;
        if (javaFileManager2 instanceof DelegatingJavaFileManager) {
            DelegatingJavaFileManager delegatingJavaFileManager = (DelegatingJavaFileManager)javaFileManager2;
            javaFileManager = delegatingJavaFileManager.getBaseFileManager();
        } else {
            javaFileManager = undel = this.fileManager;
        }
        if (undel instanceof BaseFileManager) {
            BaseFileManager baseFileManager = (BaseFileManager)undel;
            baseFileManager.setContext(context);
            ok &= baseFileManager.handleOptions(args.getDeferredFileManagerOptions());
        }
        if ((showClass = options.get("showClass")) != null) {
            if (showClass.equals("showClass")) {
                showClass = "jpt.sun.tools.javac.Main";
            }
            this.showClass(showClass);
        }
        if (!(ok &= args.validate()) || this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        if (args.isEmpty()) {
            return Result.OK;
        }
        if (options.isSet("debug.completionDeps")) {
            Dependencies.GraphDependencies.preRegister(context);
        }
        BasicJavacTask t = (BasicJavacTask)BasicJavacTask.instance(context);
        Set<List<String>> pluginOpts = args.getPluginOpts();
        t.initPlugins(pluginOpts);
        if (this.fileManager.isSupportedOption(Option.MULTIRELEASE.primaryName) == 1) {
            Target target = Target.instance(context);
            List<String> list = List.of(target.multiReleaseValue());
            this.fileManager.handleOption(Option.MULTIRELEASE.primaryName, list.iterator());
        }
        JavaCompiler comp = JavaCompiler.instance(context);
        List<String> docLintOpts = args.getDocLintOpts();
        if (!docLintOpts.isEmpty()) {
            t.initDocLint(docLintOpts);
        }
        if (options.get(Option.XSTDOUT) != null) {
            comp.closeables = comp.closeables.prepend(this.log.getWriter(Log.WriterKind.NOTICE));
        }
        boolean printArgsToFile = options.isSet("printArgsToFile");
        try {
            comp.compile(args.getFileObjects(), args.getClassNames(), null, List.nil());
            if (this.log.expectDiagKeys != null) {
                if (this.log.expectDiagKeys.isEmpty()) {
                    this.log.printRawLines("all expected diagnostics found");
                    Result result = Result.OK;
                    return result;
                }
                this.log.printRawLines("expected diagnostic keys not found: " + this.log.expectDiagKeys);
                Result result = Result.ERROR;
                return result;
            }
            Result result = comp.errorCount() == 0 ? Result.OK : Result.ERROR;
            return result;
        }
        catch (OutOfMemoryError | StackOverflowError ex) {
            this.resourceMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (FatalError ex) {
            this.feMessage(ex, options);
            Result result = Result.SYSERR;
            return result;
        }
        catch (AnnotationProcessingError ex) {
            this.apMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (IllegalAccessError iae) {
            if (this.twoClassLoadersInUse(iae)) {
                this.bugMessage(iae);
            }
            printArgsToFile = true;
            Result result = Result.ABNORMAL;
            return result;
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || options.isSet("dev")) {
                this.bugMessage(ex);
            }
            printArgsToFile = true;
            Result result = Result.ABNORMAL;
            return result;
        }
        finally {
            if (printArgsToFile) {
                this.printArgumentsToFile(argv);
            }
            if (comp != null) {
                try {
                    comp.close();
                }
                catch (ClientCodeException ex) {
                    throw new RuntimeException(ex.getCause());
                }
            }
        }
    }

    void printArgumentsToFile(String ... params) {
        Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        Path out = tmpDir.resolve(String.format("javac.%s.args", new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime())));
        String strOut = "# javac crashed, this report includes the parameters passed to it in the @-file format\n";
        try {
            try (BufferedWriter w = Files.newBufferedWriter(out, new OpenOption[0]);){
                for (String param : params) {
                    if ((param = param.replaceAll("\\\\", "\\\\\\\\")).matches(".*\\s+.*")) {
                        param = "\"" + param + "\"";
                    }
                    strOut = strOut + param + '\n';
                }
                w.write(strOut);
            }
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.parameters.output", out.toAbsolutePath());
        }
        catch (IOException ioe) {
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.parameters.output.error", out.toAbsolutePath());
            System.err.println(strOut);
            System.err.println();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean twoClassLoadersInUse(IllegalAccessError iae) {
        String msg = iae.getMessage();
        Pattern pattern = Pattern.compile("(?i)(?<=tried to access class )([a-z_$][a-z\\d_$]*\\.)*[a-z_$][a-z\\d_$]*");
        Matcher matcher = pattern.matcher(msg);
        if (!matcher.find()) {
        }
        try {
            String otherClassName = matcher.group(0);
            Class<?> otherClass = Class.forName(otherClassName);
            ClassLoader otherClassLoader = otherClass.getClassLoader();
            ClassLoader javacClassLoader = this.getClass().getClassLoader();
            if (javacClassLoader != otherClassLoader) {
                CodeSource otherClassCodeSource = otherClass.getProtectionDomain().getCodeSource();
                CodeSource javacCodeSource = this.getClass().getProtectionDomain().getCodeSource();
                if (otherClassCodeSource != null && javacCodeSource != null) {
                    this.log.printLines(CompilerProperties.Errors.TwoClassLoaders2(otherClassCodeSource.getLocation(), javacCodeSource.getLocation()));
                    return true;
                }
                this.log.printLines(CompilerProperties.Errors.TwoClassLoaders1);
                return true;
            }
        }
        finally {
            return false;
        }
    }

    void bugMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.bug", JavaCompiler.version());
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void feMessage(Throwable ex, Options options) {
        this.log.printRawLines(ex.getMessage());
        if (ex.getCause() != null && options.isSet("dev")) {
            ex.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
        }
    }

    void ioMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void resourceMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.resource", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void apMessage(AnnotationProcessingError ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.proc.annotation.uncaught.exception", new Object[0]);
        ex.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void pluginMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.plugin.uncaught.exception", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void showClass(String className) {
        PrintWriter pw = this.log.getWriter(Log.WriterKind.NOTICE);
        pw.println("javac: show class: " + className);
        URL url = this.getClass().getResource('/' + className.replace('.', '/') + ".class");
        if (url != null) {
            pw.println("  " + url);
        }
        try (InputStream in = this.getClass().getResourceAsStream('/' + className.replace('.', '/') + ".class");){
            byte[] digest;
            String algorithm = "SHA-256";
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            try (DigestInputStream din = new DigestInputStream(in, md);){
                int n;
                byte[] buf = new byte[8192];
                while ((n = din.read(buf)) > 0) {
                }
                digest = md.digest();
            }
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b));
            }
            pw.println("  SHA-256 checksum: " + sb);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            pw.println("  cannot compute digest: " + e);
        }
    }

    public static enum Result {
        OK(0),
        ERROR(1),
        CMDERR(2),
        SYSERR(3),
        ABNORMAL(4);

        public final int exitCode;

        private Result(int exitCode) {
            this.exitCode = exitCode;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }
    }
}

