/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.providers.code;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jpt.sun.source.tree.Tree;
import org.netbeans.modules.java.hints.providers.code.FSWrapper;
import org.netbeans.modules.java.hints.providers.code.ReflectiveCustomizerProvider;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.providers.spi.HintProvider;
import org.netbeans.modules.java.hints.providers.spi.Trigger;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.BooleanOption;
import org.netbeans.spi.java.hints.ConstraintVariableType;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.Hint;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.IntegerOption;
import org.netbeans.spi.java.hints.TriggerOptions;
import org.netbeans.spi.java.hints.TriggerPattern;
import org.netbeans.spi.java.hints.TriggerPatterns;
import org.netbeans.spi.java.hints.TriggerTreeKind;
import org.netbeans.spi.java.hints.UseOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;

public class CodeHintProviderImpl
implements HintProvider {
    private static final Logger LOG = Logger.getLogger(WorkerImpl.class.getName());

    @Override
    public Map<HintMetadata, ? extends Collection<? extends HintDescription>> computeHints() {
        HashMap<HintMetadata, Collection<HintDescription>> result = new HashMap<HintMetadata, Collection<HintDescription>>();
        for (FSWrapper.ClassWrapper classWrapper : FSWrapper.listClasses()) {
            try {
                CodeHintProviderImpl.processClass(classWrapper, result);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Exceptions.printStackTrace(t);
            }
        }
        return result;
    }

    static ClassLoader findLoader() {
        ClassLoader l = Lookup.getDefault().lookup(ClassLoader.class);
        if (l == null) {
            return CodeHintProviderImpl.class.getClassLoader();
        }
        return l;
    }

    public static void processClass(FSWrapper.ClassWrapper clazz, Map<HintMetadata, Collection<HintDescription>> result) throws SecurityException {
        HintMetadata hm;
        Hint metadata = clazz.getAnnotation(Hint.class);
        if (metadata != null) {
            String id = metadata.id();
            if (id == null || id.isEmpty()) {
                id = clazz.getName();
            }
            hm = CodeHintProviderImpl.fromAnnotation(id, clazz, null, metadata);
        } else {
            hm = null;
        }
        for (FSWrapper.MethodWrapper methodWrapper : clazz.getMethods()) {
            HintMetadata localMetadata;
            Hint localMetadataAnnotation = methodWrapper.getAnnotation(Hint.class);
            if (localMetadataAnnotation != null) {
                Object localID = localMetadataAnnotation.id();
                if (localID == null || ((String)localID).isEmpty()) {
                    localID = clazz.getName() + "." + methodWrapper.getName();
                }
                localMetadata = CodeHintProviderImpl.fromAnnotation((String)localID, clazz, methodWrapper, localMetadataAnnotation);
            } else {
                localMetadata = hm;
            }
            if (localMetadata == null) continue;
            CodeHintProviderImpl.processMethod(result, methodWrapper, localMetadata);
        }
    }

    private static HintMetadata fromAnnotation(String id, FSWrapper.ClassWrapper clazz, FSWrapper.MethodWrapper method, Hint metadata) {
        HintMetadata hm = HintMetadata.Builder.create(id).setDescription(metadata.displayName(), metadata.description()).setCategory(metadata.category()).setEnabled(metadata.enabled()).setSeverity(metadata.severity()).setKind(metadata.hintKind()).setCustomizerProvider(CodeHintProviderImpl.createCustomizerProvider(clazz, method, id, metadata)).addSuppressWarnings(metadata.suppressWarnings()).addOptions((HintMetadata.Options[])HintMetadata.Options.fromHintOptions(metadata.options()).toArray(HintMetadata.Options[]::new)).setSourceVersion(metadata.minSourceVersion()).build();
        return hm;
    }

    private static CustomizerProvider createCustomizerProvider(FSWrapper.ClassWrapper clazz, FSWrapper.MethodWrapper method, String id, Hint hint) {
        Class<? extends CustomizerProvider> customizerClass = hint.customizerProvider();
        if (customizerClass != CustomizerProvider.class) {
            return new DelegatingCustomizerProvider(customizerClass);
        }
        HashSet<String> allowedOptions = null;
        if (method != null) {
            UseOptions useOptions = method.getAnnotation(UseOptions.class);
            if (useOptions == null) {
                return null;
            }
            allowedOptions = new HashSet<String>(Arrays.asList(useOptions.value()));
        }
        ArrayList<ReflectiveCustomizerProvider.OptionDescriptor> declarativeOptions = new ArrayList<ReflectiveCustomizerProvider.OptionDescriptor>();
        for (FSWrapper.FieldWrapper fieldWrapper : clazz.getFields()) {
            String tooltip;
            String displayName;
            Comparable<Boolean> defValue;
            BooleanOption option = fieldWrapper.getAnnotation(BooleanOption.class);
            IntegerOption iOption = fieldWrapper.getAnnotation(IntegerOption.class);
            String key = fieldWrapper.getConstantValue();
            if (key == null || allowedOptions != null && !allowedOptions.contains(key)) continue;
            if (option != null) {
                defValue = option.defaultValue();
                displayName = option.displayName();
                tooltip = option.tooltip();
            } else if (iOption != null) {
                defValue = iOption.defaultValue();
                displayName = iOption.displayName();
                tooltip = iOption.tooltip();
            } else {
                return null;
            }
            declarativeOptions.add(new ReflectiveCustomizerProvider.OptionDescriptor(key, defValue, displayName, tooltip, option != null ? option : iOption));
        }
        return !declarativeOptions.isEmpty() ? new ReflectiveCustomizerProvider(clazz.getName(), id, declarativeOptions) : null;
    }

    static void processMethod(Map<HintMetadata, Collection<HintDescription>> hints, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        CodeHintProviderImpl.processTreeKindHint(hints, m, metadata);
        CodeHintProviderImpl.processPatternHint(hints, m, metadata);
    }

    private static void processTreeKindHint(Map<HintMetadata, Collection<HintDescription>> hints, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        TriggerTreeKind kindTrigger = m.getAnnotation(TriggerTreeKind.class);
        if (kindTrigger == null) {
            return;
        }
        TriggerOptions opts = m.getAnnotation(TriggerOptions.class);
        WorkerImpl w = new WorkerImpl(m.getClazz().getName(), m.getName());
        EnumSet<Tree.Kind> kinds = EnumSet.noneOf(Tree.Kind.class);
        kinds.addAll(Arrays.asList(kindTrigger.value()));
        CodeHintProviderImpl.addHint(hints, metadata, HintDescriptionFactory.create().setTrigger(new Trigger.Kinds(kinds)).setTriggerOptions(opts == null ? null : opts.value()).setWorker(w).setMetadata(metadata).produce());
    }

    private static void processPatternHint(Map<HintMetadata, Collection<HintDescription>> hints, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        TriggerPattern patternTrigger = m.getAnnotation(TriggerPattern.class);
        if (patternTrigger != null) {
            CodeHintProviderImpl.processPatternHint(hints, patternTrigger, m, metadata);
            return;
        }
        TriggerPatterns patternTriggers = m.getAnnotation(TriggerPatterns.class);
        if (patternTriggers != null) {
            for (TriggerPattern pattern : patternTriggers.value()) {
                CodeHintProviderImpl.processPatternHint(hints, pattern, m, metadata);
            }
        }
    }

    private static void processPatternHint(Map<HintMetadata, Collection<HintDescription>> hints, TriggerPattern patternTrigger, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        String pattern = patternTrigger.value();
        HashMap<String, String> constraints = new HashMap<String, String>();
        for (ConstraintVariableType c : patternTrigger.constraints()) {
            constraints.put(c.variable(), c.type());
        }
        TriggerOptions opts = m.getAnnotation(TriggerOptions.class);
        Trigger.PatternDescription pd = Trigger.PatternDescription.create(pattern, constraints, new String[0]);
        CodeHintProviderImpl.addHint(hints, metadata, HintDescriptionFactory.create().setTrigger(pd).setTriggerOptions(opts == null ? null : opts.value()).setWorker(new WorkerImpl(m.getClazz().getName(), m.getName())).setMetadata(metadata).produce());
    }

    private static void addHint(Map<HintMetadata, Collection<HintDescription>> hints, HintMetadata metadata, HintDescription hint) {
        hints.computeIfAbsent(metadata, k -> new LinkedList()).add(hint);
    }

    private record DelegatingCustomizerProvider(Class<? extends CustomizerProvider> component) implements CustomizerProvider
    {
        @Override
        public JComponent getCustomizer(Preferences prefs) {
            try {
                return this.component.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getCustomizer(prefs);
            }
            catch (ReflectiveOperationException ex) {
                Exceptions.printStackTrace(ex);
                return new JPanel();
            }
        }
    }

    static final class WorkerImpl
    implements HintDescription.Worker {
        private final String className;
        private final String methodName;
        private final AtomicReference<Method> methodRef = new AtomicReference();
        private Set<FileObject> exceptionThrownFor;

        public WorkerImpl(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
            block12: {
                try {
                    Object result;
                    Method method = this.methodRef.get();
                    if (method == null) {
                        method = this.getMethod();
                        this.methodRef.set(method);
                    }
                    if ((result = method.invoke(null, ctx)) == null) {
                        return null;
                    }
                    if (result instanceof Iterable) {
                        Iterable iterable = (Iterable)result;
                        LinkedList<ErrorDescription> out = new LinkedList<ErrorDescription>();
                        for (ErrorDescription ed : NbCollections.iterable(NbCollections.checkedIteratorByFilter(iterable.iterator(), ErrorDescription.class, false))) {
                            out.add(ed);
                        }
                        return out;
                    }
                    if (result instanceof ErrorDescription) {
                        ErrorDescription desc = (ErrorDescription)result;
                        return List.of(desc);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException ex) {
                    Exceptions.printStackTrace(ex);
                }
                catch (InvocationTargetException ex) {
                    boolean newOccurrence;
                    WorkerImpl workerImpl = this;
                    synchronized (workerImpl) {
                        if (this.exceptionThrownFor == null) {
                            this.exceptionThrownFor = Collections.newSetFromMap(new WeakHashMap());
                        }
                        newOccurrence = this.exceptionThrownFor.add(ctx.getInfo().getFileObject());
                    }
                    if (!newOccurrence) break block12;
                    LOG.log(Level.INFO, this.className + "." + this.methodName, ex);
                    Exceptions.printStackTrace(ex.getCause());
                }
            }
            return null;
        }

        Method getMethod() throws NoSuchMethodException, ClassNotFoundException {
            return FSWrapper.resolveMethod(this.className, this.methodName);
        }
    }
}

