/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.spi;

import java.util.LinkedHashSet;
import java.util.concurrent.Executor;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.progress.spi.Controller;
import org.netbeans.modules.progress.spi.InternalHandle;

public final class TaskModel {
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private final DefaultListModel<InternalHandle> model = new DefaultListModel();
    private InternalHandle explicit;
    private final LinkedHashSet<ListDataListener> dataListeners = new LinkedHashSet();
    private final LinkedHashSet<ListSelectionListener> selectionListeners = new LinkedHashSet();
    private final Executor eventExecutor;

    TaskModel(Executor eventExecutor) {
        TaskListener list = new TaskListener();
        this.model.addListDataListener(list);
        this.selectionModel.addListSelectionListener(list);
        this.eventExecutor = eventExecutor;
    }

    public TaskModel() {
        this(Controller.getDefault().getEventExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandle(InternalHandle handle) {
        DefaultListModel<InternalHandle> defaultListModel = this.model;
        synchronized (defaultListModel) {
            this.model.addElement(handle);
        }
        this.updateSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandle(InternalHandle handle) {
        if (this.explicit == handle) {
            this.explicit = null;
        }
        DefaultListModel<InternalHandle> defaultListModel = this.model;
        synchronized (defaultListModel) {
            this.model.removeElement(handle);
        }
        this.updateSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSelection() {
        if (this.explicit != null) {
            return;
        }
        InternalHandle oldSelected = this.getSelectedHandle();
        if (oldSelected != null && !oldSelected.isInSleepMode()) {
            return;
        }
        InternalHandle toSelect = null;
        DefaultListModel<InternalHandle> defaultListModel = this.model;
        synchronized (defaultListModel) {
            for (int i = 0; i < this.model.size(); ++i) {
                InternalHandle curHandle = this.model.getElementAt(i);
                if (this.getSelectionRating(curHandle) < this.getSelectionRating(toSelect)) continue;
                toSelect = curHandle;
            }
            if (toSelect != null) {
                this.selectionModel.setSelectionInterval(this.model.indexOf(toSelect), this.model.indexOf(toSelect));
            } else {
                this.selectionModel.clearSelection();
            }
        }
    }

    private int getSelectionRating(InternalHandle handle) {
        int result = 0;
        if (handle != null) {
            if (!handle.isInSleepMode()) {
                result += 4;
            }
            if (handle.isUserInitialized()) {
                result += 2;
            }
            ++result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void explicitlySelect(InternalHandle handle) {
        this.explicit = handle;
        DefaultListModel<InternalHandle> defaultListModel = this.model;
        synchronized (defaultListModel) {
            int index = this.model.indexOf(this.explicit);
            if (index == -1) {
                return;
            }
            this.selectionModel.setSelectionInterval(index, index);
        }
    }

    public InternalHandle getExplicitSelection() {
        return this.explicit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        DefaultListModel<InternalHandle> defaultListModel = this.model;
        synchronized (defaultListModel) {
            return this.model.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalHandle[] getHandles() {
        Object[] handles;
        DefaultListModel<InternalHandle> defaultListModel = this.model;
        synchronized (defaultListModel) {
            handles = new InternalHandle[this.model.size()];
            this.model.copyInto(handles);
        }
        return handles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalHandle getSelectedHandle() {
        DefaultListModel<InternalHandle> defaultListModel = this.model;
        synchronized (defaultListModel) {
            int select = this.selectionModel.getMinSelectionIndex();
            if (select != -1 && select >= 0 && select < this.model.size()) {
                return this.model.getElementAt(select);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListSelectionListener(ListSelectionListener listener) {
        LinkedHashSet<ListSelectionListener> linkedHashSet = this.selectionListeners;
        synchronized (linkedHashSet) {
            this.selectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListSelectionListener(ListSelectionListener listener) {
        LinkedHashSet<ListSelectionListener> linkedHashSet = this.selectionListeners;
        synchronized (linkedHashSet) {
            this.selectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListDataListener(ListDataListener listener) {
        LinkedHashSet<ListDataListener> linkedHashSet = this.dataListeners;
        synchronized (linkedHashSet) {
            this.dataListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListDataListener(ListDataListener listener) {
        LinkedHashSet<ListDataListener> linkedHashSet = this.dataListeners;
        synchronized (linkedHashSet) {
            this.dataListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListDataListener[] getDataListeners() {
        LinkedHashSet<ListDataListener> linkedHashSet = this.dataListeners;
        synchronized (linkedHashSet) {
            return this.dataListeners.toArray(new ListDataListener[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListSelectionListener[] getSelectionListeners() {
        LinkedHashSet<ListSelectionListener> linkedHashSet = this.selectionListeners;
        synchronized (linkedHashSet) {
            return this.selectionListeners.toArray(new ListSelectionListener[0]);
        }
    }

    private class TaskListener
    implements ListDataListener,
    ListSelectionListener {
        private TaskListener() {
        }

        @Override
        public void intervalAdded(final ListDataEvent e) {
            final ListDataListener[] lists = TaskModel.this.getDataListeners();
            TaskModel.this.eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    for (ListDataListener list : lists) {
                        list.intervalAdded(e);
                    }
                }
            });
        }

        @Override
        public void intervalRemoved(final ListDataEvent e) {
            final ListDataListener[] lists = TaskModel.this.getDataListeners();
            TaskModel.this.eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    for (ListDataListener list : lists) {
                        list.intervalRemoved(e);
                    }
                }
            });
        }

        @Override
        public void contentsChanged(final ListDataEvent e) {
            final ListDataListener[] lists = TaskModel.this.getDataListeners();
            TaskModel.this.eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    for (ListDataListener list : lists) {
                        list.contentsChanged(e);
                    }
                }
            });
        }

        @Override
        public void valueChanged(final ListSelectionEvent e) {
            final ListSelectionListener[] lists = TaskModel.this.getSelectionListeners();
            TaskModel.this.eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    for (ListSelectionListener list : lists) {
                        list.valueChanged(e);
                    }
                }
            });
        }
    }
}

