/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.classpath;

import java.io.File;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.scanner.classpath.ClassPathLocationScanner;
import org.flywaydb.core.internal.util.UrlUtils;

public class FileSystemClassPathLocationScanner
implements ClassPathLocationScanner {
    @Generated
    private static final Log LOG = LogFactory.getLog(FileSystemClassPathLocationScanner.class);

    @Override
    public Set<String> findResourceNames(String location, URL locationUrl) {
        String filePath = UrlUtils.toFilePath(locationUrl);
        File folder = new File(filePath);
        if (!folder.isDirectory()) {
            LOG.debug("Skipping path as it is not a directory: " + filePath);
            return new TreeSet<String>();
        }
        Object classPathRootOnDisk = filePath.substring(0, filePath.length() - location.length());
        if (!((String)classPathRootOnDisk).endsWith(File.separator)) {
            classPathRootOnDisk = (String)classPathRootOnDisk + File.separator;
        }
        LOG.debug("Scanning starting at classpath root in filesystem: " + (String)classPathRootOnDisk);
        return this.findResourceNamesFromFileSystem((String)classPathRootOnDisk, location, folder);
    }

    Set<String> findResourceNamesFromFileSystem(String classPathRootOnDisk, String scanRootLocation, File folder) {
        File[] files;
        LOG.debug("Scanning for resources in path: " + folder.getPath() + " (" + scanRootLocation + ")");
        TreeSet<String> resourceNames = new TreeSet<String>();
        for (File file : files = folder.listFiles()) {
            if (!file.canRead()) continue;
            if (file.isDirectory()) {
                if (file.isHidden()) {
                    LOG.debug("Skipping hidden directory: " + file.getAbsolutePath());
                    continue;
                }
                resourceNames.addAll(this.findResourceNamesFromFileSystem(classPathRootOnDisk, scanRootLocation, file));
                continue;
            }
            resourceNames.add(this.toResourceNameOnClasspath(classPathRootOnDisk, file));
        }
        return resourceNames;
    }

    private String toResourceNameOnClasspath(String classPathRootOnDisk, File file) {
        String fileName = file.getAbsolutePath().replace("\\", "/");
        return fileName.substring(classPathRootOnDisk.length());
    }
}

