/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.util.List;
import java.util.Map;
import org.apache.bval.DynamicMetaBean;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.model.Validation;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;

public class ValidationHelper {
    public static void validateContext(ValidationContext<?> context, ValidateCallback s, boolean treatMapsLikeBeans) {
        if (context.getBean() != null) {
            if (!treatMapsLikeBeans && context.getBean() instanceof Map) {
                ValidationHelper.validateMapInContext(context, s);
            } else if (context.getBean() instanceof Iterable) {
                ValidationHelper.validateIterableInContext(context, s);
            } else if (context.getBean() instanceof Object[]) {
                ValidationHelper.validateArrayInContext(context, s);
            } else {
                ValidationHelper.validateBeanInContext(context, s);
            }
        }
    }

    protected static <VL extends ValidationListener> void validateBeanInContext(ValidationContext<VL> context, ValidateCallback s) {
        if (ValidationHelper.getDynamicMetaBean(context) != null) {
            context.setMetaBean(ValidationHelper.getDynamicMetaBean(context).resolveMetaBean(context.getBean()));
        }
        s.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <VL extends ValidationListener> void validateArrayInContext(ValidationContext<VL> context, ValidateCallback s) {
        int index = 0;
        DynamicMetaBean dyn = ValidationHelper.getDynamicMetaBean(context);
        Object[] array = (Object[])context.getBean();
        MetaBean metaBean = context.getMetaBean();
        context.setCurrentIndex(null);
        try {
            for (Object each : array) {
                context.setCurrentIndex(index++);
                if (each == null) continue;
                if (dyn == null) {
                    context.setBean(each);
                } else {
                    context.setBean(each, dyn.resolveMetaBean(each));
                }
                s.validate();
            }
        }
        finally {
            context.moveUp(array, metaBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <VL extends ValidationListener> void validateIterableInContext(ValidationContext<VL> context, ValidateCallback s) {
        boolean positional = context.getBean() instanceof List;
        int index = 0;
        Iterable iterable = (Iterable)context.getBean();
        MetaBean metaBean = context.getMetaBean();
        context.setCurrentIndex(null);
        try {
            DynamicMetaBean dyn = ValidationHelper.getDynamicMetaBean(context);
            for (Object each : iterable) {
                if (positional) {
                    context.setCurrentIndex(index++);
                }
                if (each == null) continue;
                if (dyn == null) {
                    context.setBean(each);
                } else {
                    context.setBean(each, dyn.resolveMetaBean(each));
                }
                s.validate();
            }
        }
        finally {
            context.moveUp(iterable, metaBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <VL extends ValidationListener> void validateMapInContext(ValidationContext<VL> context, ValidateCallback s) {
        Map currentBean = (Map)context.getBean();
        MetaBean metaBean = context.getMetaBean();
        DynamicMetaBean dyn = ValidationHelper.getDynamicMetaBean(context);
        context.setCurrentKey(null);
        try {
            for (Map.Entry entry : currentBean.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                context.setCurrentKey(entry.getKey());
                if (dyn == null) {
                    context.setBean(value);
                } else {
                    context.setBean(value, dyn.resolveMetaBean(value));
                }
                s.validate();
            }
        }
        finally {
            context.moveUp(currentBean, metaBean);
        }
    }

    private static <VL extends ValidationListener> DynamicMetaBean getDynamicMetaBean(ValidationContext<VL> context) {
        return context.getMetaBean() instanceof DynamicMetaBean ? (DynamicMetaBean)context.getMetaBean() : null;
    }

    public static <VL extends ValidationListener> void validateBean(ValidationContext<VL> context) {
        for (MetaProperty prop : context.getMetaBean().getProperties()) {
            context.setMetaProperty(prop);
            ValidationHelper.validateProperty(context);
        }
        context.setMetaProperty(null);
        for (Validation validation : context.getMetaBean().getValidations()) {
            validation.validate(context);
        }
    }

    public static <VL extends ValidationListener> void validateProperty(ValidationContext<VL> context) {
        for (Validation validation : context.getMetaProperty().getValidations()) {
            validation.validate(context);
        }
    }

    public static interface ValidateCallback {
        public void validate();
    }
}

