/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import jakarta.validation.ValidationException;
import jakarta.validation.ValidationProviderResolver;
import jakarta.validation.spi.ValidationProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public class DefaultValidationProviderResolver
implements ValidationProviderResolver {
    private static final String SPI_CFG = "META-INF/services/jakarta.validation.spi.ValidationProvider";

    private static ClassLoader getCurrentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl == null ? DefaultValidationProviderResolver.class.getClassLoader() : cl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ValidationProvider<?>> getValidationProviders() {
        ArrayList providers = new ArrayList();
        try {
            ClassLoader cl = DefaultValidationProviderResolver.getCurrentClassLoader();
            Enumeration<URL> cfgs = cl.getResources(SPI_CFG);
            while (cfgs.hasMoreElements()) {
                URL url = cfgs.nextElement();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()), 256);){
                    br.lines().filter(s -> s.charAt(0) != '#').map(String::trim).forEach(line -> {
                        try {
                            Class<ValidationProvider> providerType = cl.loadClass((String)line).asSubclass(ValidationProvider.class);
                            providers.add(Reflection.newInstance(providerType));
                        }
                        catch (ClassNotFoundException e) {
                            throw new ValidationException("Failed to load provider " + line + " configured in file " + url, e);
                        }
                    });
                }
                catch (IOException e) {
                    throw new ValidationException("Error trying to read " + url, e);
                    return providers;
                }
            }
        }
        catch (IOException e) {
            throw new ValidationException("Error trying to read a META-INF/services/jakarta.validation.spi.ValidationProvider", e);
        }
    }
}

