/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.apache.pdfbox.debugger.ui.MenuBase;
import org.apache.pdfbox.rendering.ImageType;

public final class ImageTypeMenu
extends MenuBase {
    public static final String IMAGETYPE_RGB = "RGB";
    public static final String IMAGETYPE_ARGB = "ARGB";
    public static final String IMAGETYPE_GRAY = "Gray";
    public static final String IMAGETYPE_BITONAL = "Bitonal";
    private static ImageTypeMenu instance;
    private JRadioButtonMenuItem rgbItem;
    private JRadioButtonMenuItem argbItem;
    private JRadioButtonMenuItem grayItem;
    private JRadioButtonMenuItem bitonalItem;

    private ImageTypeMenu() {
        this.setMenu(this.createMenu());
    }

    public static ImageTypeMenu getInstance() {
        if (instance == null) {
            instance = new ImageTypeMenu();
        }
        return instance;
    }

    public void setImageTypeSelection(String selection) {
        if (IMAGETYPE_RGB.equals(selection)) {
            this.rgbItem.setSelected(true);
        } else if (IMAGETYPE_ARGB.equals(selection)) {
            this.argbItem.setSelected(true);
        } else if (IMAGETYPE_GRAY.equals(selection)) {
            this.grayItem.setSelected(true);
        } else if (IMAGETYPE_BITONAL.equals(selection)) {
            this.bitonalItem.setSelected(true);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isImageTypeMenu(String actionCommand) {
        return IMAGETYPE_RGB.equals(actionCommand) || IMAGETYPE_ARGB.equals(actionCommand) || IMAGETYPE_GRAY.equals(actionCommand) || IMAGETYPE_BITONAL.equals(actionCommand);
    }

    public static ImageType getImageType() {
        if (ImageTypeMenu.instance.argbItem.isSelected()) {
            return ImageType.ARGB;
        }
        if (ImageTypeMenu.instance.grayItem.isSelected()) {
            return ImageType.GRAY;
        }
        if (ImageTypeMenu.instance.bitonalItem.isSelected()) {
            return ImageType.BINARY;
        }
        return ImageType.RGB;
    }

    public static ImageType getImageType(String actionCommand) {
        if (IMAGETYPE_RGB.equals(actionCommand)) {
            return ImageType.RGB;
        }
        if (IMAGETYPE_ARGB.equals(actionCommand)) {
            return ImageType.ARGB;
        }
        if (IMAGETYPE_GRAY.equals(actionCommand)) {
            return ImageType.GRAY;
        }
        if (IMAGETYPE_BITONAL.equals(actionCommand)) {
            return ImageType.BINARY;
        }
        throw new IllegalArgumentException();
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu();
        menu.setText("Image type");
        this.rgbItem = new JRadioButtonMenuItem();
        this.argbItem = new JRadioButtonMenuItem();
        this.grayItem = new JRadioButtonMenuItem();
        this.bitonalItem = new JRadioButtonMenuItem();
        this.rgbItem.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rgbItem);
        bg.add(this.argbItem);
        bg.add(this.grayItem);
        bg.add(this.bitonalItem);
        this.rgbItem.setText(IMAGETYPE_RGB);
        this.argbItem.setText(IMAGETYPE_ARGB);
        this.grayItem.setText(IMAGETYPE_GRAY);
        this.bitonalItem.setText(IMAGETYPE_BITONAL);
        menu.add(this.rgbItem);
        menu.add(this.argbItem);
        menu.add(this.grayItem);
        menu.add(this.bitonalItem);
        return menu;
    }
}

