/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageBuilder;
import org.apache.rocketmq.client.java.message.MessageImpl;

public class MessageBuilderImpl
implements MessageBuilder {
    public static final Pattern TOPIC_PATTERN = Pattern.compile("^[%a-zA-Z0-9_-]+$");
    private String topic = null;
    private byte[] body = null;
    private String tag = null;
    private String messageGroup = null;
    private String traceContext = null;
    private Long deliveryTimestamp = null;
    private Collection<String> keys = new HashSet<String>();
    private final Map<String, String> properties = new HashMap<String, String>();

    public MessageBuilder setTopic(String topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"topic should not be null");
        Preconditions.checkArgument((boolean)TOPIC_PATTERN.matcher(topic).matches(), (String)"topic does not match the regex [regex=%s]", (Object)TOPIC_PATTERN.pattern());
        this.topic = topic;
        return this;
    }

    public MessageBuilder setBody(byte[] body) {
        Preconditions.checkNotNull((Object)body, (Object)"body should not be null");
        this.body = (byte[])body.clone();
        return this;
    }

    public MessageBuilder setTag(String tag) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tag), (Object)"tag should not be blank");
        Preconditions.checkArgument((!tag.contains("|") ? 1 : 0) != 0, (Object)"tag should not contain \"|\"");
        this.tag = tag;
        return this;
    }

    public MessageBuilder setKeys(String ... keys) {
        for (String key : keys) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)key), (Object)"key should not be blank");
        }
        this.keys = new ArrayList<String>();
        this.keys.addAll(Arrays.asList(keys));
        return this;
    }

    public MessageBuilder setMessageGroup(String messageGroup) {
        Preconditions.checkArgument((null == this.deliveryTimestamp ? 1 : 0) != 0, (Object)"messageGroup and deliveryTimestamp should not be set at same time");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)messageGroup), (Object)"messageGroup should not be blank");
        this.messageGroup = messageGroup;
        return this;
    }

    public MessageBuilder setTraceContext(String traceContext) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)traceContext), (Object)"traceContext should not be blank");
        this.traceContext = traceContext;
        return this;
    }

    public MessageBuilder setDeliveryTimestamp(long deliveryTimestamp) {
        Preconditions.checkArgument((null == this.messageGroup ? 1 : 0) != 0, (Object)"deliveryTimestamp and messageGroup should not be set at same time");
        this.deliveryTimestamp = deliveryTimestamp;
        return this;
    }

    public MessageBuilder addProperty(String key, String value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)key), (Object)"key should not be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"value should not be blank");
        this.properties.put(key, value);
        return this;
    }

    public Message build() {
        Preconditions.checkNotNull((Object)this.topic, (Object)"topic has not been set yet");
        Preconditions.checkNotNull((Object)this.body, (Object)"body has not been set yet");
        return new MessageImpl(this.topic, this.body, this.tag, this.keys, this.messageGroup, this.traceContext, this.deliveryTimestamp, this.properties);
    }
}

