/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.dashboard.client;

import org.apache.servicecomb.dashboard.client.DashboardAddressManager;
import org.apache.servicecomb.dashboard.client.DashboardOperation;
import org.apache.servicecomb.dashboard.client.model.MonitorData;
import org.apache.servicecomb.http.client.common.HttpRequest;
import org.apache.servicecomb.http.client.common.HttpResponse;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardClient
implements DashboardOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardClient.class);
    protected HttpTransport httpTransport;
    private final DashboardAddressManager addressManager;

    public DashboardClient(DashboardAddressManager addressManager, HttpTransport httpTransport) {
        this.httpTransport = httpTransport;
        this.addressManager = addressManager;
    }

    @Override
    public void sendData(String url, MonitorData data) {
        String address = this.addressManager.address();
        try {
            HttpRequest httpRequest = new HttpRequest(address + url, null, HttpUtils.serialize((Object)data), "POST");
            HttpResponse httpResponse = this.httpTransport.doRequest(httpRequest);
            if (httpResponse.getStatusCode() != 200) {
                LOGGER.error("send data to [{}] failed, status code [{}], message [{}]", new Object[]{url, httpResponse.getStatusCode(), httpResponse.getContent()});
            }
        }
        catch (Exception e) {
            LOGGER.error("send data to [{}] failed", (Object)url, (Object)e);
        }
    }
}

