/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.stats;

import org.apache.storm.generated.ExecutorSpecificStats;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.generated.SpoutStats;
import org.apache.storm.metric.internal.MultiLatencyStat;
import org.apache.storm.stats.CommonStats;

public class SpoutExecutorStats
extends CommonStats {
    private final MultiLatencyStat completeLatencyStats;

    public SpoutExecutorStats(int rate, int numStatBuckets) {
        super(rate, numStatBuckets);
        this.completeLatencyStats = new MultiLatencyStat(numStatBuckets);
    }

    public MultiLatencyStat getCompleteLatencies() {
        return this.completeLatencyStats;
    }

    @Override
    public void cleanupStats() {
        this.completeLatencyStats.close();
        super.cleanupStats();
    }

    public void spoutAckedTuple(String stream, long latencyMs) {
        this.getAcked().incBy(stream, this.rate);
        this.getCompleteLatencies().record(stream, latencyMs);
    }

    public void spoutFailedTuple(String stream) {
        this.getFailed().incBy(stream, this.rate);
    }

    @Override
    public ExecutorStats renderStats() {
        ExecutorStats ret = new ExecutorStats();
        ret.set_emitted(this.valueStat(this.getEmitted()));
        ret.set_transferred(this.valueStat(this.getTransferred()));
        ret.set_rate(this.rate);
        SpoutStats spoutStats = new SpoutStats(this.valueStat(this.getAcked()), this.valueStat(this.getFailed()), this.valueStat(this.completeLatencyStats));
        ret.set_specific(ExecutorSpecificStats.spout(spoutStats));
        return ret;
    }
}

