/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.List;
import net.sf.jasperreports.engine.CommonReturnValue;
import net.sf.jasperreports.engine.ExpressionReturnValue;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.DesignExpressionReturnValue;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.JRDistinctCountIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCommonReturnValue;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;

public class JRFillExpressionReturnValue
extends JRFillCommonReturnValue
implements ExpressionReturnValue {
    protected final JRExpression expression;

    public JRFillExpressionReturnValue(ExpressionReturnValue returnValue, JRFillObjectFactory factory, BaseReportFiller filler) {
        super(returnValue, factory, filler);
        this.expression = returnValue.getExpression();
    }

    protected JRFillExpressionReturnValue(JRFillExpressionReturnValue fillReturnValue, JRFillCloneFactory factory) {
        super(fillReturnValue, factory);
        this.expression = fillReturnValue.expression;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    protected JRFillCommonReturnValue addDerivedReturnValue(CommonReturnValue parentReturnValue, List<JRFillCommonReturnValue> returnValueList, JRFillObjectFactory factory, BaseReportFiller filler) {
        JRFillExpressionReturnValue returnValue = factory.getReturnValue((ExpressionReturnValue)parentReturnValue);
        returnValue.setDerived(true);
        return this.addReturnValue(returnValue, returnValueList, factory, filler);
    }

    @Override
    protected CommonReturnValue createHelperReturnValue(CommonReturnValue returnValue, String nameSuffix, CalculationEnum calculation) {
        DesignExpressionReturnValue helper = new DesignExpressionReturnValue();
        helper.setToVariable(returnValue.getToVariable() + nameSuffix);
        helper.setExpression(((ExpressionReturnValue)returnValue).getExpression());
        helper.setCalculation(calculation);
        helper.setIncrementerFactoryClassName(helper.getIncrementerFactoryClassName());
        return helper;
    }

    @Override
    protected CommonReturnValue createDistinctCountHelperReturnValue(CommonReturnValue returnValue) {
        DesignExpressionReturnValue helper = new DesignExpressionReturnValue();
        helper.setToVariable(returnValue.getToVariable() + "_DISTINCT_COUNT");
        helper.setExpression(((ExpressionReturnValue)returnValue).getExpression());
        helper.setCalculation(CalculationEnum.NOTHING);
        helper.setIncrementerFactoryClassName(JRDistinctCountIncrementerFactory.class.getName());
        return helper;
    }
}

