/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tika.eval.core.util.ContentTags;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.ToTextContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ContentTagParser {
    private static final ParseContext EMPTY_PARSE_CONTEXT = new ParseContext();

    public static ContentTags parseXML(String html, Set<String> uppercaseTagsOfInterest) throws TikaException, IOException, SAXException {
        HashMap<String, Integer> tags = new HashMap<String, Integer>();
        XHTMLContentTagHandler xhtmlContentTagHandler = new XHTMLContentTagHandler(uppercaseTagsOfInterest, tags);
        XMLReaderUtils.parseSAX(new StringReader(html), (ContentHandler)xhtmlContentTagHandler, EMPTY_PARSE_CONTEXT);
        return new ContentTags(xhtmlContentTagHandler.toString(), tags);
    }

    public static ContentTags parseHTML(String html, Set<String> uppercaseTagsOfInterest) throws SAXException, IOException {
        HashMap<String, Integer> tags = new HashMap<String, Integer>();
        XHTMLContentTagHandler xhtmlContentTagHandler = new XHTMLContentTagHandler(uppercaseTagsOfInterest, tags);
        Document document = Jsoup.parse(html);
        NodeTraversor.filter((NodeFilter)new TikaNodeFilter(xhtmlContentTagHandler), document);
        return new ContentTags(xhtmlContentTagHandler.toString(), tags);
    }

    private static class XHTMLContentTagHandler
    extends ToTextContentHandler {
        private final Map<String, Integer> tags;
        private final Set<String> uppercaseTagsOfInterest;

        public XHTMLContentTagHandler(Set<String> uppercaseTagsOfInterest, Map<String, Integer> tags) {
            this.uppercaseTagsOfInterest = uppercaseTagsOfInterest;
            this.tags = tags;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String uc;
            super.startElement(uri, localName, qName, atts);
            String string = uc = qName == null ? "" : qName.toUpperCase(Locale.ENGLISH);
            if (this.uppercaseTagsOfInterest.contains(uc)) {
                Integer i = this.tags.get(uc);
                if (i == null) {
                    i = 1;
                } else {
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                this.tags.put(uc, i);
            }
        }
    }

    private static class RuntimeSAXException
    extends RuntimeException {
        private SAXException wrapped;

        private RuntimeSAXException(SAXException e) {
            this.wrapped = e;
        }

        SAXException getWrapped() {
            return this.wrapped;
        }
    }

    private static class TikaNodeFilter
    implements NodeFilter {
        boolean ignore = true;
        ContentHandler handler;

        private TikaNodeFilter(ContentHandler handler) {
            this.handler = handler;
        }

        @Override
        public NodeFilter.FilterResult head(Node node, int i) {
            if ("html".equals(node.nodeName())) {
                this.ignore = false;
            }
            if (this.ignore) {
                return NodeFilter.FilterResult.CONTINUE;
            }
            if (node instanceof TextNode) {
                String txt = ((TextNode)node).getWholeText();
                if (txt != null) {
                    char[] chars = txt.toCharArray();
                    try {
                        if (chars.length > 0) {
                            this.handler.characters(chars, 0, chars.length);
                        }
                    }
                    catch (SAXException e) {
                        throw new RuntimeSAXException(e);
                    }
                }
                return NodeFilter.FilterResult.CONTINUE;
            }
            if (node instanceof DataNode) {
                String txt = ((DataNode)node).getWholeData();
                if (txt != null) {
                    char[] chars = txt.toCharArray();
                    try {
                        if (chars.length > 0) {
                            this.handler.characters(chars, 0, chars.length);
                        }
                    }
                    catch (SAXException e) {
                        throw new RuntimeSAXException(e);
                    }
                }
                return NodeFilter.FilterResult.CONTINUE;
            }
            AttributesImpl attributes = new AttributesImpl();
            for (Attribute jsoupAttr : node.attributes()) {
                attributes.addAttribute("", jsoupAttr.getKey(), jsoupAttr.getKey(), "", jsoupAttr.getValue());
            }
            try {
                this.handler.startElement("", node.nodeName(), node.nodeName(), attributes);
            }
            catch (SAXException e) {
                throw new RuntimeSAXException(e);
            }
            return NodeFilter.FilterResult.CONTINUE;
        }

        @Override
        public NodeFilter.FilterResult tail(Node node, int i) {
            if ("html".equals(node.nodeName())) {
                this.ignore = true;
            }
            if (this.ignore) {
                return NodeFilter.FilterResult.CONTINUE;
            }
            if (node instanceof TextNode || node instanceof DataNode) {
                return NodeFilter.FilterResult.CONTINUE;
            }
            try {
                this.handler.endElement("", node.nodeName(), node.nodeName());
            }
            catch (SAXException e) {
                throw new RuntimeSAXException(e);
            }
            return NodeFilter.FilterResult.CONTINUE;
        }
    }
}

