/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.star;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;

public class StarGraphGraphSONDeserializer {
    public static void readStarGraphEdges(Function<Attachable<Edge>, Edge> edgeMaker, StarGraph starGraph, Map<String, Object> vertexData, String direction) throws IOException {
        Map edgeDatas = (Map)vertexData.get(direction);
        for (Map.Entry edgeData : edgeDatas.entrySet()) {
            for (Map inner : (List)edgeData.getValue()) {
                StarGraph.StarEdge starEdge = direction.equals("outE") ? (StarGraph.StarEdge)starGraph.getStarVertex().addOutEdge((String)edgeData.getKey(), starGraph.addVertex(T.id, inner.get("inV")), T.id, inner.get("id")) : (StarGraph.StarEdge)starGraph.getStarVertex().addInEdge((String)edgeData.getKey(), starGraph.addVertex(T.id, inner.get("outV")), T.id, inner.get("id"));
                if (inner.containsKey("properties")) {
                    Map edgePropertyData = (Map)inner.get("properties");
                    for (Map.Entry epd : edgePropertyData.entrySet()) {
                        starEdge.property((String)epd.getKey(), epd.getValue());
                    }
                }
                if (edgeMaker == null) continue;
                edgeMaker.apply(starEdge);
            }
        }
    }

    public static StarGraph readStarGraphVertex(Map<String, Object> vertexData) throws IOException {
        StarGraph starGraph = StarGraph.open();
        starGraph.addVertex(T.id, vertexData.get("id"), T.label, vertexData.get("label"));
        if (vertexData.containsKey("properties")) {
            Map properties = (Map)vertexData.get("properties");
            for (Map.Entry property : properties.entrySet()) {
                for (Map p : (List)property.getValue()) {
                    StarGraph.StarVertexProperty vp = (StarGraph.StarVertexProperty)starGraph.getStarVertex().property(VertexProperty.Cardinality.list, (String)property.getKey(), p.get("value"), T.id, p.get("id"));
                    if (!p.containsKey("properties")) continue;
                    Map edgePropertyData = (Map)p.get("properties");
                    for (Map.Entry epd : edgePropertyData.entrySet()) {
                        vp.property((String)epd.getKey(), epd.getValue());
                    }
                }
            }
        }
        return starGraph;
    }
}

