/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.reference;

import java.util.Collections;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceElement;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class ReferenceEdge
extends ReferenceElement<Edge>
implements Edge {
    private ReferenceVertex inVertex;
    private ReferenceVertex outVertex;

    private ReferenceEdge() {
    }

    public ReferenceEdge(Edge edge) {
        super(edge);
        this.inVertex = new ReferenceVertex(edge.inVertex());
        this.outVertex = new ReferenceVertex(edge.outVertex());
    }

    public ReferenceEdge(Object id, String label, ReferenceVertex inVertex, ReferenceVertex outVertex) {
        super(id, label);
        this.inVertex = inVertex;
        this.outVertex = outVertex;
    }

    @Override
    public <V> Property<V> property(String key, V value) {
        throw Element.Exceptions.propertyAdditionNotSupported();
    }

    @Override
    public void remove() {
        throw Edge.Exceptions.edgeRemovalNotSupported();
    }

    @Override
    public Iterator<Vertex> vertices(Direction direction) {
        if (direction.equals((Object)Direction.OUT)) {
            return IteratorUtils.of(this.outVertex);
        }
        if (direction.equals((Object)Direction.IN)) {
            return IteratorUtils.of(this.inVertex);
        }
        return IteratorUtils.of(this.outVertex, this.inVertex);
    }

    @Override
    public Vertex inVertex() {
        return this.inVertex;
    }

    @Override
    public Vertex outVertex() {
        return this.outVertex;
    }

    @Override
    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        return Collections.emptyIterator();
    }

    public String toString() {
        return StringFactory.edgeString(this);
    }
}

