/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public class DelegatingWriter
extends Writer {
    private final Writer writer;

    public DelegatingWriter(Writer writer) {
        this.writer = Objects.requireNonNull(writer, "delegate writer must not be null");
    }

    @Override
    public void write(int c) throws IOException {
        this.writer.write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.writer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writer.write(str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.writer.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.writer.append(csq, start, end);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.writer.append(c);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

