/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.views.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class CASLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CAS loadCas(IResource r, IPath file) {
        String elementName = r.getLocation().lastSegment();
        int lastIndexOf = elementName.lastIndexOf(".ruta");
        if (lastIndexOf != -1) {
            elementName = elementName.substring(0, lastIndexOf);
        }
        try {
            IPath engineDescriptorPath = RutaProjectUtils.getAnalysisEngineDescriptorPath((IPath)r.getLocation(), (IProject)r.getProject());
            XMLInputSource in = new XMLInputSource(engineDescriptorPath.toPortableString());
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
            String desc = null;
            desc = engineDescriptorPath.toPortableString();
            XMLInputSource in2 = new XMLInputSource(desc);
            XMLizable descriptor = UIMAFramework.getXMLParser().parse(in2);
            CAS testCas = null;
            if (descriptor instanceof AnalysisEngineDescription) {
                testCas = CasCreationUtils.createCas((AnalysisEngineDescription)((AnalysisEngineDescription)descriptor));
            } else if (descriptor instanceof TypeSystemDescription) {
                TypeSystemDescription tsDesc = (TypeSystemDescription)descriptor;
                tsDesc.resolveImports();
                testCas = CasCreationUtils.createCas((TypeSystemDescription)tsDesc, null, (FsIndexDescription[])new FsIndexDescription[0]);
            }
            try (FileInputStream inputStream = null;){
                inputStream = new FileInputStream(new File(file.toPortableString()));
                XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)testCas, (boolean)true);
            }
            return testCas;
        }
        catch (Exception e) {
            RutaAddonsPlugin.error(e);
            return null;
        }
    }
}

