/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.string;

import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.apache.uima.ruta.ide.core.extensions.IIDEBooleanFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IRutaCheckerProblemFactory;
import org.apache.uima.ruta.ide.parser.ast.RutaFunction;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;

public class BooleanOperationsIDEExtension
implements IIDEBooleanFunctionExtension {
    private final String[] strings = new String[]{"contains", "endsWith", "startsWith", "equals", "equalsIgnoreCase", "isEmpty"};

    public String[] getKnownExtensions() {
        return this.strings;
    }

    public boolean checkSyntax(Expression element, IRutaCheckerProblemFactory problemFactory, IProblemReporter rep) throws RecognitionException {
        if (element instanceof RutaFunction) {
            Expression expr;
            RutaFunction f = (RutaFunction)element;
            String name = f.getName();
            boolean ok = true;
            List childs = f.getChilds();
            if (childs.size() < 1) {
                IProblem problem = problemFactory.createWrongNumberOfArgumentsProblem(name, element, 1);
                rep.reportProblem(problem);
                ok = false;
            }
            if ((expr = (Expression)childs.get(0)).getKind() != 0x200000) {
                IProblem problem = problemFactory.createWrongArgumentTypeProblem(expr, "TypeExpression");
                rep.reportProblem(problem);
                ok = false;
            }
            return ok;
        }
        return false;
    }
}

