/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.apache.uima.ruta.ide.parser.ast.AbstractFactory;
import org.apache.uima.ruta.ide.parser.ast.FeatureMatchExpression;
import org.apache.uima.ruta.ide.parser.ast.NullExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaBinaryArithmeticExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaBooleanNumberExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaBooleanTypeExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaExpressionConstants;
import org.apache.uima.ruta.ide.parser.ast.RutaFunction;
import org.apache.uima.ruta.ide.parser.ast.RutaInnerListExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaListExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaQuantifierLiteralExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaRessourceReference;
import org.apache.uima.ruta.ide.parser.ast.RutaStringExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaUnaryArithmeticExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.BooleanLiteral;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.ExpressionConstants;
import org.eclipse.dltk.ast.expressions.FloatNumericLiteral;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.VariableReference;

public class ExpressionFactory
extends AbstractFactory
implements ExpressionConstants {
    private static VariableReference newVariableReference(Token ref, int kind) {
        int[] bounds = ExpressionFactory.getBounds(ref);
        return new RutaVariableReference(bounds[0], bounds[1], ref.getText(), kind);
    }

    public static VariableReference createGenericVariableReference(Token ref) {
        return ExpressionFactory.newVariableReference(ref, 0x1000000);
    }

    public static RutaQuantifierLiteralExpression createQuantifierLiteralExpression(Token q, Token q2) {
        int[] bounds = ExpressionFactory.getBounds(q);
        if (q2 != null) {
            bounds[1] = Math.max(bounds[1], ExpressionFactory.getBounds(q2)[1]);
        }
        return new RutaQuantifierLiteralExpression(bounds[0], bounds[1], q.getText());
    }

    public static Expression createBooleanExpression(Expression e) {
        if (e == null) {
            return null;
        }
        return new RutaExpression(e.sourceStart(), e.sourceEnd(), e, 0x400000);
    }

    public static RutaBooleanNumberExpression createBooleanNumberExpression(Expression e1, Token op, Expression e2) {
        int lexerOpID = op.getType();
        int operatorID = 0;
        switch (lexerOpID) {
            case 82: {
                operatorID = 1014;
                break;
            }
            case 83: {
                operatorID = 1015;
                break;
            }
            case 65: {
                operatorID = 1016;
                break;
            }
            case 66: {
                operatorID = 1017;
                break;
            }
            case 46: {
                operatorID = 1013;
                break;
            }
            case 104: {
                operatorID = 1029;
                break;
            }
        }
        return new RutaBooleanNumberExpression(e1.sourceStart(), e2.sourceEnd(), operatorID, e1, e2);
    }

    public static VariableReference createBooleanVariableReference(Token variableId) {
        return ExpressionFactory.newVariableReference(variableId, 0x400000);
    }

    public static BooleanLiteral createSimpleBooleanExpression(Token bToken) {
        int[] bounds = ExpressionFactory.getBounds(bToken);
        boolean value = Boolean.valueOf(bToken.getText());
        return new BooleanLiteral(bounds[0], bounds[1], value);
    }

    public static Expression createTypeExpression(Expression e) {
        if (e != null) {
            return new RutaExpression(e.sourceStart(), e.sourceEnd(), e, 0x800000);
        }
        return null;
    }

    public static Expression createEmptyTypeExpression(Token token) {
        int[] bounds = ExpressionFactory.getBounds(token);
        return new RutaVariableReference(bounds[0], bounds[1], "", 0x800000);
    }

    public static Expression createEmptyStringExpression(Token token) {
        int[] bounds = ExpressionFactory.getBounds(token);
        return new RutaVariableReference(bounds[0], bounds[1], "", 0x200000);
    }

    public static Expression createEmptyNumberExpression(Token token) {
        int[] bounds = ExpressionFactory.getBounds(token);
        return new RutaVariableReference(bounds[0], bounds[1], "", 262144);
    }

    public static Expression createEmptyBooleanExpression(Token token) {
        int[] bounds = ExpressionFactory.getBounds(token);
        return new RutaVariableReference(bounds[0], bounds[1], "", 0x400000);
    }

    public static VariableReference createAnnotationTypeVariableReference(Token atRef) {
        return ExpressionFactory.newVariableReference(atRef, 0x800000);
    }

    public static Expression createAnnotationTypeConstantReference(Token atBasic) {
        int[] bounds = ExpressionFactory.getBounds(atBasic);
        return new RutaVariableReference(bounds[0], bounds[1], atBasic.getText(), 0x800000);
    }

    public static RutaStringExpression createStringExpression(List<Expression> exprList) {
        if (exprList == null) {
            exprList = new ArrayList<Expression>();
        }
        int start = 0;
        int end = 0;
        if (!exprList.isEmpty()) {
            start = exprList.get(0).sourceStart();
            end = exprList.get(exprList.size() - 1).sourceEnd();
        }
        return new RutaStringExpression(start, end, exprList);
    }

    public static StringLiteral createSimpleString(Token stringToken) {
        int[] bounds = ExpressionFactory.getBounds(stringToken);
        return new StringLiteral(bounds[0], bounds[1], stringToken.getText());
    }

    public static VariableReference createStringVariableReference(Token variableId) {
        return ExpressionFactory.newVariableReference(variableId, 0x200000);
    }

    public static RutaExpression createNumberExpression(Expression e) {
        return new RutaExpression(e.sourceStart(), e.sourceEnd(), e, 262144);
    }

    public static NumericLiteral createDecimalLiteral(Token decLit, Token minus) {
        int[] bounds = ExpressionFactory.getBounds(decLit);
        int value = Integer.valueOf(decLit.getText());
        if (minus != null) {
            value = -value;
            bounds[0] = ((CommonToken)minus).getStartIndex();
        }
        return new NumericLiteral(bounds[0], bounds[1], (long)value);
    }

    public static FloatNumericLiteral createFloatingPointLiteral(Token fpLit, Token minus) {
        double value;
        int[] bounds = ExpressionFactory.getBounds(fpLit);
        try {
            value = Double.parseDouble(fpLit.getText());
        }
        catch (NumberFormatException e) {
            value = 0.0;
        }
        if (minus != null) {
            value = -value;
            bounds[0] = ((CommonToken)minus).getStartIndex();
        }
        return new FloatNumericLiteral(bounds[0], bounds[1], value);
    }

    public static VariableReference createNumberVariableReference(Token numVarRef) {
        return ExpressionFactory.newVariableReference(numVarRef, 262144);
    }

    public static Expression createNegatedNumberExpression(Token minus, Expression expr) {
        int[] bounds = ExpressionFactory.getSurroundingBounds((ASTNode)expr, new List[]{null});
        if (minus != null) {
            bounds[0] = ((CommonToken)minus).getStartIndex();
        }
        return new RutaExpression(bounds[0], bounds[1], expr, 262144);
    }

    public static RutaBinaryArithmeticExpression createBinaryArithmeticExpr(Expression exprA, Expression exprB, Token op) {
        int[] bounds = ExpressionFactory.getBounds((ASTNode)exprA, (ASTNode)exprB);
        int lexerOpID = op.getType();
        int operatorID = 0;
        switch (lexerOpID) {
            case 139: {
                operatorID = 1002;
                break;
            }
            case 138: {
                operatorID = 1003;
                break;
            }
            case 113: {
                operatorID = 1019;
                break;
            }
            case 114: {
                operatorID = 1000;
                break;
            }
            case 100: {
                operatorID = 1001;
                break;
            }
            case 116: {
                operatorID = 1078;
                break;
            }
        }
        return new RutaBinaryArithmeticExpression(bounds[0], bounds[1], exprA, exprB, operatorID);
    }

    public static Expression createUnaryArithmeticExpr(Expression expr, Token op) {
        int[] bounds = ExpressionFactory.getBounds(op);
        if (expr != null) {
            bounds[1] = expr.sourceEnd();
        }
        int opID = ExpressionFactory.convertOpToInt(op);
        return new RutaUnaryArithmeticExpression(bounds[0], bounds[1], expr, opID);
    }

    private static int convertOpToInt(Token opToken) {
        return RutaExpressionConstants.opIDs.get(opToken.getText());
    }

    public static Expression createBooleanFunction(Token op, Expression e1, Expression e2) {
        return new RutaExpression(e1.sourceStart(), e2.sourceEnd(), null, 0x400000);
    }

    public static Expression createListVariableReference(Token id) {
        return ExpressionFactory.newVariableReference(id, 0x10000000);
    }

    public static Expression createTableVariableReference(Token id) {
        return ExpressionFactory.newVariableReference(id, 262145);
    }

    public static Expression createRessourceReference(Token path) {
        int[] bounds = ExpressionFactory.getBounds(path);
        String pathWithoutQuotes = path.getText();
        pathWithoutQuotes = pathWithoutQuotes.substring(1, pathWithoutQuotes.length() - 1);
        return new RutaRessourceReference(bounds[0], bounds[1], pathWithoutQuotes);
    }

    public static Expression createInnerListExpression(Token lBrak, List<String> inner, Token rBrak) {
        int[] boundsA = ExpressionFactory.getBounds(lBrak, rBrak);
        StringBuffer s = new StringBuffer();
        s.append(lBrak);
        for (String el : inner) {
            s.append(el);
        }
        s.append(rBrak);
        return new RutaInnerListExpression(boundsA[0], boundsA[1], s.toString());
    }

    public static Expression createBooleanTypeExpression(Expression e1, Token op, Expression e2) {
        int lexerOpID = op.getType();
        int operatorID = 0;
        switch (lexerOpID) {
            case 46: {
                operatorID = 1013;
                break;
            }
            case 104: {
                operatorID = 1029;
                break;
            }
        }
        if (e1 != null && e2 != null) {
            return new RutaBooleanTypeExpression(e1.sourceStart(), e2.sourceEnd(), operatorID, e1, e2);
        }
        return null;
    }

    public static Expression createListExpression(List<Expression> exprList, int type) {
        if (exprList == null) {
            exprList = new ArrayList<Expression>();
        }
        int start = 0;
        int end = 0;
        if (!exprList.isEmpty()) {
            start = exprList.get(0).sourceStart();
            Expression expression = exprList.get(exprList.size() - 1);
            if (expression != null) {
                end = expression.sourceEnd();
            } else {
                exprList.get(0).sourceEnd();
            }
        }
        return new RutaListExpression(start, end, exprList, type);
    }

    public static Expression createListExpression(Token var, int type) {
        return ExpressionFactory.newVariableReference(var, type);
    }

    public static Expression createStringFunction(Token name, Expression var, List<Expression> list) {
        list.add(0, var);
        return ExpressionFactory.createStringFunction(name, list);
    }

    public static Expression createFeatureMatch(Token feature, Token comp, Expression value) {
        int[] bounds = ExpressionFactory.getBounds(feature);
        int end = bounds[1];
        if (value != null) {
            end = value.sourceEnd();
        }
        return new FeatureMatchExpression(bounds[0], end, feature, comp, value);
    }

    public static Expression createBooleanFunction(Token id, List<Expression> args) {
        return ExpressionFactory.createFunction(id, args, 0x400000);
    }

    public static Expression createNumberFunction(Token id, List<Expression> args) {
        return ExpressionFactory.createFunction(id, args, 262144);
    }

    public static Expression createStringFunction(Token id, List<Expression> args) {
        return ExpressionFactory.createFunction(id, args, 0x200000);
    }

    public static Expression createTypeFunction(Token id, List<Expression> args) {
        return ExpressionFactory.createFunction(id, args, 0x800000);
    }

    public static RutaFunction createFunction(Token type, List<Expression> exprsRaw, int kind) {
        int[] bounds = ExpressionFactory.getBounds(type);
        int nameStart = bounds[0];
        int nameEnd = bounds[1];
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        if (exprsRaw != null) {
            for (Expression expressionObj : exprsRaw) {
                Expression expr = expressionObj;
                if (expr == null) continue;
                exprs.add(expr);
            }
            if (!exprs.isEmpty()) {
                Expression lastExpr = (Expression)exprs.get(exprs.size() - 1);
                bounds[1] = Math.max(bounds[1], lastExpr.sourceEnd());
            }
        }
        return new RutaFunction(bounds[0], bounds[1], exprs, kind, type.getText(), nameStart, nameEnd);
    }

    public static Expression createFeatureExpression(Token f) {
        return ExpressionFactory.createFeatureMatch(f, null, null);
    }

    public static Expression createStringExpression(Expression fe) {
        ArrayList<Expression> list = new ArrayList<Expression>(1);
        list.add(fe);
        return ExpressionFactory.createStringExpression(list);
    }

    public static Expression createNullExpression(Token t) {
        int[] bounds = ExpressionFactory.getBounds(t);
        return new NullExpression(bounds[0], bounds[1]);
    }
}

