/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.rapier;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerRulePattern;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.core.TextRulerWordConstraint;
import org.apache.uima.ruta.textruler.learner.rapier.RapierPatternItemMapping;
import org.apache.uima.ruta.textruler.learner.rapier.RapierPatternSegment;
import org.apache.uima.ruta.textruler.learner.rapier.RapierRuleItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RapierGeneralizationHelper {
    private static ArrayList<TextRulerRuleItem> getGeneralizationsForRuleItems(TextRulerRuleItem item1, TextRulerRuleItem item2) {
        ArrayList<TextRulerRuleItem> item1List = new ArrayList<TextRulerRuleItem>();
        ArrayList<TextRulerRuleItem> item2List = new ArrayList<TextRulerRuleItem>();
        if (item1 != null) {
            item1List.add(item1);
        }
        if (item2 != null) {
            item2List.add(item2);
        }
        return RapierGeneralizationHelper.getGeneralizationsForRuleItemLists(item1List, item2List);
    }

    private static ArrayList<TextRulerRuleItem> getGeneralizationsForRuleItemLists(ArrayList<TextRulerRuleItem> item1List, ArrayList<TextRulerRuleItem> item2List) {
        RapierRuleItem proposed;
        int resultListLen;
        RapierRuleItem t;
        ArrayList<RapierRuleItem> proposedWordConstraints = new ArrayList<RapierRuleItem>();
        ArrayList<RapierRuleItem> proposedTagConstraints = new ArrayList<RapierRuleItem>();
        ArrayList<RapierRuleItem> proposedClassConstraints = new ArrayList<RapierRuleItem>();
        ArrayList<TextRulerRuleItem> result = new ArrayList<TextRulerRuleItem>();
        int resultListLen1 = 0;
        int resultListLen2 = 0;
        boolean oneListIsEmpty = false;
        if (item1List.size() == 0 && item2List.size() == 0) {
            TextRulerToolkit.log("ERROR !");
        }
        if (item1List.size() == 0 || item2List.size() == 0) {
            oneListIsEmpty = true;
        }
        boolean hasEmptyWordList = false;
        int maxWordCount = 0;
        boolean hasEmptyTagList = false;
        int maxTagCount = 0;
        for (TextRulerRuleItem rt : item2List) {
            t = (RapierRuleItem)rt;
            resultListLen2 += t.isListItem() ? t.listLen() : 1;
            if (t.getWordConstraints().size() > maxWordCount) {
                maxWordCount = t.getWordConstraints().size();
            }
            if (t.getWordConstraints().size() == 0) {
                hasEmptyWordList = true;
            }
            if (t.getTagConstraints().size() > maxTagCount) {
                maxTagCount = t.getTagConstraints().size();
            }
            if (t.getTagConstraints().size() != 0) continue;
            hasEmptyTagList = true;
        }
        for (TextRulerRuleItem rt : item1List) {
            t = (RapierRuleItem)rt;
            resultListLen1 += t.isListItem() ? t.listLen() : 1;
            if (t.getWordConstraints().size() > maxWordCount) {
                maxWordCount = t.getWordConstraints().size();
            }
            if (t.getWordConstraints().size() == 0) {
                hasEmptyWordList = true;
            }
            if (t.getTagConstraints().size() > maxTagCount) {
                maxTagCount = t.getTagConstraints().size();
            }
            if (t.getTagConstraints().size() != 0) continue;
            hasEmptyTagList = true;
        }
        int n = resultListLen = resultListLen1 > resultListLen2 ? resultListLen1 : resultListLen2;
        if (resultListLen == 1 && !oneListIsEmpty) {
            resultListLen = 0;
        }
        if (hasEmptyWordList) {
            proposedWordConstraints.add(new RapierRuleItem());
        } else {
            proposed = new RapierRuleItem();
            for (TextRulerRuleItem t2 : item1List) {
                proposed.addWordConstraints(((RapierRuleItem)t2).getWordConstraints());
            }
            for (TextRulerRuleItem t2 : item2List) {
                proposed.addWordConstraints(((RapierRuleItem)t2).getWordConstraints());
            }
            proposedWordConstraints.add(proposed);
            if (maxWordCount != proposed.getWordConstraints().size()) {
                proposedWordConstraints.add(new RapierRuleItem());
            }
        }
        if (hasEmptyTagList) {
            proposedTagConstraints.add(new RapierRuleItem());
        } else {
            proposed = new RapierRuleItem();
            for (TextRulerRuleItem t2 : item1List) {
                proposed.addTagConstraints(((RapierRuleItem)t2).getTagConstraints());
            }
            for (TextRulerRuleItem t2 : item2List) {
                proposed.addTagConstraints(((RapierRuleItem)t2).getTagConstraints());
            }
            proposedTagConstraints.add(proposed);
            if (maxTagCount != proposed.getTagConstraints().size()) {
                proposedTagConstraints.add(new RapierRuleItem());
            }
        }
        proposedClassConstraints.add(new RapierRuleItem());
        for (RapierRuleItem wt : proposedWordConstraints) {
            for (RapierRuleItem tt : proposedTagConstraints) {
                for (RapierRuleItem ct : proposedClassConstraints) {
                    RapierRuleItem newItem = new RapierRuleItem();
                    for (TextRulerWordConstraint wi : wt.getWordConstraints()) {
                        newItem.addWordConstraint(wi.copy());
                    }
                    for (String ti : tt.getTagConstraints()) {
                        newItem.addTagConstraint(ti);
                    }
                    for (String tc : ct.getClassConstraints()) {
                        newItem.addClassConstraint(tc);
                    }
                    newItem.setListLen(resultListLen);
                    newItem.setListBeginsAtZero(oneListIsEmpty && resultListLen > 0);
                    result.add(newItem);
                }
            }
        }
        return result;
    }

    private static ArrayList<TextRulerRulePattern> getGeneralizationsForRuleItemPatternsOfEqualSize(TextRulerRulePattern pattern1, TextRulerRulePattern pattern2) {
        ArrayList<TextRulerRulePattern> resultList = new ArrayList<TextRulerRulePattern>();
        ArrayList<ArrayList<TextRulerRuleItem>> generalizationTable = new ArrayList<ArrayList<TextRulerRuleItem>>();
        Iterator it2 = pattern2.iterator();
        if (pattern1.size() != pattern2.size()) {
            TextRulerToolkit.log("ERROR!");
        }
        for (TextRulerRuleItem item1 : pattern1) {
            TextRulerRuleItem item2 = (TextRulerRuleItem)it2.next();
            ArrayList<TextRulerRuleItem> allLGGs = RapierGeneralizationHelper.getGeneralizationsForRuleItems(item1, item2);
            generalizationTable.add(allLGGs);
        }
        RapierGeneralizationHelper.recursiveBuildAllRuleItemCombinations(generalizationTable, 0, new TextRulerRulePattern(), resultList);
        return resultList;
    }

    private static void recursiveBuildAllRuleItemCombinations(ArrayList<ArrayList<TextRulerRuleItem>> table, int curIndex, TextRulerRulePattern currentPattern, ArrayList<TextRulerRulePattern> resultPatterns) {
        if (curIndex >= table.size()) {
            TextRulerRulePattern copy = new TextRulerRulePattern();
            for (TextRulerRuleItem item : currentPattern) {
                copy.add(item.copy());
            }
            resultPatterns.add(copy);
        } else {
            for (TextRulerRuleItem item : table.get(curIndex)) {
                currentPattern.add(item);
                RapierGeneralizationHelper.recursiveBuildAllRuleItemCombinations(table, curIndex + 1, currentPattern, resultPatterns);
                currentPattern.remove(currentPattern.size() - 1);
            }
        }
    }

    private static ArrayList<TextRulerRulePattern> getGeneralizationsForRuleItemPatternsOfDistinctSize(TextRulerRulePattern pattern1, TextRulerRulePattern pattern2) {
        ArrayList<TextRulerRulePattern> resultList = new ArrayList<TextRulerRulePattern>();
        if (pattern1.size() == pattern2.size()) {
            TextRulerToolkit.log("ERROR! CALL getGeneralizationsForRuleItemPatternsOfEqualSize instead!");
        }
        TextRulerRulePattern longerPattern = pattern1;
        TextRulerRulePattern shorterPattern = pattern2;
        if (pattern2.size() > pattern1.size()) {
            longerPattern = pattern2;
            shorterPattern = pattern1;
        }
        if (longerPattern.size() <= 1 || shorterPattern.size() <= 1) {
            if (longerPattern.size() + shorterPattern.size() == 0) {
                TextRulerToolkit.log("ERROR !! BOTH PATTERNS ARE EMPTY!");
            }
            ArrayList<TextRulerRuleItem> generalizations = RapierGeneralizationHelper.getGeneralizationsForRuleItemLists(longerPattern, shorterPattern);
            for (TextRulerRuleItem item : generalizations) {
                TextRulerRulePattern p = new TextRulerRulePattern();
                p.add(item);
                resultList.add(p);
            }
        } else if (longerPattern.size() - shorterPattern.size() > 6 || longerPattern.size() > 10) {
            int resultListLen1 = 0;
            for (TextRulerRuleItem rt : shorterPattern) {
                resultListLen1 += ((RapierRuleItem)rt).isListItem() ? ((RapierRuleItem)rt).listLen() : 1;
            }
            int resultListLen2 = 0;
            for (TextRulerRuleItem rt : longerPattern) {
                resultListLen2 += ((RapierRuleItem)rt).isListItem() ? ((RapierRuleItem)rt).listLen() : 1;
            }
            RapierRuleItem singleItem = new RapierRuleItem();
            singleItem.setListLen(resultListLen1 > resultListLen2 ? resultListLen1 : resultListLen2);
            TextRulerRulePattern singleItemPattern = new TextRulerRulePattern();
            singleItemPattern.add(singleItem);
            resultList.add(singleItemPattern);
        } else {
            ArrayList<ArrayList<RapierPatternItemMapping>> combinationList = new ArrayList<ArrayList<RapierPatternItemMapping>>();
            RapierGeneralizationHelper.recursiveBuildAllPossiblePatternMappingSequences(longerPattern, shorterPattern, new ArrayList<RapierPatternItemMapping>(), combinationList);
            for (ArrayList<RapierPatternItemMapping> mappingSequence : combinationList) {
                resultList.addAll(RapierGeneralizationHelper.getGeneralizationsForPatternMappingSequence(mappingSequence));
            }
        }
        return resultList;
    }

    private static void recursiveBuildAllPossiblePatternMappingSequences(TextRulerRulePattern longerPattern, TextRulerRulePattern shorterPattern, ArrayList<RapierPatternItemMapping> currentMappingSequence, ArrayList<ArrayList<RapierPatternItemMapping>> resultList) {
        int windowSize = longerPattern.size() - shorterPattern.size() + 1;
        if (shorterPattern.size() > longerPattern.size()) {
            TextRulerToolkit.log("ERROR: SHORTER > LONGER !!");
        }
        if (longerPattern.size() == 0 || shorterPattern.size() == 0) {
            TextRulerToolkit.log("ERROR: SHORTER == LONGER == 0!");
        } else if (shorterPattern.size() == 1 || longerPattern.size() == shorterPattern.size()) {
            RapierPatternItemMapping lastMapping = new RapierPatternItemMapping();
            lastMapping.shorterPattern.addAll(shorterPattern);
            lastMapping.longerPattern.addAll(longerPattern);
            ArrayList<RapierPatternItemMapping> newMappingSequence = new ArrayList<RapierPatternItemMapping>();
            newMappingSequence.addAll(currentMappingSequence);
            newMappingSequence.add(lastMapping);
            resultList.add(newMappingSequence);
        } else {
            TextRulerRuleItem firstItem = (TextRulerRuleItem)shorterPattern.get(0);
            for (int maxi = 0; maxi < windowSize; ++maxi) {
                int i;
                RapierPatternItemMapping newMapping = new RapierPatternItemMapping();
                newMapping.shorterPattern.add(firstItem);
                for (int li = 0; li <= maxi; ++li) {
                    newMapping.longerPattern.add(longerPattern.get(li));
                }
                currentMappingSequence.add(newMapping);
                TextRulerRulePattern restLongerPattern = new TextRulerRulePattern();
                TextRulerRulePattern restShorterPattern = new TextRulerRulePattern();
                for (i = 1; i < shorterPattern.size(); ++i) {
                    restShorterPattern.add(shorterPattern.get(i));
                }
                for (i = maxi + 1; i < longerPattern.size(); ++i) {
                    restLongerPattern.add(longerPattern.get(i));
                }
                RapierGeneralizationHelper.recursiveBuildAllPossiblePatternMappingSequences(restLongerPattern, restShorterPattern, currentMappingSequence, resultList);
                currentMappingSequence.remove(currentMappingSequence.size() - 1);
            }
        }
    }

    private static ArrayList<TextRulerRulePattern> getGeneralizationsForPatternMappingSequence(ArrayList<RapierPatternItemMapping> patternMappingSequence) {
        ArrayList<TextRulerRulePattern> resultList = new ArrayList<TextRulerRulePattern>();
        ArrayList<ArrayList<TextRulerRuleItem>> generalizationTable = new ArrayList<ArrayList<TextRulerRuleItem>>();
        for (RapierPatternItemMapping mapping : patternMappingSequence) {
            ArrayList<TextRulerRuleItem> lggList = RapierGeneralizationHelper.getGeneralizationsForRuleItemLists(mapping.shorterPattern, mapping.longerPattern);
            generalizationTable.add(lggList);
        }
        RapierGeneralizationHelper.recursiveBuildAllRuleItemCombinations(generalizationTable, 0, new TextRulerRulePattern(), resultList);
        return resultList;
    }

    private static void recursiveFindPatternSegmentsByMatchingPatternItems(TextRulerRulePattern longerPattern, TextRulerRulePattern shorterPattern, ArrayList<RapierPatternSegment> currentSegmentation, ArrayList<ArrayList<RapierPatternSegment>> resultList) {
        int cmpWindowSize = longerPattern.size() - shorterPattern.size() + 1;
        if (longerPattern.size() == 0 || shorterPattern.size() == 0) {
            ArrayList<RapierPatternSegment> newSegmentation = new ArrayList<RapierPatternSegment>();
            newSegmentation.addAll(currentSegmentation);
            if (longerPattern.size() + shorterPattern.size() > 0) {
                RapierPatternSegment lastSegment = new RapierPatternSegment();
                for (TextRulerRuleItem i : shorterPattern) {
                    lastSegment.shorterPattern.add(i);
                }
                for (TextRulerRuleItem i : longerPattern) {
                    lastSegment.longerPattern.add(i);
                }
                newSegmentation.add(lastSegment);
            }
            resultList.add(newSegmentation);
        } else {
            boolean matched = false;
            for (int si = 0; si < shorterPattern.size(); ++si) {
                for (int li = si; li < si + cmpWindowSize; ++li) {
                    int i;
                    int i2;
                    if (!((TextRulerRuleItem)longerPattern.get(li)).equals((TextRulerRuleItem)shorterPattern.get(si))) continue;
                    matched = true;
                    RapierPatternSegment newSegment = new RapierPatternSegment();
                    for (i2 = 0; i2 < si; ++i2) {
                        newSegment.shorterPattern.add(shorterPattern.get(i2));
                    }
                    for (i2 = 0; i2 < li; ++i2) {
                        newSegment.longerPattern.add(longerPattern.get(i2));
                    }
                    boolean addedLeftSegmentation = false;
                    if (newSegment.longerPattern.size() > 0 || newSegment.shorterPattern.size() > 0) {
                        currentSegmentation.add(newSegment);
                        addedLeftSegmentation = true;
                    }
                    RapierPatternSegment matchedSegment = new RapierPatternSegment();
                    matchedSegment.shorterPattern.add(shorterPattern.get(si));
                    matchedSegment.longerPattern.add(longerPattern.get(li));
                    currentSegmentation.add(matchedSegment);
                    TextRulerRulePattern restLongerPattern = new TextRulerRulePattern();
                    TextRulerRulePattern restShorterPattern = new TextRulerRulePattern();
                    for (i = li + 1; i < longerPattern.size(); ++i) {
                        restLongerPattern.add(longerPattern.get(i));
                    }
                    for (i = si + 1; i < shorterPattern.size(); ++i) {
                        restShorterPattern.add(shorterPattern.get(i));
                    }
                    if (restLongerPattern.size() > restShorterPattern.size()) {
                        RapierGeneralizationHelper.recursiveFindPatternSegmentsByMatchingPatternItems(restLongerPattern, restShorterPattern, currentSegmentation, resultList);
                    } else {
                        RapierGeneralizationHelper.recursiveFindPatternSegmentsByMatchingPatternItems(restShorterPattern, restLongerPattern, currentSegmentation, resultList);
                    }
                    if (addedLeftSegmentation) {
                        currentSegmentation.remove(currentSegmentation.size() - 1);
                    }
                    currentSegmentation.remove(currentSegmentation.size() - 1);
                }
            }
            if (!matched) {
                ArrayList<RapierPatternSegment> newSegmentation = new ArrayList<RapierPatternSegment>();
                newSegmentation.addAll(currentSegmentation);
                RapierPatternSegment lastSegment = new RapierPatternSegment();
                for (TextRulerRuleItem i : shorterPattern) {
                    lastSegment.shorterPattern.add(i);
                }
                for (TextRulerRuleItem i : longerPattern) {
                    lastSegment.longerPattern.add(i);
                }
                newSegmentation.add(lastSegment);
                resultList.add(newSegmentation);
            }
        }
    }

    private static ArrayList<TextRulerRulePattern> getGeneralizationsForPatternSegmentation(ArrayList<RapierPatternSegment> patternSegmentation) {
        ArrayList<ArrayList<TextRulerRulePattern>> generalizationTable = new ArrayList<ArrayList<TextRulerRulePattern>>();
        for (RapierPatternSegment pSeg : patternSegmentation) {
            ArrayList<TextRulerRulePattern> pSegGeneralizations = pSeg.longerPattern.size() == pSeg.shorterPattern.size() ? RapierGeneralizationHelper.getGeneralizationsForRuleItemPatternsOfEqualSize(pSeg.longerPattern, pSeg.shorterPattern) : RapierGeneralizationHelper.getGeneralizationsForRuleItemPatternsOfDistinctSize(pSeg.longerPattern, pSeg.shorterPattern);
            generalizationTable.add(pSegGeneralizations);
        }
        ArrayList<TextRulerRulePattern> resultList = new ArrayList<TextRulerRulePattern>();
        RapierGeneralizationHelper.recursiveBuildAllRuleItemCombinationsFromPatterns(generalizationTable, 0, new TextRulerRulePattern(), resultList);
        return resultList;
    }

    private static void recursiveBuildAllRuleItemCombinationsFromPatterns(ArrayList<ArrayList<TextRulerRulePattern>> table, int curIndex, TextRulerRulePattern currentPattern, ArrayList<TextRulerRulePattern> resultPatterns) {
        if (curIndex >= table.size()) {
            TextRulerRulePattern copy = new TextRulerRulePattern();
            for (TextRulerRuleItem item : currentPattern) {
                copy.add(item.copy());
            }
            resultPatterns.add(copy);
        } else {
            for (TextRulerRulePattern pattern : table.get(curIndex)) {
                currentPattern.addAll(pattern);
                RapierGeneralizationHelper.recursiveBuildAllRuleItemCombinationsFromPatterns(table, curIndex + 1, currentPattern, resultPatterns);
                for (int i = 0; i < pattern.size(); ++i) {
                    currentPattern.remove(currentPattern.size() - 1);
                }
            }
        }
    }

    private static ArrayList<TextRulerRulePattern> getOptimizedGeneralizationsForRuleItemPatternsOfDistinctSize(TextRulerRulePattern pattern1, TextRulerRulePattern pattern2) {
        ArrayList<ArrayList<RapierPatternSegment>> matchedCombinationList = new ArrayList<ArrayList<RapierPatternSegment>>();
        if (pattern1.size() > pattern2.size()) {
            RapierGeneralizationHelper.recursiveFindPatternSegmentsByMatchingPatternItems(pattern1, pattern2, new ArrayList<RapierPatternSegment>(), matchedCombinationList);
        } else {
            RapierGeneralizationHelper.recursiveFindPatternSegmentsByMatchingPatternItems(pattern2, pattern1, new ArrayList<RapierPatternSegment>(), matchedCombinationList);
        }
        ArrayList<TextRulerRulePattern> resultList = new ArrayList<TextRulerRulePattern>();
        for (ArrayList<RapierPatternSegment> patternSegmentation : matchedCombinationList) {
            resultList.addAll(RapierGeneralizationHelper.getGeneralizationsForPatternSegmentation(patternSegmentation));
        }
        return resultList;
    }

    public static ArrayList<TextRulerRulePattern> getGeneralizationsForRuleItemPatterns(TextRulerRulePattern pattern1, TextRulerRulePattern pattern2) {
        ArrayList<TextRulerRulePattern> result = new ArrayList<TextRulerRulePattern>();
        if (pattern1.size() == 0 && pattern2.size() == 0) {
            return result;
        }
        result = pattern1.size() == pattern2.size() ? RapierGeneralizationHelper.getGeneralizationsForRuleItemPatternsOfEqualSize(pattern1, pattern2) : RapierGeneralizationHelper.getOptimizedGeneralizationsForRuleItemPatternsOfDistinctSize(pattern1, pattern2);
        return result;
    }
}

