/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.whisk.generic;

import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerMultiSlotRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerRulePattern;
import org.apache.uima.ruta.textruler.core.TextRulerSlotPattern;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.learner.whisk.generic.WhiskRuleItem;

public class WhiskRule
extends TextRulerMultiSlotRule {
    TextRulerExample seedExample;

    public WhiskRule(WhiskRule copyFrom) {
        super(copyFrom);
        this.seedExample = copyFrom.seedExample;
    }

    public WhiskRule(TextRulerBasicLearner parentAlgorithm, TextRulerTarget target, TextRulerExample seedExample) {
        super(parentAlgorithm, target);
        this.seedExample = seedExample;
    }

    public WhiskRule copy() {
        return new WhiskRule(this);
    }

    public double getLaplacian() {
        int e = 0;
        int n = 0;
        if (this.coveringStatistics != null) {
            e = this.coveringStatistics.getCoveredNegativesCount();
            n = this.coveringStatistics.getCoveredNegativesCount() + this.coveringStatistics.getCoveredPositivesCount();
        }
        return ((double)e + 1.0) / ((double)n + 1.0);
    }

    public TextRulerExample getSeedExample() {
        return this.seedExample;
    }

    public void setCoveringStatistics(TextRulerStatisticsCollector c) {
        super.setCoveringStatistics(c);
    }

    public boolean containsTerm(WhiskRuleItem term) {
        for (TextRulerSlotPattern sp : this.slotPatterns) {
            for (TextRulerRuleItem i : sp.preFillerPattern) {
                if (!i.equals(term)) continue;
                return true;
            }
            for (TextRulerRuleItem i : sp.fillerPattern) {
                if (!i.equals(term)) continue;
                return true;
            }
            for (TextRulerRuleItem i : sp.postFillerPattern) {
                if (!i.equals(term)) continue;
                return true;
            }
        }
        return false;
    }

    public WhiskRuleItem searchNeighborOfItem(WhiskRuleItem item, boolean goToLeft) {
        int slotIndex = -1;
        int patternIndex = -1;
        int slotI = 0;
        for (TextRulerSlotPattern sp : this.slotPatterns) {
            for (TextRulerRuleItem it : sp.preFillerPattern) {
                if (it != item) continue;
                slotIndex = slotI;
                patternIndex = 0;
                break;
            }
            if (slotIndex < 0) {
                for (TextRulerRuleItem it : sp.fillerPattern) {
                    if (it != item) continue;
                    slotIndex = slotI;
                    patternIndex = 1;
                    break;
                }
            }
            if (slotIndex < 0) {
                for (TextRulerRuleItem it : sp.postFillerPattern) {
                    if (it != item) continue;
                    slotIndex = slotI;
                    patternIndex = 2;
                    break;
                }
            }
            if (slotIndex < 0) continue;
            break;
        }
        if (slotIndex < 0) {
            return null;
        }
        TextRulerRulePattern currentPattern = this.getPattern(slotIndex, patternIndex);
        while (currentPattern != null) {
            int startSearchFromIndex;
            int startIndex = currentPattern.indexOf(item);
            if (!goToLeft) {
                startSearchFromIndex = startIndex + 1;
                if (startSearchFromIndex < currentPattern.size()) {
                    return (WhiskRuleItem)currentPattern.get(startSearchFromIndex);
                }
                if (++patternIndex > 2) {
                    patternIndex = 0;
                    if (++slotIndex >= this.slotPatterns.size()) {
                        return null;
                    }
                }
                currentPattern = this.getPattern(slotIndex, patternIndex);
                continue;
            }
            int n = startSearchFromIndex = startIndex >= 0 ? startIndex - 1 : currentPattern.size() - 1;
            if (startSearchFromIndex >= 0 && currentPattern.size() > 0) {
                return (WhiskRuleItem)currentPattern.get(startSearchFromIndex);
            }
            if (--patternIndex < 0) {
                patternIndex = 2;
                if (--slotIndex < 0) {
                    return null;
                }
            }
            currentPattern = this.getPattern(slotIndex, patternIndex);
        }
        return null;
    }

    private TextRulerRulePattern getPattern(int slotIndex, int patternIndex) {
        TextRulerSlotPattern sp = (TextRulerSlotPattern)this.slotPatterns.get(slotIndex);
        if (patternIndex == 0) {
            return sp.preFillerPattern;
        }
        if (patternIndex == 1) {
            return sp.fillerPattern;
        }
        if (patternIndex == 2) {
            return sp.postFillerPattern;
        }
        return null;
    }

    public int totalConstraintPoints() {
        int result = 0;
        for (TextRulerSlotPattern sl : this.slotPatterns) {
            for (TextRulerRuleItem i : sl.preFillerPattern) {
                result += ((WhiskRuleItem)i).constraintPoints();
            }
            for (TextRulerRuleItem i : sl.fillerPattern) {
                result += ((WhiskRuleItem)i).constraintPoints();
            }
            for (TextRulerRuleItem i : sl.postFillerPattern) {
                result += ((WhiskRuleItem)i).constraintPoints();
            }
        }
        return result;
    }
}

