# Copyright (C) 2005 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

from cairo import gtk as cairogtk

SELECTION_NODE_SIZE = 7
BORDER_WIDTH = 3

class Annotator:
    def __init__(self, widget, window):
        self.widget = widget
        self.window = window
        self.cr = cairogtk.gdk_cairo_create(window)
        self.cr.set_line_width(1.0)
        
    def draw_nodes(self, x, y, width, height):
        cr = self.cr
        
        cr.set_source_rgba(0.40, 0.0, 0.0, 0.75) # translucent dark red
        
        if width > SELECTION_NODE_SIZE and height > SELECTION_NODE_SIZE:
            cr.rectangle(x + 1, y + 1,
                         SELECTION_NODE_SIZE - 1, SELECTION_NODE_SIZE - 1)
            cr.rectangle(x + 1, y + height -SELECTION_NODE_SIZE,
                         SELECTION_NODE_SIZE - 1, SELECTION_NODE_SIZE - 1)
            cr.rectangle(x + width - SELECTION_NODE_SIZE, y + 1,
                         SELECTION_NODE_SIZE - 1, SELECTION_NODE_SIZE - 1)
            cr.rectangle(x + width - SELECTION_NODE_SIZE,
                         y + height - SELECTION_NODE_SIZE,
                         SELECTION_NODE_SIZE - 1, SELECTION_NODE_SIZE -1)
            cr.fill()
            
        cr.rectangle(x + 0.5, y + 0.5, width - 1, height - 1)
        cr.stroke()
         
    def draw_border(self, x, y, width, height, color):
        cr = self.cr
        
        for i in range(0, BORDER_WIDTH):
            if (i <= BORDER_WIDTH / 2):
                alpha = (i + 1.) / (BORDER_WIDTH)
            else:
                alpha = (BORDER_WIDTH - i + 0.) / (BORDER_WIDTH)
                
            cr.set_source_rgba(color[0], color[1], color[2],
                               alpha)
            cr.rectangle(x - BORDER_WIDTH / 2 + i + 0.5,
                         y - BORDER_WIDTH / 2 + i + 0.5,
                         width + 2 * (BORDER_WIDTH / 2 - i) - 1,
                         height + 2 * (BORDER_WIDTH / 2 - i) - 1)
            cr.stroke()
