/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki;

import gnu.crypto.pki.X500Name;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CertSelectorImpl
implements CertSelector {
    private Set issuerNames = new HashSet();
    private Set subjectNames = new HashSet();

    public void addIssuerName(byte[] issuerName) throws IOException {
        this.issuerNames.add(new X500Name(issuerName));
    }

    public void addIssuerName(String issuerName) {
        this.issuerNames.add(new X500Name(issuerName));
    }

    public void addIssuerName(Principal issuerName) throws IOException {
        if (issuerName instanceof X500Name) {
            this.issuerNames.add(issuerName);
        } else if (issuerName instanceof X500Principal) {
            this.issuerNames.add(new X500Name(((X500Principal)issuerName).getEncoded()));
        } else {
            this.issuerNames.add(new X500Name(issuerName.getName()));
        }
    }

    public Collection getIssuerNames() {
        return Collections.unmodifiableSet(this.issuerNames);
    }

    public void addSubjectName(byte[] subjectName) throws IOException {
        this.subjectNames.add(new X500Name(subjectName));
    }

    public void addSubjectName(String subjectName) throws IOException {
        this.subjectNames.add(new X500Name(subjectName));
    }

    public void addSubjectName(Principal subjectName) throws IOException {
        if (subjectName instanceof X500Name) {
            this.subjectNames.add(subjectName);
        } else if (subjectName instanceof X500Principal) {
            this.subjectNames.add(new X500Name(((X500Principal)subjectName).getEncoded()));
        } else {
            this.subjectNames.add(new X500Name(subjectName.getName()));
        }
    }

    public Collection getSubjectNames() {
        return Collections.unmodifiableSet(this.subjectNames);
    }

    public Object clone() {
        X509CertSelectorImpl copy = new X509CertSelectorImpl();
        copy.issuerNames.addAll(this.issuerNames);
        copy.subjectNames.addAll(this.subjectNames);
        return copy;
    }

    public boolean match(Certificate cert) {
        boolean matchSubject;
        boolean matchIssuer;
        block9: {
            if (!(cert instanceof X509Certificate)) {
                return false;
            }
            matchIssuer = false;
            matchSubject = false;
            try {
                X500Name name;
                Iterator it;
                Principal p = ((X509Certificate)cert).getIssuerDN();
                X500Name thisName = null;
                thisName = p instanceof X500Name ? (X500Name)p : (p instanceof X500Principal ? new X500Name(((X500Principal)p).getEncoded()) : new X500Name(p.getName()));
                if (this.issuerNames.isEmpty()) {
                    matchIssuer = true;
                } else {
                    it = this.issuerNames.iterator();
                    while (it.hasNext()) {
                        name = (X500Name)it.next();
                        if (!thisName.equals(name)) continue;
                        matchIssuer = true;
                        break;
                    }
                }
                p = ((X509Certificate)cert).getSubjectDN();
                thisName = null;
                thisName = p instanceof X500Name ? (X500Name)p : (p instanceof X500Principal ? new X500Name(((X500Principal)p).getEncoded()) : new X500Name(p.getName()));
                if (this.subjectNames.isEmpty()) {
                    matchSubject = true;
                    break block9;
                }
                it = this.subjectNames.iterator();
                while (it.hasNext()) {
                    name = (X500Name)it.next();
                    if (!thisName.equals(name)) continue;
                    matchSubject = true;
                    break;
                }
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        boolean bl = false;
        if (matchIssuer && matchSubject) {
            bl = true;
        }
        return bl;
    }
}

