/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.EToolkit;
import gnu.jemacs.buffer.Marker;
import java.awt.Color;
import java.io.Writer;

public class BufferWriter
extends Writer
implements Runnable {
    Marker marker;
    Object style;
    Object stylePlain;
    boolean adjustPoint;
    static final int NO_ESCAPES_STATE = 1;
    static final int NORMAL_STATE = 0;
    static final int LAST_COLUMN_STATE = 1;
    static final int SEEN_ESC_STATE = 2;
    static final int SEEN_ESC_LBRAC_STATE = 3;
    static final int SEEN_ESC_RBRAC_STATE = 4;
    int state = 0;
    static final int ESC = 27;
    boolean insertMode = false;
    char[] savedOutput;
    int savedCount;
    boolean bold = false;
    boolean underline = false;
    boolean blink = false;
    boolean inverse;
    boolean invisible;
    String foregroundName;
    String backgroundName;
    Color foreground;
    Color background;
    StringBuffer styleNameBuf;
    String styleName;
    private String name;
    private Color color;
    char[] buf1 = new char[1];
    char[] buffer;
    int count;

    public BufferWriter(Marker marker, boolean adjustPoint) {
        this.marker = marker;
        EToolkit toolkit = EToolkit.getInstance();
        this.style = this.stylePlain = toolkit.getFace("output", true);
        this.adjustPoint = adjustPoint;
    }

    public BufferWriter(Buffer buffer) {
        this(buffer.pointMarker, false);
    }

    void resetAttributes() {
        this.bold = false;
        this.underline = false;
        this.blink = false;
        this.inverse = false;
        this.invisible = false;
        this.foregroundName = null;
        this.backgroundName = null;
        this.foreground = null;
        this.background = null;
    }

    void updateStyle() {
        int slen;
        if (this.styleNameBuf == null) {
            this.styleNameBuf = new StringBuffer(60);
        }
        this.styleNameBuf.setLength(0);
        if (this.underline) {
            this.styleNameBuf.append("underlined,");
        }
        if (this.bold) {
            this.styleNameBuf.append("bold,");
        }
        if (this.foreground != null) {
            this.styleNameBuf.append("fg=");
            this.styleNameBuf.append(this.foregroundName != null ? this.foregroundName : this.foreground.toString());
            this.styleNameBuf.append(',');
        }
        if (this.background != null) {
            this.styleNameBuf.append("bg=");
            this.styleNameBuf.append(this.backgroundName != null ? this.backgroundName : this.background.toString());
            this.styleNameBuf.append(',');
        }
        if ((slen = this.styleNameBuf.length()) == 0) {
            this.style = this.stylePlain;
            this.styleName = "output";
            return;
        }
        this.styleNameBuf.setLength(slen - 1);
        this.styleName = this.styleNameBuf.toString();
        EToolkit toolkit = EToolkit.getInstance();
        this.style = toolkit.getFace(this.styleName, false);
        if (this.style != null) {
            return;
        }
        this.style = toolkit.getFace(this.styleName, true);
        toolkit.setUnderline(this.style, this.underline);
        toolkit.setBold(this.style, this.bold);
        if (this.foreground != null) {
            toolkit.setForeground(this.style, this.foreground);
        }
        if (this.background != null) {
            toolkit.setBackground(this.style, this.background);
        }
    }

    private void getColor(int index, boolean bright) {
        switch (index) {
            case 0: {
                this.color = Color.black;
                this.name = "black";
                break;
            }
            case 1: {
                this.color = Color.red;
                this.name = "red";
                break;
            }
            case 2: {
                this.color = Color.green;
                this.name = "green";
                break;
            }
            case 3: {
                this.color = Color.yellow;
                this.name = "yellow";
                break;
            }
            case 4: {
                this.color = Color.blue;
                this.name = "blue";
                break;
            }
            case 5: {
                this.color = Color.magenta;
                this.name = "magenta";
                break;
            }
            case 6: {
                this.color = Color.cyan;
                this.name = "cyan";
                break;
            }
            case 7: {
                this.color = Color.white;
                this.name = "white";
                break;
            }
            default: {
                this.color = null;
                this.name = null;
            }
        }
    }

    public int handleSetCharacterRendition(int param, int position) {
        switch (param) {
            case -1: 
            case 0: {
                this.resetAttributes();
            }
            case 1: {
                this.bold = true;
                break;
            }
            case 4: {
                this.underline = true;
                break;
            }
            case 22: {
                this.bold = false;
                break;
            }
            case 24: {
                this.underline = false;
                break;
            }
            default: {
                if (param >= 30 && param <= 39) {
                    this.getColor(param - 30, false);
                    this.foreground = this.color;
                    this.foregroundName = this.name;
                    break;
                }
                if (param >= 40 && param <= 49) {
                    this.getColor(param - 40, false);
                    this.background = this.color;
                    this.backgroundName = this.name;
                    break;
                }
                if (param >= 90 && param <= 97) {
                    this.getColor(param - 90, true);
                    this.background = this.color;
                    this.backgroundName = this.name;
                    break;
                }
                if (param < 100 || param > 107) break;
                this.getColor(param - 100, true);
                this.background = this.color;
                this.backgroundName = this.name;
            }
        }
        return position;
    }

    public void handleOperatingSystemCommand(char ch) {
        if (ch == '\u0007') {
            this.state = 0;
        } else if (this.savedCount >= this.savedOutput.length) {
            int i;
            for (i = 0; i < this.savedCount && this.savedOutput[i] != '\n'; ++i) {
            }
            if (i < this.savedCount || ch == '\n') {
                this.state = 0;
            } else {
                this.savedCount = 0;
            }
        } else {
            this.savedOutput[this.savedCount++] = ch;
        }
    }

    public int handleCSICommand(char ch, int param, int position) {
        switch (ch) {
            case 'C': {
                this.moveColumns(param > 0 ? param : 1);
                break;
            }
            case 'D': {
                this.moveColumns(-(param > 0 ? param : 1));
                break;
            }
            case 'h': {
                if (param != 4) break;
                this.insertMode = true;
                break;
            }
            case 'l': {
                if (param != 4) break;
                this.insertMode = false;
                break;
            }
            case 'm': {
                return this.handleSetCharacterRendition(param, position);
            }
        }
        return position;
    }

    public void handleEscapeBracket(char ch) {
        if (ch == ';' || ch >= '0' && ch <= '9') {
            if (this.savedCount >= this.savedOutput.length) {
                this.savedCount = 0;
            }
            this.savedOutput[this.savedCount++] = ch;
        } else {
            int value = -1;
            for (int i = 0; i < this.savedCount; ++i) {
                ch = this.savedOutput[i];
                if (ch >= '0' && ch <= '9') {
                    value = (value <= 0 ? 0 : 10 * value) + (ch - 48);
                    continue;
                }
                i = this.handleCSICommand('m', value, i);
                value = -1;
            }
            this.handleCSICommand('m', value, this.savedCount);
            this.updateStyle();
            this.state = 0;
        }
    }

    public void unTabifyRestOfLine() {
    }

    public void removeChars(int count) {
        int save = this.marker.getOffset();
        this.moveColumns(count);
        this.marker.removeChar(this.marker.getOffset() - save);
    }

    public void moveColumns(int count) {
        this.marker.moveToColumn(this.marker.currentColumn() + count, true);
    }

    public synchronized void put(char[] data, int off, int len) {
        if (len == 0) {
            return;
        }
        if (this.insertMode) {
            this.unTabifyRestOfLine();
        } else {
            this.removeChars(len);
        }
        boolean mustAdjustPoint = this.adjustPoint && this.marker.getOffset() == this.marker.buffer.getDot();
        this.marker.insert(new String(data, off, len), this.style);
        if (mustAdjustPoint) {
            this.marker.buffer.setDot(this.marker.getOffset());
        }
    }

    @Override
    public synchronized void write(int ch) {
        boolean move = this.marker.getOffset() == this.marker.buffer.getDot();
        this.write1(ch);
        if (move) {
            this.marker.buffer.setDot(this.marker.getOffset());
        }
    }

    public synchronized void write1(int ch) {
        if (this.state <= 0) {
            if (ch >= 32 || ch == 10 || this.state < 0) {
                this.buf1[0] = (char)ch;
                this.put(this.buf1, 0, 1);
            } else if (ch == 27) {
                this.state = 2;
            } else if (ch == 8) {
                this.moveColumns(-1);
            } else if (ch == 9) {
                int col = this.marker.currentColumn();
                this.marker.moveToColumn(col + 8 - (col & 7), true);
            } else if (ch != 13) {
                System.err.println("received ctrl-" + (char)(ch + 64));
            }
        } else if (this.state == 2) {
            switch (ch) {
                case 91: {
                    this.state = 3;
                    if (this.savedOutput == null) {
                        this.savedOutput = new char[100];
                    }
                    this.savedCount = 0;
                    break;
                }
                case 93: {
                    this.state = 4;
                    if (this.savedOutput == null) {
                        this.savedOutput = new char[100];
                    }
                    this.savedCount = 0;
                    break;
                }
                default: {
                    this.state = 0;
                    break;
                }
            }
        } else if (this.state == 3) {
            this.handleEscapeBracket((char)ch);
        } else {
            this.handleOperatingSystemCommand((char)ch);
        }
    }

    @Override
    public synchronized void write(char[] data, int off, int len) {
        boolean move;
        boolean bl = move = this.marker.getOffset() == this.marker.buffer.getDot();
        while (len > 0) {
            int i;
            if (this.state > 0) {
                this.write1(data[off++]);
                --len;
                continue;
            }
            if (this.state == 1) {
                i = len;
            } else {
                char ch;
                for (i = 0; i < len && (ch = data[off + i]) >= ' '; ++i) {
                }
            }
            if (i > 0) {
                this.put(data, off, i);
                off += i;
                len -= i;
            }
            if (i >= len) continue;
            this.write1(data[off++]);
            --len;
        }
        if (move) {
            this.marker.buffer.setDot(this.marker.getOffset());
        }
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public void run() {
        this.write(this.buffer, 0, this.count);
    }
}

