/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.brl;

import gnu.expr.QuoteExp;
import gnu.kawa.brl.BRL;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.lists.Sequence;
import gnu.mapping.InPort;
import gnu.mapping.Values;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;

public class BRLRead
extends LispReader {
    int nesting;
    boolean brlCompatible = false;
    String expressionStartFile;
    int expressionStartLine;
    int expressionStartColumn;

    public boolean inLiteral() {
        return ((InPort)this.port).readState == ']';
    }

    void init() {
        ((InPort)this.port).readState = (char)93;
    }

    public BRLRead(InPort port) {
        super(port);
        this.init();
    }

    public BRLRead(InPort port, SourceMessages messages) {
        super(port, messages);
        this.init();
    }

    @Override
    public Object readObject() throws IOException, SyntaxException {
        int startPos = this.tokenBufferLength;
        InPort port = (InPort)this.getPort();
        int saveNesting = this.nesting;
        try {
            while (true) {
                Object value;
                int ch;
                if ((ch = port.read()) < 0) {
                    if (port.readState != ']' && !this.isInteractive()) {
                        this.error('e', this.expressionStartFile, this.expressionStartLine + 1, this.expressionStartColumn, "an unmatched '[' was read");
                    }
                    Object object2 = Sequence.eofValue;
                    return object2;
                }
                if (port.readState == ']') {
                    port.unread();
                    value = BRL.brlReader.read(this, 93, 1);
                    if (ch == 91 && value == BRL.emptyForm) continue;
                    Object object3 = value;
                    return object3;
                }
                if (ch == 93) {
                    port.readState = (char)93;
                    continue;
                }
                ++this.nesting;
                value = this.readValues(ch, ReadTable.getCurrent());
                if (value != Values.empty) {
                    if (value == QuoteExp.voidExp) {
                        value = Values.empty;
                    }
                    Object object4 = value;
                    return object4;
                }
                this.nesting = saveNesting;
            }
        }
        finally {
            this.nesting = saveNesting;
            this.tokenBufferLength = startPos;
        }
    }

    public static Object readObject(InPort port) throws IOException, SyntaxException {
        return new BRLRead(port).readObject();
    }

    public boolean isBrlCompatible() {
        return this.brlCompatible;
    }

    public void setBrlCompatible(boolean compat) {
        this.brlCompatible = compat;
    }

    void saveExpressionStartPosition() {
        this.expressionStartFile = this.port.getName();
        this.expressionStartLine = this.port.getLineNumber();
        this.expressionStartColumn = this.port.getColumnNumber();
    }
}

