/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.CharSeq;
import java.io.IOException;

public class Strings {
    public static void makeUpperCase(CharSeq str) {
        int i = str.length();
        while (--i >= 0) {
            str.setCharAt(i, Character.toUpperCase(str.charAt(i)));
        }
    }

    public static void makeLowerCase(CharSeq str) {
        int i = str.length();
        while (--i >= 0) {
            str.setCharAt(i, Character.toLowerCase(str.charAt(i)));
        }
    }

    public static void makeCapitalize(CharSeq str) {
        char prev = ' ';
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            ch = !Character.isLetterOrDigit(prev) ? Character.toTitleCase(ch) : Character.toLowerCase(ch);
            str.setCharAt(i, ch);
            prev = ch;
        }
    }

    public static void printQuoted(CharSequence str, Appendable ps, int escapes) {
        int len = str.length();
        try {
            ps.append('\"');
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch == '\\' || ch == '\"') {
                    ps.append('\\');
                } else if (escapes > 0) {
                    if (ch == '\n') {
                        ps.append("\\n");
                        continue;
                    }
                    if (ch == '\r') {
                        ps.append("\\r");
                        continue;
                    }
                    if (ch == '\t') {
                        ps.append("\\t");
                        continue;
                    }
                    if (ch == '\u0007') {
                        ps.append("\\a");
                        continue;
                    }
                    if (ch == '\b') {
                        ps.append("\\b");
                        continue;
                    }
                    if (ch == '\u000b') {
                        ps.append("\\v");
                        continue;
                    }
                    if (ch == '\f') {
                        ps.append("\\f");
                        continue;
                    }
                }
                ps.append(ch);
            }
            ps.append('\"');
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void copyInto(CharSequence src, int start, int end, CharSeq dst, int at) {
        int dstLen = dst.length();
        int srcLen = src.length();
        if (at < 0 || at > dstLen || start < 0 || end > srcLen || end < start || dstLen - at < end - start) {
            throw new StringIndexOutOfBoundsException();
        }
        if (at < start) {
            int i = at;
            for (int j = start; j < end; ++j) {
                dst.setCharAt(i, src.charAt(j));
                ++i;
            }
        } else {
            int i = at + end - start;
            int j = end;
            while (--j >= start) {
                dst.setCharAt(--i, src.charAt(j));
            }
        }
    }
}

