/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ZipMember;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipArchive {
    static final int LREC_SIZE = 26;
    static final int CREC_SIZE = 42;
    static final int ECREC_SIZE = 18;
    static final int TOTAL_ENTRIES_CENTRAL_DIR = 10;
    static final int SIZE_CENTRAL_DIRECTORY = 12;
    static final int C_COMPRESSED_SIZE = 16;
    static final int C_UNCOMPRESSED_SIZE = 20;
    static final int C_FILENAME_LENGTH = 24;
    static final int C_RELATIVE_OFFSET_LOCAL_HEADER = 38;
    RandomAccessFile file;
    String archive_name;
    long size;
    int count_in;
    int count_out;
    ZipMember firstEntry;
    ZipMember lastEntry;
    byte[] buffer = new byte[100];

    public ZipArchive(String string, String string2) throws IOException {
        this.archive_name = string;
        this.file = new RandomAccessFile(string, string2);
        this.readDirectory();
    }

    public ZipArchive(File file, String string) throws IOException {
        this.archive_name = file.getName();
        this.file = new RandomAccessFile(file, string);
        this.readDirectory();
    }

    public ZipMember find(String string) {
        ZipMember zipMember = this.firstEntry;
        while (zipMember != null) {
            if (zipMember.matches(string)) {
                return zipMember;
            }
            zipMember = zipMember.next;
        }
        return null;
    }

    public int size() {
        return this.count_in + this.count_out;
    }

    void write2(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >> 8);
    }

    void write4(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >> 8);
        byArray[n2 + 2] = (byte)(n >> 16);
        byArray[n2 + 3] = (byte)(n >> 24);
    }

    void writeLocalHeader(ZipMember zipMember) throws IOException {
        int n = 30;
        while (--n >= 0) {
            this.buffer[n] = 0;
        }
        this.buffer[0] = 80;
        this.buffer[1] = 75;
        this.buffer[2] = 3;
        this.buffer[3] = 4;
        this.buffer[4] = 10;
        this.write2(zipMember.getName().length(), this.buffer, 26);
        this.write4((int)zipMember.compressed_size, this.buffer, 18);
        this.write4((int)zipMember.getSize(), this.buffer, 22);
        this.file.write(this.buffer, 0, 30);
    }

    void writeCentralHeader(ZipMember zipMember) throws IOException {
        int n = 46;
        while (--n >= 0) {
            this.buffer[n] = 0;
        }
        this.buffer[0] = 80;
        this.buffer[1] = 75;
        this.buffer[2] = 1;
        this.buffer[3] = 2;
        this.buffer[4] = 20;
        this.buffer[5] = 3;
        this.buffer[6] = 10;
        this.write4((int)zipMember.compressed_size, this.buffer, 20);
        this.write4((int)zipMember.getSize(), this.buffer, 24);
        this.write2(zipMember.getName().length(), this.buffer, 28);
        this.write4((int)zipMember.relative_offset_local_header, this.buffer, 42);
        this.file.write(this.buffer, 0, 46);
    }

    public void close() throws IOException {
        if (this.count_out > 0) {
            this.writeEndHeaders();
        }
        this.file.close();
    }

    void writeEndHeaders() throws IOException {
        int n = 0;
        long l = this.lastEntry == null ? 0L : this.lastEntry.fileStart() + this.lastEntry.compressed_size;
        this.file.seek(l);
        ZipMember zipMember = this.firstEntry;
        while (zipMember != null) {
            this.writeCentralHeader(zipMember);
            String string = zipMember.getName();
            int n2 = string.length();
            byte[] byArray = new byte[n2];
            string.getBytes(0, n2, byArray, 0);
            this.file.write(byArray);
            ++n;
            zipMember = zipMember.next;
        }
        if (n != this.count_in + this.count_out) {
            throw new Error("internal error writeEndHeaders");
        }
        long l2 = this.file.getFilePointer() - l;
        int n3 = 22;
        while (--n3 >= 0) {
            this.buffer[n3] = 0;
        }
        this.buffer[0] = 80;
        this.buffer[1] = 75;
        this.buffer[2] = 5;
        this.buffer[3] = 6;
        this.write2(n, this.buffer, 8);
        this.write2(n, this.buffer, 10);
        this.write4((int)l2, this.buffer, 12);
        this.write4((int)l, this.buffer, 16);
        this.file.write(this.buffer, 0, 22);
    }

    ZipMember addMember(String string) {
        ZipMember zipMember = new ZipMember(string);
        if (this.firstEntry == null) {
            this.firstEntry = zipMember;
        } else {
            this.lastEntry.next = zipMember;
        }
        this.lastEntry = zipMember;
        return zipMember;
    }

    public ZipMember append(String string, byte[] byArray) throws IOException {
        long l;
        int n = string.length();
        byte[] byArray2 = new byte[n];
        string.getBytes(0, n, byArray2, 0);
        ZipMember zipMember = this.lastEntry;
        ZipMember zipMember2 = this.addMember(string);
        ++this.count_out;
        zipMember2.compressed_size = byArray.length;
        zipMember2.setSize(byArray.length);
        zipMember2.relative_offset_local_header = l = zipMember == null ? 0L : zipMember.fileStart() + zipMember.compressed_size;
        this.file.seek(l);
        this.writeLocalHeader(zipMember2);
        this.file.write(byArray2);
        this.file.write(byArray);
        return zipMember2;
    }

    private int readu2() throws IOException {
        int n = this.file.read() & 0xFF;
        int n2 = this.file.read() & 0xFF;
        return n2 << 8 | n;
    }

    private int read4() throws IOException {
        int n = this.file.read() & 0xFF;
        int n2 = this.file.read() & 0xFF;
        int n3 = this.file.read() & 0xFF;
        int n4 = this.file.read() & 0xFF;
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    void readDirectory() throws IOException {
        this.size = this.file.length();
        if (this.size == 0L) {
            this.count_in = 0;
            return;
        }
        if (this.size < 22L) {
            throw new IOException("zipfile too short");
        }
        this.file.seek(this.size - 22L);
        if (this.file.read() != 80 || this.file.read() != 75 || this.file.read() != 5 || this.file.read() != 6) {
            throw new IOException("not a valid zipfile");
        }
        this.file.skipBytes(6);
        this.count_in = this.readu2();
        int n = this.read4();
        this.file.seek(this.size - (long)(n + 18 + 4));
        int n2 = 0;
        while (n2 < this.count_in) {
            this.file.skipBytes(20);
            long l = this.read4();
            long l2 = this.read4();
            int n3 = this.readu2();
            this.file.skipBytes(12);
            long l3 = this.read4();
            byte[] byArray = new byte[n3];
            this.file.readFully(byArray);
            ZipMember zipMember = this.addMember(new String(byArray, 0));
            zipMember.compressed_size = l;
            zipMember.setSize(l2);
            zipMember.relative_offset_local_header = l3;
            ++n2;
        }
    }

    private static void usage() {
        System.err.println("zipfile [ptxq] archive [file ...]");
        System.exit(-1);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l = 0L;
        int n;
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static void copy(InputStream inputStream, String string, byte[] byArray) throws IOException {
        Object object2;
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 != null && !((File)(object2 = new File(string2))).exists()) {
            System.err.println("mkdirs:" + ((File)object2).mkdirs());
        }
        if (string.charAt(string.length() - 1) != '/') {
            object2 = new BufferedOutputStream(new FileOutputStream(file));
            ZipArchive.copy(inputStream, (OutputStream)object2, byArray);
            ((OutputStream)object2).close();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2) {
            ZipArchive.usage();
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        try {
            if (string.equals("t") || string.equals("p") || string.equals("x")) {
                PrintStream printStream = System.out;
                byte[] byArray = new byte[1024];
                if (stringArray.length == 2) {
                    ZipEntry zipEntry;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
                    ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        String string3 = zipEntry.getName();
                        if (string.equals("t")) {
                            printStream.print(string3);
                            printStream.print(" size: ");
                            printStream.println(zipEntry.getSize());
                            continue;
                        }
                        if (string.equals("p")) {
                            ZipArchive.copy((InputStream)zipInputStream, printStream, byArray);
                            continue;
                        }
                        ZipArchive.copy((InputStream)zipInputStream, string3, byArray);
                    }
                } else {
                    ZipFile zipFile = new ZipFile(string2);
                    int n = 2;
                    while (n < stringArray.length) {
                        String string4 = stringArray[n];
                        ZipEntry zipEntry = zipFile.getEntry(string4);
                        if (zipEntry == null) {
                            System.err.println("zipfile " + string2 + ":" + stringArray[n] + " - not found");
                            System.exit(-1);
                        } else if (string.equals("t")) {
                            printStream.print(string4);
                            printStream.print(" size: ");
                            printStream.println(zipEntry.getSize());
                        } else if (string.equals("p")) {
                            ZipArchive.copy(zipFile.getInputStream(zipEntry), printStream, byArray);
                        } else {
                            ZipArchive.copy(zipFile.getInputStream(zipEntry), string4, byArray);
                        }
                        ++n;
                    }
                }
            } else if (string.equals("q")) {
                ZipArchive zipArchive = new ZipArchive(string2, "rw");
                int n = 2;
                while (n < stringArray.length) {
                    File file = new File(stringArray[n]);
                    if (!file.exists()) {
                        throw new IOException(stringArray[n] + " - not found");
                    }
                    if (!file.canRead()) {
                        throw new IOException(stringArray[n] + " - not readable");
                    }
                    FileInputStream fileInputStream = new FileInputStream(file);
                    int n2 = (int)file.length();
                    byte[] byArray = new byte[n2];
                    if (fileInputStream.read(byArray) != n2) {
                        throw new IOException(stringArray[n] + " - read error");
                    }
                    fileInputStream.close();
                    zipArchive.append(stringArray[n], byArray);
                    ++n;
                }
                zipArchive.close();
            } else {
                ZipArchive.usage();
            }
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception:  " + iOException);
        }
    }
}

