/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Interpreter;
import gnu.expr.Keyword;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;

public class Invoke
extends ProcedureN
implements CanInline {
    char kind;
    Interpreter interpreter;
    public static final Invoke invoke = new Invoke("invoke", 'V');
    public static final Invoke invokeStatic = new Invoke("invoke-static", 'S');
    public static final Invoke make = new Invoke("make", 'N');
    private PrimProcedure[] cacheMethods;
    private Expression[] cacheArgs;
    private int cacheDefinitelyApplicableMethodCount;
    private int cachePossiblyApplicableMethodCount;

    public Invoke(String string, char c) {
        super(string);
        this.kind = c;
        this.interpreter = Interpreter.getInterpreter();
    }

    public Invoke(String string, char c, Interpreter interpreter) {
        super(string);
        this.kind = c;
        this.interpreter = interpreter;
    }

    public static Object invoke$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(invoke, objectArray);
    }

    public static Object invokeStatic$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(invokeStatic, objectArray);
    }

    public static Object make$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(make, objectArray);
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        return Invoke.applyN(this, objectArray);
    }

    protected static Object applyN(Invoke invoke, Object[] objectArray) throws Throwable {
        Object object2;
        String string;
        ClassType classType;
        int n = objectArray.length;
        Procedure.checkArgCount(invoke, n);
        Object object3 = objectArray[0];
        char c = invoke.kind;
        if (c == 'V') {
            classType = (ClassType)Type.make(object3.getClass());
        } else {
            if (object3 instanceof Class) {
                object3 = Type.make((Class)object3);
            }
            if (object3 instanceof ClassType) {
                classType = (ClassType)object3;
            } else if (object3 instanceof String || object3 instanceof FString) {
                classType = ClassType.make(object3.toString());
            } else if (object3 instanceof Symbol) {
                classType = ClassType.make(((Symbol)object3).getName());
            } else {
                throw new WrongType(invoke, 0, null);
            }
        }
        Object object4 = null;
        if (c == 'N') {
            string = "<init>";
            if (classType instanceof PairClassType) {
                object2 = (PairClassType)classType;
                classType = ((PairClassType)object2).instanceType;
                object4 = ((PairClassType)object2).getStaticLink();
            }
        } else {
            object2 = objectArray[1];
            if (object2 instanceof String || object2 instanceof FString) {
                string = object2.toString();
            } else if (object2 instanceof Symbol) {
                string = ((Symbol)object2).getName();
            } else {
                throw new WrongType(invoke, 1, null);
            }
            string = Compilation.mangleName(string);
        }
        if ((object2 = ClassMethods.apply(classType, string, null, null, invoke.kind == 's' ? 8 : 0, invoke.kind == 'S' ? 0 : 8)) == null) {
            throw new RuntimeException(invoke.getName() + ": no method named `" + string + "' in class " + classType.getName());
        }
        Object[] objectArray2 = new Object[n - (c == 'S' || c == 's' ? 2 : (object4 != null ? 0 : 1))];
        int n2 = 0;
        if (c == 'V') {
            objectArray2[n2++] = objectArray[0];
        } else if (object4 != null) {
            objectArray2[n2++] = object4;
        }
        System.arraycopy(objectArray, c == 'N' ? 1 : 2, objectArray2, n2, n - (c == 'N' ? 1 : 2));
        if (c == 'N') {
            CallContext callContext = CallContext.getInstance();
            int n3 = ((MethodProc)object2).match(callContext, objectArray2);
            int n4 = n - 1;
            if (n3 == 0) {
                return ((MethodProc)object2).applyV(callContext);
            }
            if ((n4 & 1) == 0) {
                Object object5;
                n2 = 0;
                while (n2 < n4) {
                    if (!(objectArray2[n2] instanceof Keyword)) {
                        throw MethodProc.matchFailAsException(n3, invoke, objectArray);
                    }
                    n2 += 2;
                }
                if (object4 == null) {
                    object5 = ((ProcedureN)object2).apply0();
                    n2 = 0;
                } else {
                    object5 = ((ProcedureN)object2).apply1(object4);
                    n2 = 1;
                }
                while (n2 < n4) {
                    Keyword keyword = (Keyword)objectArray2[n2];
                    Object object6 = objectArray2[n2 + 1];
                    SlotSet.apply(false, object5, keyword.getName(), object6);
                    n2 += 2;
                }
                return object5;
            }
            throw MethodProc.matchFailAsException(n3, invoke, objectArray);
        }
        return ((MethodProc)object2).applyN(objectArray2);
    }

    public int numArgs() {
        return 0xFFFFF000 | (this.kind == 'N' ? 1 : 2);
    }

    protected PrimProcedure[] getMethods(ClassType classType, String string, Expression[] expressionArray, int n) {
        if (expressionArray == this.cacheArgs) {
            return this.cacheMethods;
        }
        int n2 = expressionArray.length;
        Type[] typeArray = new Type[n2 - n];
        int n3 = 0;
        if (this.kind == 'V') {
            typeArray[n3++] = classType;
        }
        while (n3 < typeArray.length) {
            typeArray[n3] = expressionArray[n3 + n].getType();
            ++n3;
        }
        PrimProcedure[] primProcedureArray = ClassMethods.getMethods(classType, string, this.kind == 's' ? 8 : 0, this.kind == 'S' ? 0 : 8, this.interpreter);
        long l = ClassMethods.selectApplicable(primProcedureArray, typeArray);
        this.cacheArgs = expressionArray;
        this.cacheDefinitelyApplicableMethodCount = (int)(l >> 32);
        this.cachePossiblyApplicableMethodCount = (int)l;
        this.cacheMethods = primProcedureArray;
        return this.cacheMethods;
    }

    static Object[] checkKeywords(Type type, Expression[] expressionArray, int n) {
        int n2 = expressionArray.length;
        if ((n2 - n & 1) != 0) {
            return null;
        }
        Object[] objectArray = new Object[n2 - n >> 1];
        int n3 = objectArray.length;
        while (--n3 >= 0) {
            Expression expression = expressionArray[n + 2 * n3];
            if (!(expression instanceof QuoteExp)) {
                return null;
            }
            Object object2 = ((QuoteExp)expression).getValue();
            if (!(object2 instanceof Keyword)) {
                return null;
            }
            String string = ((Keyword)object2).getName();
            Object object3 = SlotSet.getField(type, string);
            Object object4 = objectArray[n3] = object3 != null ? object3 : string;
        }
        return objectArray;
    }

    public static Expression inlineClassName(ApplyExp applyExp, int n, InlineCalls inlineCalls) {
        Compilation compilation = inlineCalls.getCompilation();
        Interpreter interpreter = compilation.getInterpreter();
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length > n) {
            Type type = interpreter.getTypeFor(expressionArray[n]);
            if (type instanceof PairClassType) {
                type = ((PairClassType)type).instanceType;
            } else if (!(type instanceof Type)) {
                return applyExp;
            }
            if (type instanceof ClassType && ((ClassType)type).isExisting()) {
                try {
                    type.getReflectClass();
                }
                catch (Exception exception) {
                    compilation.error('e', "unknown class: " + type.getName());
                }
            }
            Expression[] expressionArray2 = new Expression[expressionArray.length];
            System.arraycopy(expressionArray, 0, expressionArray2, 0, expressionArray.length);
            expressionArray2[n] = new QuoteExp(type);
            return new ApplyExp(applyExp.getFunction(), expressionArray2).setLine(applyExp);
        }
        return applyExp;
    }

    /*
     * Unable to fully structure code
     */
    public Expression inline(ApplyExp var1_1, ExpWalker var2_2) {
        block27: {
            block29: {
                block30: {
                    block28: {
                        var3_3 = var1_1.getArgs();
                        var4_4 = var3_3.length;
                        var5_5 = this.getClassType(var3_3);
                        var6_6 = this.getMethodName(var3_3);
                        if (var5_5 == null || var6_6 == null || this.kind == 'N' && !var5_5.isExisting()) break block27;
                        var10_7 = this;
                        synchronized (var10_7) {
                            try {
                                var7_8 = this.getMethods(var5_5, var6_6, var3_3, this.kind == 'S' || this.kind == 's' ? 2 : 1);
                            }
                            catch (Exception var11_9) {
                                var2_2.error('w', "unknown class: " + var5_5.getName());
                                var7_8 = null;
                            }
                            var8_11 = this.cacheDefinitelyApplicableMethodCount;
                            var9_12 = this.cachePossiblyApplicableMethodCount;
                        }
                        if (var7_8 == null) break block27;
                        var11_10 = -1;
                        if (var7_8.length != 0) break block28;
                        var2_2.error('w', "no method `" + var6_6 + "' in " + var5_5.getName());
                        break block29;
                    }
                    if (var8_11 + var9_12 != 0) break block30;
                    if (this.kind != 'N' || ClassMethods.selectApplicable((PrimProcedure[])var7_8, Type.typeArray0) >> 32 != 1L || (var12_14 = Invoke.checkKeywords(var5_5, var3_3, 1)) == null) ** GOTO lbl63
                    var13_18 = null;
                    var14_20 = 0;
                    while (var14_20 < var12_14.length) {
                        if (var12_14[var14_20] instanceof String) {
                            if (var13_18 == null) {
                                var13_18 = new StringBuffer();
                                var13_18.append("no field or setter ");
                            } else {
                                var13_18.append(", ");
                            }
                            var13_18.append('`');
                            var13_18.append(var12_14[var14_20]);
                            var13_18.append('\'');
                        }
                        ++var14_20;
                    }
                    if (var13_18 != null) {
                        var13_18.append(" in class ");
                        var13_18.append(var5_5.getName());
                        var2_2.error('w', var13_18.toString());
                    } else {
                        var15_22 = var7_8[0];
                        var16_23 = new ApplyExp(var15_22, new Expression[0]);
                        var17_24 = 0;
                        while (var17_24 < var12_14.length) {
                            var18_25 = new Expression[]{var16_23, new QuoteExp(var12_14[var17_24]), var3_3[2 * var17_24 + 2]};
                            var16_23 = new ApplyExp(SlotSet.setFieldReturnObject, var18_25);
                            ++var17_24;
                        }
                        return var16_23.setLine(var1_1);
lbl63:
                        // 1 sources

                        var2_2.error('w', "no possibly applicable method `" + var6_6 + "' in " + var5_5.getName());
                    }
                    break block29;
                }
                if (var8_11 == 1 || var8_11 == 0 && var9_12 == 1) {
                    var11_10 = 0;
                } else if (var8_11 > 0) {
                    var11_10 = MethodProc.mostSpecific(var7_8, var8_11);
                    if (var11_10 < 0 && this.kind == 'S') {
                        var12_15 = 0;
                        while (var12_15 < var8_11) {
                            if (var7_8[var12_15].getStaticFlag()) {
                                if (var11_10 >= 0) {
                                    var11_10 = -1;
                                    break;
                                }
                                var11_10 = var12_15;
                            }
                            ++var12_15;
                        }
                    }
                    if (var11_10 < 0) {
                        var2_2.error('w', "more than one definitely applicable method `" + var6_6 + "' in " + var5_5.getName());
                        var12_15 = 0;
                        while (var12_15 < var8_11) {
                            var2_2.error('w', "candidate: " + var7_8[var12_15]);
                            ++var12_15;
                        }
                    }
                } else if (var8_11 == 0) {
                    var2_2.error('w', "no definitely applicable method `" + var6_6 + "' in " + var5_5.getName());
                } else {
                    var2_2.error('w', "more than one possibly applicable method `" + var6_6 + "' in " + var5_5.getName());
                    var12_16 = 0;
                    while (var12_16 < var8_11) {
                        var2_2.error('w', "candidate: " + var7_8[var12_16]);
                    }
                }
            }
            if (var11_10 >= 0) {
                var12_17 = new Expression[var4_4 - (this.kind == 'S' || this.kind == 's' ? 2 : 1)];
                var13_19 = 0;
                if (this.kind == 'V') {
                    var12_17[var13_19++] = var3_3[0];
                }
                System.arraycopy(var3_3, this.kind == 'N' ? 1 : 2, var12_17, var13_19, var4_4 - (this.kind == 'N' ? 1 : 2));
                var14_21 = var7_8[var11_10];
                return new ApplyExp(var14_21, var12_17).setLine(var1_1);
            }
        }
        return var1_1;
    }

    private ClassType getClassType(Expression[] expressionArray) {
        if (expressionArray.length > 0) {
            Type type;
            Expression expression = expressionArray[0];
            Type type2 = type = this.kind == 'V' ? expression.getType() : this.interpreter.getTypeFor(expression);
            if (type instanceof PairClassType) {
                return ((PairClassType)type).instanceType;
            }
            if (type instanceof ClassType) {
                return (ClassType)type;
            }
        }
        return null;
    }

    private String getMethodName(Expression[] expressionArray) {
        if (this.kind == 'N') {
            return "<init>";
        }
        if (expressionArray.length >= 2) {
            return ClassMethods.checkName(expressionArray[1], false);
        }
        return null;
    }

    public static synchronized ApplyExp makeInvokeStatic(ClassType classType, String string, Expression[] expressionArray) {
        PrimProcedure primProcedure = Invoke.getStaticMethod(classType, string, expressionArray);
        if (primProcedure == null) {
            throw new RuntimeException("missing or ambiguous method `" + string + "' in " + classType.getName());
        }
        return new ApplyExp(primProcedure, expressionArray);
    }

    public static synchronized PrimProcedure getStaticMethod(ClassType classType, String string, Expression[] expressionArray) {
        MethodProc[] methodProcArray = invokeStatic.getMethods(classType, string, expressionArray, 0);
        int n = Invoke.invokeStatic.cacheDefinitelyApplicableMethodCount;
        int n2 = Invoke.invokeStatic.cachePossiblyApplicableMethodCount;
        int n3 = methodProcArray == null ? -1 : (n > 0 ? MethodProc.mostSpecific(methodProcArray, n) : (n2 == 1 ? 0 : -1));
        return n3 < 0 ? null : methodProcArray[n3];
    }

    public static synchronized PrimProcedure getMethod(ClassType classType, String string, boolean bl, Type[] typeArray, Interpreter interpreter) {
        MethodProc[] methodProcArray = ClassMethods.getMethods(classType, string, bl ? 8 : 0, 8, interpreter);
        long l = ClassMethods.selectApplicable((PrimProcedure[])methodProcArray, typeArray);
        int n = (int)(l >> 32);
        int n2 = (int)l;
        int n3 = methodProcArray == null ? -1 : (n > 0 ? MethodProc.mostSpecific(methodProcArray, n) : (n2 == 1 ? 0 : -1));
        return n3 < 0 ? null : methodProcArray[n3];
    }
}

