/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.BuiltinEnvironment;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.KawaConvert;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SimplePrompter;
import gnu.kawa.lispexpr.ClassNamespace;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.lists.AbstractFormat;
import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.FString;
import gnu.lists.PrintConsumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.InPort;
import gnu.mapping.Location;
import gnu.mapping.Named;
import gnu.mapping.NamedLocation;
import gnu.mapping.Namespace;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.math.IntNum;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kawa.repl;

public abstract class Language {
    protected static final ThreadLocation current = new ThreadLocation("language");
    static String[][] languages;
    protected Environment environ;
    protected Environment userEnv;
    static int envCounter;
    public static final int PARSE_IMMEDIATE = 1;
    public static final int PARSE_ONE_LINE = 2;
    public static final int PARSE_PROLOG = 4;
    public static boolean requirePedantic;
    public static final int VALUE_NAMESPACE = 1;
    public static final int FUNCTION_NAMESPACE = 2;
    public static final int NAMESPACE_PREFIX_NAMESPACE = 4;
    protected static int env_counter;

    public static Language getDefaultLanguage() {
        return (Language)current.get(null);
    }

    public static void setDefaultLanguage(Language language) {
        current.set(language);
    }

    public static String[][] getLanguages() {
        return languages;
    }

    public static void registerLanguage(String[] langMapping) {
        String[][] newLangs = new String[languages.length + 1][];
        System.arraycopy(languages, 0, newLangs, 0, languages.length);
        newLangs[newLangs.length - 1] = langMapping;
        languages = newLangs;
    }

    public static Language detect(InputStream in) throws IOException {
        int c;
        if (!in.markSupported()) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        in.mark(200);
        while (sbuf.length() < 200 && (c = in.read()) >= 0 && c != 10 && c != 13) {
            sbuf.append((char)c);
        }
        in.reset();
        return Language.detect(sbuf.toString());
    }

    public static Language detect(InPort port) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        port.mark(300);
        port.readLine(sbuf, 'P');
        port.reset();
        return Language.detect(sbuf.toString());
    }

    public static Language detect(String line) {
        String str = line.trim();
        int k = str.indexOf("kawa:");
        if (k >= 0) {
            String w;
            Language lang;
            int i;
            int j;
            for (j = i = k + 5; j < str.length() && Character.isJavaIdentifierPart(str.charAt(j)); ++j) {
            }
            if (j > i && (lang = Language.getInstance(w = str.substring(i, j))) != null) {
                return lang;
            }
        }
        if (str.indexOf("-*- scheme -*-") >= 0) {
            return Language.getInstance("scheme");
        }
        if (str.indexOf("-*- xquery -*-") >= 0) {
            return Language.getInstance("xquery");
        }
        if (str.indexOf("-*- emacs-lisp -*-") >= 0) {
            return Language.getInstance("elisp");
        }
        if (str.indexOf("-*- common-lisp -*-") >= 0 || str.indexOf("-*- lisp -*-") >= 0) {
            return Language.getInstance("common-lisp");
        }
        if (str.charAt(0) == '(' && str.charAt(1) == ':' || str.length() >= 7 && str.substring(0, 7).equals("xquery ")) {
            return Language.getInstance("xquery");
        }
        if (str.charAt(0) == ';' && str.charAt(1) == ';') {
            return Language.getInstance("scheme");
        }
        return null;
    }

    public static Language getInstanceFromFilenameExtension(String filename) {
        Language lang;
        int dot = filename.lastIndexOf(46);
        if (dot > 0 && (lang = Language.getInstance(filename.substring(dot))) != null) {
            return lang;
        }
        return null;
    }

    public static Language getInstance(String name) {
        int langCount = languages.length;
        block2: for (int i = 0; i < langCount; ++i) {
            int nameCount;
            String[] names = languages[i];
            int j = nameCount = names.length - 1;
            while (--j >= 0) {
                Class<?> langClass;
                if (name != null && !names[j].equalsIgnoreCase(name)) continue;
                try {
                    langClass = Class.forName(names[nameCount]);
                }
                catch (ClassNotFoundException ex) {
                    continue block2;
                }
                return Language.getInstance(names[0], langClass);
            }
        }
        return null;
    }

    protected Language() {
        Convert.setInstance(KawaConvert.getInstance());
    }

    public static Language getInstance(String langName, Class langClass) {
        try {
            Method method;
            Class[] args = new Class[]{};
            try {
                String capitalizedName = Character.toTitleCase(langName.charAt(0)) + langName.substring(1).toLowerCase();
                String methodName = "get" + capitalizedName + "Instance";
                method = langClass.getDeclaredMethod(methodName, args);
            }
            catch (Exception ex) {
                method = langClass.getDeclaredMethod("getInstance", args);
            }
            return (Language)method.invoke(null, Values.noArgs);
        }
        catch (Exception ex) {
            langName = langClass.getName();
            Throwable th = ex instanceof InvocationTargetException ? ((InvocationTargetException)ex).getTargetException() : ex;
            throw new WrappedException("getInstance for '" + langName + "' failed", th);
        }
    }

    public boolean isTrue(Object value) {
        return value != Boolean.FALSE;
    }

    public Object booleanObject(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object noValue() {
        return Values.empty;
    }

    public boolean hasSeparateFunctionNamespace() {
        return false;
    }

    public final Environment getEnvironment() {
        return this.userEnv != null ? this.userEnv : Environment.getCurrent();
    }

    public final Environment getNewEnvironment() {
        return Environment.make("environment-" + ++envCounter, this.environ);
    }

    public Environment getLangEnvironment() {
        return this.environ;
    }

    public NamedLocation lookupBuiltin(Symbol name, Object property, int hash) {
        return this.environ == null ? null : this.environ.lookup(name, property, hash);
    }

    public void define(String sym, Object p) {
        Symbol s = this.getSymbol(sym);
        this.environ.define(s, null, p);
    }

    protected void defAliasStFld(String name, String cname, String fname) {
        StaticFieldLocation.define(this.environ, this.getSymbol(name), null, cname, fname);
    }

    protected void defProcStFld(String name, String cname, String fname) {
        Object property = this.hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null;
        Symbol sym = this.getSymbol(name);
        StaticFieldLocation loc = StaticFieldLocation.define(this.environ, sym, property, cname, fname);
        loc.setProcedure();
    }

    protected void defProcStFld(String name, String cname) {
        this.defProcStFld(name, cname, Compilation.mangleNameIfNeeded(name));
    }

    public final void defineFunction(Named proc) {
        Object name = proc.getSymbol();
        Symbol sym = name instanceof Symbol ? (Symbol)name : this.getSymbol(name.toString());
        Object property = this.hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null;
        this.environ.define(sym, property, proc);
    }

    public void defineFunction(String name, Object proc) {
        Object property = this.hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null;
        this.environ.define(this.getSymbol(name), property, proc);
    }

    private void defineAll(Object object2) {
        Class<?> clas = object2.getClass();
        Field[] fields = clas.getFields();
        int i = fields.length;
        while (--i >= 0) {
            Field field = fields[i];
            String name = field.getName();
            if (name.startsWith("$Prvt$") || name.endsWith("$instance")) continue;
            if ((field.getModifiers() & 0x10) != 0) {
                try {
                    this.defineFromFieldValue(field, field.get(object2));
                    continue;
                }
                catch (Throwable ex) {
                    throw new WrappedException("error accessing field " + field, ex);
                }
            }
            System.err.println("INTERNAL ERROR in defineAll for " + name + " in " + clas);
        }
    }

    private void defineFromFieldValue(Field fld, Object value) throws Throwable {
        if (value instanceof Location) {
            Location loc = (Location)value;
            Symbol sym = loc.getKeySymbol();
            if (sym != null) {
                this.environ.addLocation(sym, loc.getKeyProperty(), loc);
                return;
            }
        } else {
            Object vname = value instanceof Named ? ((Named)value).getSymbol() : null;
            if (vname == null) {
                vname = Compilation.demangleName(fld.getName(), true).intern();
            }
            Symbol symbol = vname instanceof Symbol ? (Symbol)vname : this.environ.getSymbol(vname.toString());
            Object prop = this.getEnvPropertyFor(fld, value);
            this.environ.define(symbol, prop, value);
        }
    }

    public Object getEnvPropertyFor(Field fld, Object value) {
        if (!this.hasSeparateFunctionNamespace()) {
            return null;
        }
        if (Compilation.typeProcedure.getReflectClass().isAssignableFrom(fld.getType())) {
            return EnvironmentKey.FUNCTION;
        }
        return null;
    }

    public Object getEnvPropertyFor(Declaration decl) {
        if (this.hasSeparateFunctionNamespace() && decl.isProcedureDecl()) {
            return EnvironmentKey.FUNCTION;
        }
        return null;
    }

    public void loadClass(String name) throws ClassNotFoundException {
        try {
            Class<?> clas = Class.forName(name);
            Object inst = clas.newInstance();
            this.defineAll(inst);
            if (inst instanceof ModuleBody) {
                ((ModuleBody)inst).run();
            }
        }
        catch (ClassNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WrappedException("cannot load " + name, ex);
        }
    }

    public Symbol getSymbol(String name) {
        return this.environ.getSymbol(name);
    }

    public Object lookup(String name) {
        return this.environ.get(name);
    }

    public AbstractFormat getFormat(boolean readable) {
        return null;
    }

    public Consumer getOutputConsumer(Writer out) {
        OutPort oport = out instanceof OutPort ? (OutPort)out : new OutPort(out);
        oport.objectFormat = this.getFormat(false);
        return oport;
    }

    public String getName() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            name = name.substring(dot + 1);
        }
        return name;
    }

    public abstract Lexer getLexer(InPort var1, SourceMessages var2);

    public Compilation getCompilation(Lexer lexer, SourceMessages messages) {
        return new Compilation(this, messages);
    }

    public final Compilation parse(InPort port, SourceMessages messages, int options) throws IOException, SyntaxException {
        return this.parse(this.getLexer(port, messages), options, null);
    }

    public final Compilation parse(InPort port, SourceMessages messages, ModuleInfo info) throws IOException, SyntaxException {
        return this.parse(this.getLexer(port, messages), 4, info);
    }

    public final Compilation parse(Lexer lexer, int options, ModuleInfo info) throws IOException, SyntaxException {
        SourceMessages messages = lexer.getMessages();
        Compilation tr = this.getCompilation(lexer, messages);
        if (requirePedantic) {
            tr.pedantic = true;
        }
        boolean bl = tr.immediate = (options & 1) != 0;
        if ((options & 4) != 0) {
            tr.setState(1);
        }
        tr.pushNewModule(lexer);
        if (info != null) {
            info.setCompilation(tr);
        }
        if (!this.parse(tr, options)) {
            return null;
        }
        if (tr.getState() == 1) {
            tr.setState(2);
        }
        return tr;
    }

    public abstract boolean parse(Compilation var1, int var2) throws IOException, SyntaxException;

    public void resolve(Compilation comp) {
    }

    public Type getTypeFor(Class clas) {
        return Type.make(clas);
    }

    public final Type getLangTypeFor(Type type) {
        Class clas;
        if ((!(type instanceof ObjectType) || ((ObjectType)type).isExisting()) && (clas = type.getReflectClass()) != null) {
            return this.getTypeFor(clas);
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    public static Type string2Type(String name) {
        void var1_1;
        Type t;
        if (name.endsWith("[]")) {
            t = Language.string2Type(name.substring(0, name.length() - 2));
            if (t == null) {
                return null;
            }
            t = ArrayType.make(t);
        } else if (Type.isValidJavaTypeName(name)) {
            t = Type.getType(name);
        } else {
            return null;
        }
        return var1_1;
    }

    public Type getTypeFor(String name) {
        return Language.string2Type(name);
    }

    public final Type getTypeFor(Object spec, boolean lenient) {
        String uri;
        if (spec instanceof Type) {
            return (Type)spec;
        }
        if (spec instanceof Class) {
            return this.getTypeFor((Class)spec);
        }
        if (lenient && (spec instanceof FString || spec instanceof String || spec instanceof Symbol && ((Symbol)spec).hasEmptyNamespace() || spec instanceof CharSeq)) {
            return this.getTypeFor(spec.toString());
        }
        if (spec instanceof Namespace && (uri = ((Namespace)spec).getName()) != null && uri.startsWith("class:")) {
            return this.getLangTypeFor(Language.string2Type(uri.substring(6)));
        }
        return null;
    }

    public final Type asType(Object spec) {
        Type type = this.getTypeFor(spec, true);
        return type == null ? (Type)spec : type;
    }

    public final Type getTypeFor(Expression exp) {
        return this.getTypeFor(exp, true);
    }

    public Type getTypeFor(Expression exp, boolean lenient) {
        if (exp instanceof QuoteExp) {
            return this.getTypeFor(((QuoteExp)exp).getValue(), lenient);
        }
        if (exp instanceof ReferenceExp) {
            Object val;
            ReferenceExp rexp = (ReferenceExp)exp;
            Declaration decl = Declaration.followAliases(rexp.getBinding());
            String name = rexp.getName();
            if (decl != null) {
                name = decl.getName();
                exp = decl.getValue();
                if (decl.isAlias() && exp instanceof QuoteExp) {
                    val = ((QuoteExp)exp).getValue();
                    if (val instanceof Location) {
                        Location loc = (Location)val;
                        if (loc.isBound()) {
                            return this.asType(loc.get());
                        }
                        if (!(loc instanceof Named)) {
                            return null;
                        }
                        name = ((Named)((Object)loc)).getName();
                    }
                } else if (!decl.getFlag(65536)) {
                    return this.getTypeFor(exp, lenient);
                }
            }
            if ((val = this.getEnvironment().get(name)) instanceof Type) {
                return (Type)val;
            }
            if (val instanceof ClassNamespace) {
                return ((ClassNamespace)val).getClassType();
            }
            int len = name.length();
            if (len > 2 && name.charAt(0) == '<' && name.charAt(len - 1) == '>') {
                return this.getTypeFor(name.substring(1, len - 1));
            }
        } else if (exp instanceof ClassExp || exp instanceof ModuleExp) {
            return ((LambdaExp)exp).getType();
        }
        return null;
    }

    public Declaration declFromField(ModuleExp mod, Object fvalue, gnu.bytecode.Field fld) {
        boolean isFinal;
        Object fdname;
        String fname = fld.getName();
        Type ftype = fld.getType();
        boolean isAlias = ftype.isSubtype(Compilation.typeLocation);
        boolean externalAccess = false;
        boolean isImportedInstance = fname.endsWith("$instance");
        if (isImportedInstance) {
            fdname = fname;
        } else if (fvalue instanceof Named) {
            fdname = ((Named)fvalue).getSymbol();
        } else {
            if (fname.startsWith("$Prvt$")) {
                externalAccess = true;
                fname = fname.substring("$Prvt$".length());
            }
            fdname = Compilation.demangleName(fname, true).intern();
        }
        ClassType dtype = isAlias ? Type.pointer_type : this.getTypeFor(ftype.getReflectClass());
        Declaration fdecl = mod.addDeclaration(fdname, dtype);
        boolean isStatic = (fld.getModifiers() & 8) != 0;
        boolean bl = isFinal = (fld.getModifiers() & 0x10) != 0;
        if (isAlias) {
            fdecl.setIndirectBinding(true);
        } else if (isFinal && ftype.isSubtype(Compilation.typeProcedure)) {
            fdecl.setProcedureDecl(true);
        }
        if (isStatic) {
            fdecl.setFlag(2048);
        }
        fdecl.field = fld;
        if (isFinal && !isAlias) {
            fdecl.setFlag(16384);
        }
        if (isImportedInstance) {
            fdecl.setFlag(0x40000000);
        }
        fdecl.setSimple(false);
        if (externalAccess) {
            fdecl.setFlag(524320);
        }
        return fdecl;
    }

    public int getNamespaceOf(Declaration decl) {
        return 1;
    }

    public boolean hasNamespace(Declaration decl, int namespace) {
        return (this.getNamespaceOf(decl) & namespace) != 0;
    }

    public void emitPushBoolean(boolean value, CodeAttr code) {
        code.emitGetStatic(value ? Compilation.trueConstant : Compilation.falseConstant);
    }

    public void emitCoerceToBoolean(CodeAttr code) {
        this.emitPushBoolean(false, code);
        code.emitIfNEq();
        code.emitPushInt(1);
        code.emitElse();
        code.emitPushInt(0);
        code.emitFi();
    }

    public Object coerceFromObject(Class clas, Object obj) {
        return this.getTypeFor(clas).coerceFromObject(obj);
    }

    public Object coerceToObject(Class clas, Object obj) {
        return this.getTypeFor(clas).coerceToObject(obj);
    }

    public Object coerceToObject(int val) {
        return IntNum.make(val);
    }

    public static synchronized void setDefaults(Language lang) {
        Language.setDefaultLanguage(lang);
        current.setGlobal(lang);
        if (Environment.getGlobal() == BuiltinEnvironment.getInstance()) {
            Environment.setGlobal(Environment.getCurrent());
        }
    }

    public Procedure getPrompter() {
        Procedure prompter;
        Object property = null;
        if (this.hasSeparateFunctionNamespace()) {
            property = EnvironmentKey.FUNCTION;
        }
        if ((prompter = (Procedure)this.getEnvironment().get(this.getSymbol("default-prompter"), property, null)) != null) {
            return prompter;
        }
        return new SimplePrompter();
    }

    public final Object eval(String string) throws Throwable {
        return this.eval(new CharArrayInPort(string));
    }

    public final Object eval(Reader in) throws Throwable {
        return this.eval(in instanceof InPort ? (InPort)in : new InPort(in));
    }

    public final Object eval(InPort port) throws Throwable {
        CallContext ctx = CallContext.getInstance();
        int oldIndex = ctx.startFromContext();
        try {
            this.eval(port, ctx);
            return ctx.getFromContext(oldIndex);
        }
        catch (Throwable ex) {
            ctx.cleanupFromContext(oldIndex);
            throw ex;
        }
    }

    public final void eval(String string, Writer out) throws Throwable {
        this.eval((Reader)new CharArrayInPort(string), out);
    }

    public final void eval(String string, PrintConsumer out) throws Throwable {
        this.eval(string, this.getOutputConsumer(out));
    }

    public final void eval(String string, Consumer out) throws Throwable {
        this.eval((Reader)new CharArrayInPort(string), out);
    }

    public final void eval(Reader in, Writer out) throws Throwable {
        this.eval(in, this.getOutputConsumer(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(Reader in, Consumer out) throws Throwable {
        InPort port = in instanceof InPort ? (InPort)in : new InPort(in);
        CallContext ctx = CallContext.getInstance();
        Consumer save = ctx.consumer;
        try {
            ctx.consumer = out;
            this.eval(port, ctx);
        }
        finally {
            ctx.consumer = save;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(InPort port, CallContext ctx) throws Throwable {
        SourceMessages messages = new SourceMessages();
        Language saveLang = Language.getDefaultLanguage();
        Language.setDefaultLanguage(this);
        try {
            Compilation comp = this.parse(port, messages, 1);
            ModuleExp.evalModule(this.getEnvironment(), ctx, comp, null, null);
        }
        finally {
            Language.setDefaultLanguage(saveLang);
        }
        if (messages.seenErrors()) {
            throw new RuntimeException("invalid syntax in eval form:\n" + messages.toString(20));
        }
    }

    public void runAsApplication(String[] args) {
        Language.setDefaults(this);
        repl.main(args);
    }

    static {
        Environment.setGlobal(BuiltinEnvironment.getInstance());
        languages = new String[][]{{"scheme", ".scm", ".sc", "kawa.standard.Scheme"}, {"krl", ".krl", "gnu.kawa.brl.BRL"}, {"brl", ".brl", "gnu.kawa.brl.BRL"}, {"emacs", "elisp", "emacs-lisp", ".el", "gnu.jemacs.lang.ELisp"}, {"xquery", ".xquery", ".xq", ".xql", "gnu.xquery.lang.XQuery"}, {"q2", ".q2", "gnu.q2.lang.Q2"}, {"xslt", "xsl", ".xsl", "gnu.kawa.xslt.XSLT"}, {"commonlisp", "common-lisp", "clisp", "lisp", ".lisp", ".lsp", ".cl", "gnu.commonlisp.lang.CommonLisp"}};
        env_counter = 0;
    }
}

