/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.LetExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class FluidLetExp
extends LetExp {
    public FluidLetExp(Expression[] expressionArray) {
        super(expressionArray);
    }

    public void compile(Compilation compilation, Target target) {
        Type type;
        CodeAttr codeAttr = compilation.getCode();
        Type type2 = type = target instanceof IgnoreTarget ? null : this.getType();
        Target target2 = type == null ? Target.Ignore : (type == Type.pointer_type ? Target.pushObject : new StackTarget(type));
        Scope scope = this.getVarScope();
        codeAttr.enterScope(scope);
        Variable variable = scope.addVariable(codeAttr, Compilation.typeCallContext, null);
        compilation.loadCallContext();
        codeAttr.emitStore(variable);
        Variable[] variableArray = new Variable[this.inits.length];
        Declaration declaration = this.firstDecl();
        this.doInits(declaration, 0, variableArray, compilation, variable);
        codeAttr.emitTryStart(true, type);
        this.body.compileWithPosition(compilation, target2);
        codeAttr.emitTryEnd();
        codeAttr.emitFinallyStart();
        int n = 0;
        while (n < this.inits.length) {
            declaration.load(null, 1, compilation, Target.pushObject);
            codeAttr.emitLoad(variableArray[n]);
            codeAttr.emitLoad(variable);
            codeAttr.emitInvokeVirtual(Compilation.typeLocation.getDeclaredMethod("setRestore", 2));
            ++n;
            declaration = declaration.nextDecl();
        }
        codeAttr.emitTryCatchEnd();
        this.popScope(codeAttr);
        if (type != null) {
            target.compileFromStack(compilation, type);
        }
    }

    private void doInits(Declaration declaration, int n, Variable[] variableArray, Compilation compilation, Variable variable) {
        if (n >= this.inits.length) {
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        variableArray[n] = codeAttr.addLocal(Type.pointer_type);
        declaration.allocateVariable(codeAttr);
        declaration.base.load(null, 1, compilation, Target.pushObject);
        codeAttr.emitDup();
        codeAttr.emitStore(declaration.getVariable());
        this.inits[n].compile(compilation, Target.pushObject);
        this.doInits(declaration.nextDecl(), n + 1, variableArray, compilation, variable);
        codeAttr.emitLoad(variable);
        codeAttr.emitInvokeVirtual(Compilation.typeLocation.getDeclaredMethod("setWithSave", 2));
        codeAttr.emitStore(variableArray[n]);
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkFluidLetExp(this);
    }

    public void print(OutPort outPort) {
        this.print(outPort, "(FluidLet", ")");
    }
}

