/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.expr.ApplyExp;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.functions.Convert;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotGet;
import gnu.kawa.reflect.SlotSet;
import gnu.mapping.CallContext;
import gnu.mapping.HasSetter;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.WrongArguments;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import kawa.standard.Scheme;

public class ClassMethodProc
extends ProcedureN
implements Externalizable,
HasSetter {
    ClassType ctype;
    String methodName;
    char kind;
    public static final String CAST_METHOD_NAME = "@";
    public static final String INSTANCEOF_METHOD_NAME = "instance?";
    public static final Method makeMethod = ClassType.make("gnu.kawa.reflect.ClassMethodProc").getDeclaredMethod("make", 2);
    public static final QuoteExp makeMethodExp = new QuoteExp(new PrimProcedure(makeMethod));
    static final Declaration fieldDecl = Declaration.getDeclarationFromStatic("gnu.kawa.reflect.SlotGet", "field");
    static final Declaration staticFieldDecl = Declaration.getDeclarationFromStatic("gnu.kawa.reflect.SlotGet", "staticField");
    static final Declaration makeDecl = Declaration.getDeclarationFromStatic("gnu.kawa.reflect.Invoke", "make");
    static final Declaration invokeDecl = Declaration.getDeclarationFromStatic("gnu.kawa.reflect.Invoke", "invoke");
    static final Declaration invokeStaticDecl = Declaration.getDeclarationFromStatic("gnu.kawa.reflect.Invoke", "invokeStatic");
    static final Declaration instanceOfDecl = Declaration.getDeclarationFromStatic("kawa.standard.Scheme", "instanceOf");
    static final Declaration castDecl = Declaration.getDeclarationFromStatic("gnu.kawa.functions.Convert", "as");

    void fixup() {
        if (this.methodName.equals("new")) {
            this.kind = (char)78;
        } else if (this.methodName.equals(INSTANCEOF_METHOD_NAME)) {
            this.kind = (char)73;
        } else if (this.methodName.equals(CAST_METHOD_NAME)) {
            this.kind = (char)67;
        } else if (this.methodName.length() > 1 && this.methodName.charAt(0) == '.') {
            this.kind = (char)70;
        }
    }

    public static ClassMethodProc make(ClassType classType, String string) {
        ClassMethodProc classMethodProc = new ClassMethodProc();
        classMethodProc.ctype = classType;
        classMethodProc.methodName = string;
        classMethodProc.fixup();
        return classMethodProc;
    }

    public static ApplyExp makeExp(Expression expression, Expression expression2) {
        Expression[] expressionArray = new Expression[]{expression, expression2};
        ApplyExp applyExp = new ApplyExp(makeMethodExp, expressionArray);
        applyExp.setFlag(2);
        return applyExp;
    }

    public void apply(CallContext callContext) throws Throwable {
        Object[] objectArray = callContext.getArgs();
        if (this.kind != '\u0000') {
            Object object2 = this.applyN(objectArray);
            callContext.writeValue(object2);
        } else {
            Invoke invoke;
            int n = this.ctype == null ? 1 : 0;
            Object[] objectArray2 = new Object[objectArray.length + 2 - n];
            String string = this.methodName;
            if (this.ctype == null) {
                invoke = Invoke.invoke;
                objectArray2[0] = objectArray[0];
            } else {
                invoke = Invoke.invokeStatic;
                objectArray2[0] = this.ctype;
            }
            objectArray2[1] = string;
            System.arraycopy(objectArray, n, objectArray2, 2, objectArray.length - n);
            invoke.apply(objectArray2, callContext);
        }
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        Procedure procedure;
        String string;
        boolean bl = this.ctype == null;
        boolean bl2 = this.kind == 'F';
        boolean bl3 = this.kind == 'N';
        boolean bl4 = this.kind == 'I';
        boolean bl5 = this.kind == 'C';
        Object[] objectArray2 = new Object[objectArray.length + (bl || bl3 || bl4 || bl5 ? 1 : 2)];
        String string2 = string = bl2 ? this.methodName.substring(1) : this.methodName;
        if (bl2 && !bl && objectArray.length == 1) {
            return SlotGet.field.apply2(this.ctype.coerceFromObject(objectArray[0]), string);
        }
        if (bl) {
            procedure = bl2 ? SlotGet.field : Invoke.invoke;
            System.arraycopy(objectArray, 1, objectArray2, 2, objectArray.length - 1);
            objectArray2[0] = objectArray[0];
            objectArray2[1] = string;
        } else if (bl3) {
            procedure = Invoke.make;
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
            objectArray2[0] = this.ctype;
        } else if (bl4) {
            procedure = Scheme.instanceOf;
            System.arraycopy(objectArray, 1, objectArray2, 2, objectArray.length - 1);
            objectArray2[0] = objectArray[0];
            objectArray2[1] = this.ctype;
        } else if (bl5) {
            procedure = Convert.as;
            System.arraycopy(objectArray, 1, objectArray2, 2, objectArray.length - 1);
            objectArray2[0] = this.ctype;
            objectArray2[1] = objectArray[0];
        } else {
            procedure = bl2 ? SlotGet.staticField : Invoke.invokeStatic;
            System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
            objectArray2[0] = this.ctype;
            objectArray2[1] = string;
        }
        return procedure.applyN(objectArray2);
    }

    public void setN(Object[] objectArray) throws Throwable {
        boolean bl;
        boolean bl2 = this.ctype == null;
        boolean bl3 = bl = this.methodName.length() > 1 && this.methodName.charAt(0) == '.';
        if (!bl) {
            throw new Error("invalid setter for method invokcation " + this);
        }
        String string = this.methodName.substring(1);
        if (bl2) {
            if (objectArray.length != 2) {
                throw new WrongArguments(this, objectArray.length);
            }
            SlotSet.apply(false, objectArray[0], string, objectArray[1]);
        } else if (objectArray.length == 1) {
            SlotSet.apply(true, this.ctype, string, objectArray[0]);
        } else if (objectArray.length == 2) {
            SlotSet.apply(false, this.ctype.coerceFromObject(objectArray[0]), string, objectArray[1]);
        } else {
            throw new WrongArguments(this, objectArray.length);
        }
    }

    public static ApplyExp rewrite(ApplyExp applyExp) {
        Declaration declaration;
        String string;
        Expression expression;
        Expression[] expressionArray;
        Procedure procedure;
        Object object2;
        Expression expression2 = applyExp.getFunction();
        if (expression2 instanceof ReferenceExp && (object2 = ((ReferenceExp)expression2).getBinding()) != null) {
            expression2 = ((Declaration)object2).getValue();
        }
        if (expression2 instanceof ApplyExp) {
            Expression[] expressionArray2;
            procedure = (ApplyExp)expression2;
            expressionArray = procedure.getFunction();
            if (expressionArray != makeMethodExp || (expressionArray2 = procedure.getArgs()).length != 2 || !(expressionArray2[1] instanceof QuoteExp)) {
                return applyExp;
            }
            expression = expressionArray2[0];
            string = ((QuoteExp)expressionArray2[1]).getValue().toString();
        } else if (expression2 instanceof QuoteExp && (object2 = ((QuoteExp)expression2).getValue()) instanceof ClassMethodProc) {
            procedure = (ClassMethodProc)object2;
            expression = QuoteExp.getInstance(((ClassMethodProc)procedure).ctype);
            string = ((ClassMethodProc)procedure).methodName;
        } else {
            return applyExp;
        }
        boolean bl = expression == QuoteExp.nullExp;
        expressionArray = applyExp.getArgs();
        boolean bl2 = string.equals(INSTANCEOF_METHOD_NAME);
        boolean bl3 = string.equals(CAST_METHOD_NAME);
        if (expressionArray.length == 0 && (bl || bl2 || bl3)) {
            return applyExp;
        }
        boolean bl4 = string.length() > 1 && string.charAt(0) == '.';
        boolean bl5 = string.equals("new");
        if (bl4 && !bl && expressionArray.length == 1) {
            expressionArray = new Expression[]{Convert.makeCoercion(expressionArray[0], expression)};
            bl = true;
        }
        Expression[] expressionArray3 = new Expression[expressionArray.length + (bl || bl5 || bl2 || bl3 ? 1 : 2)];
        if (bl) {
            declaration = bl4 ? fieldDecl : invokeDecl;
            System.arraycopy(expressionArray, 1, expressionArray3, 2, expressionArray.length - 1);
            expressionArray3[0] = expressionArray[0];
        } else if (bl5) {
            declaration = makeDecl;
            System.arraycopy(expressionArray, 0, expressionArray3, 1, expressionArray.length);
            expressionArray3[0] = expression;
        } else if (bl2) {
            declaration = instanceOfDecl;
            System.arraycopy(expressionArray, 1, expressionArray3, 2, expressionArray.length - 1);
            expressionArray3[0] = expressionArray[0];
            expressionArray3[1] = expression;
        } else if (bl3) {
            declaration = castDecl;
            System.arraycopy(expressionArray, 1, expressionArray3, 2, expressionArray.length - 1);
            expressionArray3[0] = expression;
            expressionArray3[1] = expressionArray[0];
        } else {
            declaration = bl4 ? staticFieldDecl : invokeStaticDecl;
            System.arraycopy(expressionArray, 0, expressionArray3, 2, expressionArray.length);
            expressionArray3[0] = expression;
        }
        if (!(bl5 || bl2 || bl3)) {
            expressionArray3[1] = new QuoteExp((Object)(bl4 ? string.substring(1) : string));
        }
        return new ApplyExp(new ReferenceExp(declaration), expressionArray3);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.ctype);
        objectOutput.writeUTF(this.methodName);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ctype = (ClassType)objectInput.readObject();
        this.methodName = objectInput.readUTF();
        this.fixup();
    }

    public String toString() {
        return "#<class-method " + this.ctype.getName() + " " + this.methodName + '>';
    }
}

