/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Expression;
import gnu.expr.ScopeExp;
import gnu.lists.Pair;
import gnu.mapping.Environment;
import gnu.mapping.UnboundLocationException;
import gnu.mapping.WrongArguments;
import gnu.mapping.WrongType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import kawa.lang.GenericError;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class AutoloadSyntax
extends Syntax
implements Externalizable {
    String className;
    Environment env;
    Syntax loaded;

    public AutoloadSyntax() {
    }

    public AutoloadSyntax(String string, String string2) {
        super(string);
        this.className = string2;
    }

    public AutoloadSyntax(String string, String string2, Environment environment) {
        super(string);
        this.className = string2;
        this.env = environment;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print(this.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("#<syntax ");
        if (this.getName() != null) {
            stringBuffer.append(this.getName());
            stringBuffer.append(' ');
        }
        if (this.loaded != null) {
            stringBuffer.append("autoloaded>");
        } else {
            stringBuffer.append("autoload ");
            stringBuffer.append(this.className);
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    private void throw_error(String string) {
        throw new GenericError(string + this.className + " while autoloading " + (this.getName() == null ? "" : this.getName().toString()));
    }

    void load() {
        String string = this.getName();
        try {
            Object obj = Class.forName(this.className).newInstance();
            if (obj instanceof Syntax) {
                this.loaded = (Syntax)obj;
                if (string != null && this.loaded.getName() == null) {
                    this.loaded.setName(string);
                }
            } else {
                this.throw_error("failed to autoload valid syntax object ");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.throw_error("failed to find class ");
        }
        catch (InstantiationException instantiationException) {
            this.throw_error("failed to instantiate class ");
        }
        catch (IllegalAccessException illegalAccessException) {
            this.throw_error("illegal access in class ");
        }
        catch (UnboundLocationException unboundLocationException) {
            this.throw_error("missing symbol '" + unboundLocationException.getMessage() + "' ");
        }
        catch (WrongArguments wrongArguments) {
            this.throw_error("type error");
        }
    }

    public void scanForm(Pair pair, ScopeExp scopeExp, Translator translator) {
        if (this.loaded == null) {
            try {
                this.load();
            }
            catch (RuntimeException runtimeException) {
                translator.syntaxError(runtimeException.getMessage());
                return;
            }
        }
        this.loaded.scanForm(pair, scopeExp, translator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewriteForm(Pair pair, Translator translator) {
        if (this.loaded == null) {
            try {
                this.load();
            }
            catch (GenericError genericError) {
                return translator.syntaxError(genericError.getMessage());
            }
            catch (WrongType wrongType) {
                return translator.syntaxError(wrongType.getMessage());
            }
        }
        Syntax syntax2 = translator.currentSyntax;
        translator.currentSyntax = this.loaded;
        try {
            Expression expression = this.loaded.rewriteForm(pair, translator);
            return expression;
        }
        finally {
            translator.currentSyntax = syntax2;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.className);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.className = (String)objectInput.readObject();
    }
}

