/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassType;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class ArrayClassLoader
extends ClassLoader {
    Hashtable map = new Hashtable(100);
    URL context;

    public ArrayClassLoader() {
    }

    public ArrayClassLoader(ClassLoader parent) {
        super(parent);
    }

    public URL getResourceContext() {
        return this.context;
    }

    public void setResourceContext(URL context) {
        this.context = context;
    }

    public ArrayClassLoader(byte[][] classBytes) {
        int i = classBytes.length;
        while (--i >= 0) {
            this.addClass("lambda" + i, classBytes[i]);
        }
    }

    public ArrayClassLoader(String[] classNames, byte[][] classBytes) {
        int i = classBytes.length;
        while (--i >= 0) {
            this.addClass(classNames[i], classBytes[i]);
        }
    }

    public void addClass(Class clas) {
        this.map.put(clas.getName(), clas);
    }

    public void addClass(String name, byte[] bytes) {
        this.map.put(name, bytes);
    }

    public void addClass(ClassType ctype) throws IOException {
        if ((ctype.flags & 4) != 0) {
            this.addClass(ctype.getReflectClass());
        } else {
            this.addClass(ctype.getName(), ctype.writeToArray());
        }
    }

    protected URL findResource(String name) {
        if (this.context != null) {
            try {
                URL url = new URL(this.context, name);
                url.openConnection().connect();
                return url;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.findResource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String name) throws ClassNotFoundException {
        Class<?> clas;
        Object r = this.map.get(name);
        if (r == null) {
            throw new ClassNotFoundException(name);
        }
        if (r instanceof byte[]) {
            ArrayClassLoader arrayClassLoader = this;
            synchronized (arrayClassLoader) {
                r = this.map.get(name);
                if (r instanceof byte[]) {
                    byte[] bytes = (byte[])r;
                    clas = this.defineClass(name, bytes, 0, bytes.length);
                    this.map.put(name, clas);
                } else {
                    clas = (Class)r;
                }
            }
        } else {
            clas = (Class<?>)r;
        }
        return clas;
    }
}

