from requests import get
import xbmc
from xbmcaddon import Addon

def generate_dash(video_id: str) -> str:
	addon = Addon()
	resp = get(f'{addon.getSettingString("instance")}/streams/{video_id}').json()

	streams: dict = dict(
		audio = dict(),
		video = dict(),
	)

	default_audio: dict = dict()
	prefer_original_lang: bool = addon.getSettingBool("audio_prefer_original_lang")
	preferred_lang: str = addon.getSettingString("audio_custom_lang") if addon.getSettingString("audio_custom_lang") and not addon.getSettingBool("audio_prefer_kodi_lang") else xbmc.getLanguage(xbmc.ISO_639_1)

	for stream in resp["audioStreams"] + resp["videoStreams"]:
		media_lang = stream["audioTrackLocale"] if stream["audioTrackLocale"] is not None else 'null'
		media_type, media_format = stream["mimeType"].split("/")
		if media_type in ['audio', 'video'] and "googlevideo" in stream["url"]:
			if media_type == 'audio' and ((prefer_original_lang and stream["audioTrackType"] == "ORIGINAL") or (not prefer_original_lang and media_lang[:2] == preferred_lang)):
				if not default_audio.__contains__(media_lang): default_audio[media_lang]: dict = dict()
				if not default_audio[media_lang].__contains__(media_format): default_audio[media_lang][media_format]: list = list()
				default_audio[media_lang][media_format].append(stream)
			else:
				if not streams[media_type].__contains__(media_lang): streams[media_type][media_lang]: dict = dict()
				if not streams[media_type][media_lang].__contains__(media_format): streams[media_type][media_lang][media_format]: list = list()
				streams[media_type][media_lang][media_format].append(stream)

	streams['audio'] = default_audio | streams['audio']

	mpd: str = '<?xml version="1.0" encoding="utf-8"?>'
	mpd += f'<MPD xmlns="urn:mpeg:dash:schema:mpd:2011" profiles="urn:mpeg:dash:profile:full:2011" minBufferTime="PT1.5S" type="static" mediaPresentationDuration="PT{resp["duration"]}S">'

	mpd += '<Period>'

	if addon.getSettingBool("subtitles_load"):
		for subtitle in resp["subtitles"]:
			mpd += f'<AdaptationSet contentType="text" mimeType="{subtitle["mimeType"]}" segmentAlignment="true" lang="{subtitle["code"]}">'
			mpd += '<Role schemeIdUri="urn:mpeg:dash:role:2011" value="subtitle"/>'
			mpd += f'<Representation id="caption_{subtitle["code"]}{"_auto" if subtitle["autoGenerated"] else ""}" bandwidth="256">'
			mpd += f'<BaseURL>{subtitle["url"].replace("&", "&amp;")}</BaseURL>'
			mpd += '</Representation></AdaptationSet>'

	for stream_type in ['audio', 'video']:
		for stream_lang in streams[stream_type]:
			for stream_format in streams[stream_type][stream_lang]:
				stream_xml: str = ''
				for stream in streams[stream_type][stream_lang][stream_format]:
					if stream["initEnd"] > 0:
						stream_xml += f'<Representation id="{stream["itag"]}" codecs="{stream["codec"]}" bandwidth="{stream["bitrate"]}"'
						if stream_type == 'audio':
							stream_xml += '><AudioChannelConfiguration schemeIdUri="urn:mpeg:dash:23003:3:audio_channel_configuration:2011" value="2"/>'
						elif stream_type == 'video':
							stream_xml += f' width="{stream["width"]}" height="{stream["height"]}" maxPlayoutRate="1" frameRate="{stream["fps"]}">'
						stream_xml += f'<BaseURL>{stream["url"].replace("&", "&amp;")}</BaseURL>'
						stream_xml += f'<SegmentBase indexRange="{stream["indexStart"]}-{stream["indexEnd"]}">'
						stream_xml += f'<Initialization range="{stream["initStart"]}-{stream["initEnd"]}"/>'
						stream_xml += '</SegmentBase></Representation>'

				if len(stream_xml) > 0:
					mpd += f'<AdaptationSet mimeType="{stream_type}/{stream_format}" startWithSAP="1" subsegmentAlignment="true"'
					mpd += ' scanType="progressive">' if stream_type == 'video' else f' lang="{stream_lang}">'
					mpd += stream_xml
					mpd += f'</AdaptationSet>'

	mpd += '</Period></MPD>'

	return mpd