/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;

public class AccountChangeEvent
implements SafeParcelable {
    public static final Parcelable.Creator<AccountChangeEvent> CREATOR = new zza();
    final int mVersion;
    final long zzOw;
    final String zzOx;
    final int zzOy;
    final int zzOz;
    final String zzOA;

    AccountChangeEvent(int version, long id, String accountName, int changeType, int eventIndex, String changeData) {
        this.mVersion = version;
        this.zzOw = id;
        this.zzOx = zzu.zzu(accountName);
        this.zzOy = changeType;
        this.zzOz = eventIndex;
        this.zzOA = changeData;
    }

    public AccountChangeEvent(long id, String accountName, int changeType, int eventIndex, String changeData) {
        this.mVersion = 1;
        this.zzOw = id;
        this.zzOx = zzu.zzu(accountName);
        this.zzOy = changeType;
        this.zzOz = eventIndex;
        this.zzOA = changeData;
    }

    public String getAccountName() {
        return this.zzOx;
    }

    public int getChangeType() {
        return this.zzOy;
    }

    public int getEventIndex() {
        return this.zzOz;
    }

    public String getChangeData() {
        return this.zzOA;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zza.zza(this, dest, flags);
    }

    public String toString() {
        String string2 = "UNKNOWN";
        switch (this.zzOy) {
            case 1: {
                string2 = "ADDED";
                break;
            }
            case 2: {
                string2 = "REMOVED";
                break;
            }
            case 4: {
                string2 = "RENAMED_TO";
                break;
            }
            case 3: {
                string2 = "RENAMED_FROM";
            }
        }
        return "AccountChangeEvent {accountName = " + this.zzOx + ", changeType = " + string2 + ", changeData = " + this.zzOA + ", eventIndex = " + this.zzOz + "}";
    }

    public int hashCode() {
        return zzt.hashCode(this.mVersion, this.zzOw, this.zzOx, this.zzOy, this.zzOz, this.zzOA);
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that instanceof AccountChangeEvent) {
            AccountChangeEvent accountChangeEvent = (AccountChangeEvent)that;
            return this.mVersion == accountChangeEvent.mVersion && this.zzOw == accountChangeEvent.zzOw && zzt.equal(this.zzOx, accountChangeEvent.zzOx) && this.zzOy == accountChangeEvent.zzOy && this.zzOz == accountChangeEvent.zzOz && zzt.equal(this.zzOA, accountChangeEvent.zzOA);
        }
        return false;
    }
}

