/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.zzlc;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int zzCY;
    private final String zzTL;
    private final String zzadI;
    private final Uri zzanf;
    private final Uri zzang;
    private final long zzanJ;
    private final int zzanK;
    private final long zzanL;
    private final String zzanq;
    private final String zzanr;
    private final String zzadv;
    private final MostRecentGameInfoEntity zzanM;
    private final PlayerLevelInfo zzanN;
    private final boolean zzanO;
    private final boolean zzanP;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean isPlusEnabled) {
        this.zzCY = 12;
        this.zzTL = isPlusEnabled ? player.getPlayerId() : null;
        this.zzadI = player.getDisplayName();
        this.zzanf = player.getIconImageUri();
        this.zzanq = player.getIconImageUrl();
        this.zzang = player.getHiResImageUri();
        this.zzanr = player.getHiResImageUrl();
        this.zzanJ = player.getRetrievedTimestamp();
        this.zzanK = player.zzrK();
        this.zzanL = player.getLastPlayedWithTimestamp();
        this.zzadv = player.getTitle();
        this.zzanO = player.isProfileVisible();
        MostRecentGameInfo mostRecentGameInfo = player.zzrL();
        this.zzanM = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.zzanN = player.getLevelInfo();
        this.zzanP = player.zzrJ();
        if (isPlusEnabled) {
            zzb.zzq(this.zzTL);
        }
        zzb.zzq(this.zzadI);
        zzb.zzU(this.zzanJ > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible, boolean hasDebugAccess) {
        this.zzCY = versionCode;
        this.zzTL = playerId;
        this.zzadI = displayName;
        this.zzanf = iconImageUri;
        this.zzanq = iconImageUrl;
        this.zzang = hiResImageUri;
        this.zzanr = hiResImageUrl;
        this.zzanJ = retrievedTimestamp;
        this.zzanK = isInCircles;
        this.zzanL = lastPlayedWithTimestamp;
        this.zzadv = title;
        this.zzanO = isProfileVisible;
        this.zzanM = mostRecentGameInfo;
        this.zzanN = playerLevelInfo;
        this.zzanP = hasDebugAccess;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public String getPlayerId() {
        return this.zzTL;
    }

    @Override
    public String getDisplayName() {
        return this.zzadI;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzadI, dataOut);
    }

    @Override
    public boolean zzrJ() {
        return this.zzanP;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzanf;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzanq;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzang;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzanr;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zzanJ;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzanL;
    }

    @Override
    public int zzrK() {
        return this.zzanK;
    }

    @Override
    public boolean isProfileVisible() {
        return this.zzanO;
    }

    @Override
    public String getTitle() {
        return this.zzadv;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzadv, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzanN;
    }

    @Override
    public MostRecentGameInfo zzrL() {
        return this.zzanM;
    }

    @Override
    public Player freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzt.hashCode(player.getPlayerId(), player.getDisplayName(), player.zzrJ(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzt.equal(player2.getPlayerId(), player.getPlayerId()) && zzt.equal(player2.getDisplayName(), player.getDisplayName()) && zzt.equal(player2.zzrJ(), player.zzrJ()) && zzt.equal(player2.getIconImageUri(), player.getIconImageUri()) && zzt.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && zzt.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp()) && zzt.equal(player2.getTitle(), player.getTitle()) && zzt.equal(player2.getLevelInfo(), player.getLevelInfo());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzt.zzt(player).zzg("PlayerId", player.getPlayerId()).zzg("DisplayName", player.getDisplayName()).zzg("HasDebugAccess", player.zzrJ()).zzg("IconImageUri", player.getIconImageUri()).zzg("IconImageUrl", player.getIconImageUrl()).zzg("HiResImageUri", player.getHiResImageUri()).zzg("HiResImageUrl", player.getHiResImageUrl()).zzg("RetrievedTimestamp", player.getRetrievedTimestamp()).zzg("Title", player.getTitle()).zzg("LevelInfo", player.getLevelInfo()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zznF()) {
            PlayerEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzTL);
            dest.writeString(this.zzadI);
            dest.writeString(this.zzanf == null ? null : this.zzanf.toString());
            dest.writeString(this.zzang == null ? null : this.zzang.toString());
            dest.writeLong(this.zzanJ);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzds(Parcel parcel) {
            boolean bl = PlayerEntity.zzd(PlayerEntity.zznE());
            if (bl || PlayerEntity.zzca(PlayerEntity.class.getCanonicalName())) {
                return super.zzds(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            long l = parcel.readLong();
            int n = -1;
            long l2 = -1L;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl2 = true;
            boolean bl3 = false;
            return new PlayerEntity(12, string2, string3, uri, uri2, l, n, l2, string6, string7, string8, mostRecentGameInfoEntity, playerLevelInfo, bl2, bl3);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzds(x0);
        }
    }
}

