/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.zzlc;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzatD;
    private final String zzatE;
    private final String zzatF;
    private final long zzatG;
    private final long zzatH;
    private final String zzatI;
    private final Uri zzatJ;
    private final Uri zzatK;
    private final PlayerEntity zzatL;
    private final String zzatM;
    private final String zzatN;
    private final String zzatO;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.zzatD = score.getRank();
        this.zzatE = zzu.zzu(score.getDisplayRank());
        this.zzatF = zzu.zzu(score.getDisplayScore());
        this.zzatG = score.getRawScore();
        this.zzatH = score.getTimestampMillis();
        this.zzatI = score.getScoreHolderDisplayName();
        this.zzatJ = score.getScoreHolderIconImageUri();
        this.zzatK = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.zzatL = player == null ? null : (PlayerEntity)player.freeze();
        this.zzatM = score.getScoreTag();
        this.zzatN = score.getScoreHolderIconImageUrl();
        this.zzatO = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzatD;
    }

    @Override
    public String getDisplayRank() {
        return this.zzatE;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzatE, dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.zzatF;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzatF, dataOut);
    }

    @Override
    public long getRawScore() {
        return this.zzatG;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzatH;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzatL == null) {
            return this.zzatI;
        }
        return this.zzatL.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzatL == null) {
            zzlc.zzb(this.zzatI, dataOut);
            return;
        }
        this.zzatL.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzatL == null) {
            return this.zzatJ;
        }
        return this.zzatL.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzatL == null) {
            return this.zzatN;
        }
        return this.zzatL.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzatL == null) {
            return this.zzatK;
        }
        return this.zzatL.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzatL == null) {
            return this.zzatO;
        }
        return this.zzatL.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzatL;
    }

    @Override
    public String getScoreTag() {
        return this.zzatM;
    }

    public LeaderboardScore zztG() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzt.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzt.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && zzt.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && zzt.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && zzt.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && zzt.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && zzt.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && zzt.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && zzt.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && zzt.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && zzt.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzt.zzt(leaderboardScore).zzg("Rank", leaderboardScore.getRank()).zzg("DisplayRank", leaderboardScore.getDisplayRank()).zzg("Score", leaderboardScore.getRawScore()).zzg("DisplayScore", leaderboardScore.getDisplayScore()).zzg("Timestamp", leaderboardScore.getTimestampMillis()).zzg("DisplayName", leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).zzg("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.zztG();
    }
}

