/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzm;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzaCb;
    private GoogleMap zzaBV;

    public MapView(Context context) {
        super(context);
        this.zzaCb = new zzb((ViewGroup)this, context, null);
        this.init();
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zzaCb = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.init();
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zzaCb = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.init();
    }

    public MapView(Context context, GoogleMapOptions options) {
        super(context);
        this.zzaCb = new zzb((ViewGroup)this, context, options);
        this.init();
    }

    private void init() {
        this.setClickable(true);
    }

    @Deprecated
    public final GoogleMap getMap() {
        if (this.zzaBV != null) {
            return this.zzaBV;
        }
        this.zzaCb.zzvu();
        if (this.zzaCb.zzqj() == null) {
            return null;
        }
        try {
            this.zzaBV = new GoogleMap(((zza)this.zzaCb.zzqj()).zzvv().getMap());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this.zzaBV;
    }

    public final void onCreate(Bundle savedInstanceState) {
        this.zzaCb.onCreate(savedInstanceState);
        if (this.zzaCb.zzqj() == null) {
            com.google.android.gms.dynamic.zza.zzb(this);
        }
    }

    public final void onResume() {
        this.zzaCb.onResume();
    }

    public final void onPause() {
        this.zzaCb.onPause();
    }

    public final void onDestroy() {
        this.zzaCb.onDestroy();
    }

    public final void onLowMemory() {
        this.zzaCb.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle outState) {
        this.zzaCb.onSaveInstanceState(outState);
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        zzu.zzbY("getMapAsync() must be called on the main thread");
        this.zzaCb.getMapAsync(callback);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzaCg;
        private final Context mContext;
        protected zzf<zza> zzaBZ;
        private final GoogleMapOptions zzaCh;
        private final List<OnMapReadyCallback> zzaCa = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzaCg = viewGroup;
            this.mContext = context;
            this.zzaCh = googleMapOptions;
        }

        @Override
        protected void zza(zzf<zza> zzf2) {
            this.zzaBZ = zzf2;
            this.zzvu();
        }

        public void zzvu() {
            if (this.zzaBZ != null && this.zzqj() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzy.zzay(this.mContext).zza(zze.zzw(this.mContext), this.zzaCh);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.zzaBZ.zza(new zza(this.zzaCg, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaCa) {
                        ((zza)this.zzqj()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaCa.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zzqj() != null) {
                ((zza)this.zzqj()).getMapAsync(callback);
            } else {
                this.zzaCa.add(callback);
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzaCc;
        private final IMapViewDelegate zzaCd;
        private View zzaCe;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzaCd = zzu.zzu(iMapViewDelegate);
            this.zzaCc = zzu.zzu(viewGroup);
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaCd.onCreate(savedInstanceState);
                this.zzaCe = (View)zze.zzn(this.zzaCd.getView());
                this.zzaCc.removeAllViews();
                this.zzaCc.addView(this.zzaCe);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onResume() {
            try {
                this.zzaCd.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.zzaCd.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        @Override
        public void onDestroy() {
            try {
                this.zzaCd.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onLowMemory() {
            try {
                this.zzaCd.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaCd.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapViewDelegate zzvv() {
            return this.zzaCd;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaCd.getMapAsync(new zzm.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

