// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/binaryauthorization/v1/service.proto

package binaryauthorizationpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/grafeas/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The enum returned in the "result" field.
type ValidateAttestationOccurrenceResponse_Result int32

const (
	// Unspecified.
	ValidateAttestationOccurrenceResponse_RESULT_UNSPECIFIED ValidateAttestationOccurrenceResponse_Result = 0
	// The Attestation was able to verified by the Attestor.
	ValidateAttestationOccurrenceResponse_VERIFIED ValidateAttestationOccurrenceResponse_Result = 1
	// The Attestation was not able to verified by the Attestor.
	ValidateAttestationOccurrenceResponse_ATTESTATION_NOT_VERIFIABLE ValidateAttestationOccurrenceResponse_Result = 2
)

// Enum value maps for ValidateAttestationOccurrenceResponse_Result.
var (
	ValidateAttestationOccurrenceResponse_Result_name = map[int32]string{
		0: "RESULT_UNSPECIFIED",
		1: "VERIFIED",
		2: "ATTESTATION_NOT_VERIFIABLE",
	}
	ValidateAttestationOccurrenceResponse_Result_value = map[string]int32{
		"RESULT_UNSPECIFIED":         0,
		"VERIFIED":                   1,
		"ATTESTATION_NOT_VERIFIABLE": 2,
	}
)

func (x ValidateAttestationOccurrenceResponse_Result) Enum() *ValidateAttestationOccurrenceResponse_Result {
	p := new(ValidateAttestationOccurrenceResponse_Result)
	*p = x
	return p
}

func (x ValidateAttestationOccurrenceResponse_Result) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValidateAttestationOccurrenceResponse_Result) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_binaryauthorization_v1_service_proto_enumTypes[0].Descriptor()
}

func (ValidateAttestationOccurrenceResponse_Result) Type() protoreflect.EnumType {
	return &file_google_cloud_binaryauthorization_v1_service_proto_enumTypes[0]
}

func (x ValidateAttestationOccurrenceResponse_Result) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValidateAttestationOccurrenceResponse_Result.Descriptor instead.
func (ValidateAttestationOccurrenceResponse_Result) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{10, 0}
}

// Request message for [BinauthzManagementService.GetPolicy][].
type GetPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the [policy][google.cloud.binaryauthorization.v1.Policy] to retrieve,
	// in the format `projects/*/policy`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPolicyRequest) Reset() {
	*x = GetPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPolicyRequest) ProtoMessage() {}

func (x *GetPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [BinauthzManagementService.UpdatePolicy][].
type UpdatePolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new or updated [policy][google.cloud.binaryauthorization.v1.Policy] value. The service will
	// overwrite the [policy name][google.cloud.binaryauthorization.v1.Policy.name] field with the resource name in
	// the request URL, in the format `projects/*/policy`.
	Policy *Policy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *UpdatePolicyRequest) Reset() {
	*x = UpdatePolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePolicyRequest) ProtoMessage() {}

func (x *UpdatePolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdatePolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{1}
}

func (x *UpdatePolicyRequest) GetPolicy() *Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

// Request message for [BinauthzManagementService.CreateAttestor][].
type CreateAttestorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent of this [attestor][google.cloud.binaryauthorization.v1.Attestor].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The [attestors][google.cloud.binaryauthorization.v1.Attestor] ID.
	AttestorId string `protobuf:"bytes,2,opt,name=attestor_id,json=attestorId,proto3" json:"attestor_id,omitempty"`
	// Required. The initial [attestor][google.cloud.binaryauthorization.v1.Attestor] value. The service will
	// overwrite the [attestor name][google.cloud.binaryauthorization.v1.Attestor.name] field with the resource name,
	// in the format `projects/*/attestors/*`.
	Attestor *Attestor `protobuf:"bytes,3,opt,name=attestor,proto3" json:"attestor,omitempty"`
}

func (x *CreateAttestorRequest) Reset() {
	*x = CreateAttestorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAttestorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAttestorRequest) ProtoMessage() {}

func (x *CreateAttestorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAttestorRequest.ProtoReflect.Descriptor instead.
func (*CreateAttestorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{2}
}

func (x *CreateAttestorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAttestorRequest) GetAttestorId() string {
	if x != nil {
		return x.AttestorId
	}
	return ""
}

func (x *CreateAttestorRequest) GetAttestor() *Attestor {
	if x != nil {
		return x.Attestor
	}
	return nil
}

// Request message for [BinauthzManagementService.GetAttestor][].
type GetAttestorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the [attestor][google.cloud.binaryauthorization.v1.Attestor] to retrieve, in the format
	// `projects/*/attestors/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAttestorRequest) Reset() {
	*x = GetAttestorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAttestorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAttestorRequest) ProtoMessage() {}

func (x *GetAttestorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAttestorRequest.ProtoReflect.Descriptor instead.
func (*GetAttestorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{3}
}

func (x *GetAttestorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [BinauthzManagementService.UpdateAttestor][].
type UpdateAttestorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated [attestor][google.cloud.binaryauthorization.v1.Attestor] value. The service will
	// overwrite the [attestor name][google.cloud.binaryauthorization.v1.Attestor.name] field with the resource name
	// in the request URL, in the format `projects/*/attestors/*`.
	Attestor *Attestor `protobuf:"bytes,1,opt,name=attestor,proto3" json:"attestor,omitempty"`
}

func (x *UpdateAttestorRequest) Reset() {
	*x = UpdateAttestorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAttestorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAttestorRequest) ProtoMessage() {}

func (x *UpdateAttestorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAttestorRequest.ProtoReflect.Descriptor instead.
func (*UpdateAttestorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateAttestorRequest) GetAttestor() *Attestor {
	if x != nil {
		return x.Attestor
	}
	return nil
}

// Request message for [BinauthzManagementService.ListAttestors][].
type ListAttestorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the project associated with the
	// [attestors][google.cloud.binaryauthorization.v1.Attestor], in the format `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. The server may return fewer results than requested. If
	// unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return. Typically,
	// this is the value of [ListAttestorsResponse.next_page_token][google.cloud.binaryauthorization.v1.ListAttestorsResponse.next_page_token] returned
	// from the previous call to the `ListAttestors` method.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAttestorsRequest) Reset() {
	*x = ListAttestorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAttestorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAttestorsRequest) ProtoMessage() {}

func (x *ListAttestorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAttestorsRequest.ProtoReflect.Descriptor instead.
func (*ListAttestorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListAttestorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAttestorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAttestorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for [BinauthzManagementService.ListAttestors][].
type ListAttestorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of [attestors][google.cloud.binaryauthorization.v1.Attestor].
	Attestors []*Attestor `protobuf:"bytes,1,rep,name=attestors,proto3" json:"attestors,omitempty"`
	// A token to retrieve the next page of results. Pass this value in the
	// [ListAttestorsRequest.page_token][google.cloud.binaryauthorization.v1.ListAttestorsRequest.page_token] field in the subsequent call to the
	// `ListAttestors` method to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAttestorsResponse) Reset() {
	*x = ListAttestorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAttestorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAttestorsResponse) ProtoMessage() {}

func (x *ListAttestorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAttestorsResponse.ProtoReflect.Descriptor instead.
func (*ListAttestorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListAttestorsResponse) GetAttestors() []*Attestor {
	if x != nil {
		return x.Attestors
	}
	return nil
}

func (x *ListAttestorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for [BinauthzManagementService.DeleteAttestor][].
type DeleteAttestorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the [attestors][google.cloud.binaryauthorization.v1.Attestor] to delete, in the format
	// `projects/*/attestors/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAttestorRequest) Reset() {
	*x = DeleteAttestorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAttestorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAttestorRequest) ProtoMessage() {}

func (x *DeleteAttestorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAttestorRequest.ProtoReflect.Descriptor instead.
func (*DeleteAttestorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteAttestorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to read the current system policy.
type GetSystemPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name, in the format `locations/*/policy`.
	// Note that the system policy is not associated with a project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSystemPolicyRequest) Reset() {
	*x = GetSystemPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSystemPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSystemPolicyRequest) ProtoMessage() {}

func (x *GetSystemPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSystemPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetSystemPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetSystemPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [ValidationHelperV1.ValidateAttestationOccurrence][google.cloud.binaryauthorization.v1.ValidationHelperV1.ValidateAttestationOccurrence].
type ValidateAttestationOccurrenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the [Attestor][google.cloud.binaryauthorization.v1.Attestor] of the
	// [occurrence][grafeas.v1.Occurrence], in the format
	// `projects/*/attestors/*`.
	Attestor string `protobuf:"bytes,1,opt,name=attestor,proto3" json:"attestor,omitempty"`
	// Required. An [AttestationOccurrence][grafeas.v1.AttestationOccurrence] to
	// be checked that it can be verified by the Attestor. It does not have to be
	// an existing entity in Container Analysis. It must otherwise be a valid
	// AttestationOccurrence.
	Attestation *v1.AttestationOccurrence `protobuf:"bytes,2,opt,name=attestation,proto3" json:"attestation,omitempty"`
	// Required. The resource name of the [Note][grafeas.v1.Note] to which the
	// containing [Occurrence][grafeas.v1.Occurrence] is associated.
	OccurrenceNote string `protobuf:"bytes,3,opt,name=occurrence_note,json=occurrenceNote,proto3" json:"occurrence_note,omitempty"`
	// Required. The URI of the artifact (e.g. container image) that is the
	// subject of the containing [Occurrence][grafeas.v1.Occurrence].
	OccurrenceResourceUri string `protobuf:"bytes,4,opt,name=occurrence_resource_uri,json=occurrenceResourceUri,proto3" json:"occurrence_resource_uri,omitempty"`
}

func (x *ValidateAttestationOccurrenceRequest) Reset() {
	*x = ValidateAttestationOccurrenceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateAttestationOccurrenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateAttestationOccurrenceRequest) ProtoMessage() {}

func (x *ValidateAttestationOccurrenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateAttestationOccurrenceRequest.ProtoReflect.Descriptor instead.
func (*ValidateAttestationOccurrenceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{9}
}

func (x *ValidateAttestationOccurrenceRequest) GetAttestor() string {
	if x != nil {
		return x.Attestor
	}
	return ""
}

func (x *ValidateAttestationOccurrenceRequest) GetAttestation() *v1.AttestationOccurrence {
	if x != nil {
		return x.Attestation
	}
	return nil
}

func (x *ValidateAttestationOccurrenceRequest) GetOccurrenceNote() string {
	if x != nil {
		return x.OccurrenceNote
	}
	return ""
}

func (x *ValidateAttestationOccurrenceRequest) GetOccurrenceResourceUri() string {
	if x != nil {
		return x.OccurrenceResourceUri
	}
	return ""
}

// Response message for
// [ValidationHelperV1.ValidateAttestationOccurrence][google.cloud.binaryauthorization.v1.ValidationHelperV1.ValidateAttestationOccurrence].
type ValidateAttestationOccurrenceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of the Attestation validation.
	Result ValidateAttestationOccurrenceResponse_Result `protobuf:"varint,1,opt,name=result,proto3,enum=google.cloud.binaryauthorization.v1.ValidateAttestationOccurrenceResponse_Result" json:"result,omitempty"`
	// The reason for denial if the Attestation couldn't be validated.
	DenialReason string `protobuf:"bytes,2,opt,name=denial_reason,json=denialReason,proto3" json:"denial_reason,omitempty"`
}

func (x *ValidateAttestationOccurrenceResponse) Reset() {
	*x = ValidateAttestationOccurrenceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateAttestationOccurrenceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateAttestationOccurrenceResponse) ProtoMessage() {}

func (x *ValidateAttestationOccurrenceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateAttestationOccurrenceResponse.ProtoReflect.Descriptor instead.
func (*ValidateAttestationOccurrenceResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP(), []int{10}
}

func (x *ValidateAttestationOccurrenceResponse) GetResult() ValidateAttestationOccurrenceResponse_Result {
	if x != nil {
		return x.Result
	}
	return ValidateAttestationOccurrenceResponse_RESULT_UNSPECIFIED
}

func (x *ValidateAttestationOccurrenceResponse) GetDenialReason() string {
	if x != nil {
		return x.DenialReason
	}
	return ""
}

var File_google_cloud_binaryauthorization_v1_service_proto protoreflect.FileDescriptor

var file_google_cloud_binaryauthorization_v1_service_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x59, 0x0a, 0x10, 0x47,
	0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5f, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a,
	0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xda, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x24,
	0x0a, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x49, 0x64, 0x12, 0x4e, 0x0a, 0x08, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x22, 0x5d, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x67, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x08,
	0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x22, 0x9f, 0x01, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8c,
	0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x09, 0x61, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72,
	0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x52, 0x09, 0x61, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x60, 0x0a,
	0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x62, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x5f, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a,
	0x29, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xfc, 0x01, 0x0a, 0x24, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x12, 0x48, 0x0a, 0x0b, 0x61, 0x74,
	0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0e, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x6f,
	0x74, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x22,
	0x87, 0x02, 0x0a, 0x25, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x69, 0x0a, 0x06, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x65, 0x6e, 0x69, 0x61, 0x6c, 0x5f, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x65, 0x6e,
	0x69, 0x61, 0x6c, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x4e, 0x0a, 0x06, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x56,
	0x45, 0x52, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x54, 0x54,
	0x45, 0x53, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x56, 0x45, 0x52,
	0x49, 0x46, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x32, 0xe2, 0x0a, 0x0a, 0x1b, 0x42, 0x69,
	0x6e, 0x61, 0x75, 0x74, 0x68, 0x7a, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x56, 0x31, 0x12, 0x9c, 0x01, 0x0a, 0x09, 0x47, 0x65,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x2b, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x12, 0xb3, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0x3c, 0xda, 0x41, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2d, 0x3a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x12, 0xce,
	0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x74,
	0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x22, 0x51, 0xda, 0x41,
	0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x5f, 0x69, 0x64, 0x2c, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2d, 0x3a, 0x08, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x22, 0x21, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x12,
	0xa7, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x22, 0x30, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc4, 0x01, 0x0a, 0x0e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x12, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61,
	0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x22, 0x47, 0xda, 0x41, 0x08, 0x61, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x08, 0x61, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x1a, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xba, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x96, 0x01,
	0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x30, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x23, 0x2a, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x56, 0xca, 0x41, 0x22, 0x62, 0x69, 0x6e, 0x61, 0x72,
	0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x32, 0x94,
	0x02, 0x0a, 0x0e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56,
	0x31, 0x12, 0xa9, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22,
	0x2c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x12, 0x1d,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x1a, 0x56, 0xca,
	0x41, 0x22, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x32, 0xf5, 0x02, 0x0a, 0x12, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x6c, 0x70, 0x65, 0x72, 0x56, 0x31, 0x12, 0x86, 0x02, 0x0a,
	0x1d, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x49,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a, 0x01, 0x2a,
	0x22, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x56, 0xca, 0x41, 0x22, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x8c, 0x02,
	0x0a, 0x35, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x50, 0x00, 0x5a, 0x59, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62,
	0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x62,
	0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x23,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_binaryauthorization_v1_service_proto_rawDescOnce sync.Once
	file_google_cloud_binaryauthorization_v1_service_proto_rawDescData = file_google_cloud_binaryauthorization_v1_service_proto_rawDesc
)

func file_google_cloud_binaryauthorization_v1_service_proto_rawDescGZIP() []byte {
	file_google_cloud_binaryauthorization_v1_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_binaryauthorization_v1_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_binaryauthorization_v1_service_proto_rawDescData)
	})
	return file_google_cloud_binaryauthorization_v1_service_proto_rawDescData
}

var file_google_cloud_binaryauthorization_v1_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_binaryauthorization_v1_service_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_binaryauthorization_v1_service_proto_goTypes = []interface{}{
	(ValidateAttestationOccurrenceResponse_Result)(0), // 0: google.cloud.binaryauthorization.v1.ValidateAttestationOccurrenceResponse.Result
	(*GetPolicyRequest)(nil),                          // 1: google.cloud.binaryauthorization.v1.GetPolicyRequest
	(*UpdatePolicyRequest)(nil),                       // 2: google.cloud.binaryauthorization.v1.UpdatePolicyRequest
	(*CreateAttestorRequest)(nil),                     // 3: google.cloud.binaryauthorization.v1.CreateAttestorRequest
	(*GetAttestorRequest)(nil),                        // 4: google.cloud.binaryauthorization.v1.GetAttestorRequest
	(*UpdateAttestorRequest)(nil),                     // 5: google.cloud.binaryauthorization.v1.UpdateAttestorRequest
	(*ListAttestorsRequest)(nil),                      // 6: google.cloud.binaryauthorization.v1.ListAttestorsRequest
	(*ListAttestorsResponse)(nil),                     // 7: google.cloud.binaryauthorization.v1.ListAttestorsResponse
	(*DeleteAttestorRequest)(nil),                     // 8: google.cloud.binaryauthorization.v1.DeleteAttestorRequest
	(*GetSystemPolicyRequest)(nil),                    // 9: google.cloud.binaryauthorization.v1.GetSystemPolicyRequest
	(*ValidateAttestationOccurrenceRequest)(nil),      // 10: google.cloud.binaryauthorization.v1.ValidateAttestationOccurrenceRequest
	(*ValidateAttestationOccurrenceResponse)(nil),     // 11: google.cloud.binaryauthorization.v1.ValidateAttestationOccurrenceResponse
	(*Policy)(nil),                                    // 12: google.cloud.binaryauthorization.v1.Policy
	(*Attestor)(nil),                                  // 13: google.cloud.binaryauthorization.v1.Attestor
	(*v1.AttestationOccurrence)(nil),                  // 14: grafeas.v1.AttestationOccurrence
	(*emptypb.Empty)(nil),                             // 15: google.protobuf.Empty
}
var file_google_cloud_binaryauthorization_v1_service_proto_depIdxs = []int32{
	12, // 0: google.cloud.binaryauthorization.v1.UpdatePolicyRequest.policy:type_name -> google.cloud.binaryauthorization.v1.Policy
	13, // 1: google.cloud.binaryauthorization.v1.CreateAttestorRequest.attestor:type_name -> google.cloud.binaryauthorization.v1.Attestor
	13, // 2: google.cloud.binaryauthorization.v1.UpdateAttestorRequest.attestor:type_name -> google.cloud.binaryauthorization.v1.Attestor
	13, // 3: google.cloud.binaryauthorization.v1.ListAttestorsResponse.attestors:type_name -> google.cloud.binaryauthorization.v1.Attestor
	14, // 4: google.cloud.binaryauthorization.v1.ValidateAttestationOccurrenceRequest.attestation:type_name -> grafeas.v1.AttestationOccurrence
	0,  // 5: google.cloud.binaryauthorization.v1.ValidateAttestationOccurrenceResponse.result:type_name -> google.cloud.binaryauthorization.v1.ValidateAttestationOccurrenceResponse.Result
	1,  // 6: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.GetPolicy:input_type -> google.cloud.binaryauthorization.v1.GetPolicyRequest
	2,  // 7: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.UpdatePolicy:input_type -> google.cloud.binaryauthorization.v1.UpdatePolicyRequest
	3,  // 8: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.CreateAttestor:input_type -> google.cloud.binaryauthorization.v1.CreateAttestorRequest
	4,  // 9: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.GetAttestor:input_type -> google.cloud.binaryauthorization.v1.GetAttestorRequest
	5,  // 10: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.UpdateAttestor:input_type -> google.cloud.binaryauthorization.v1.UpdateAttestorRequest
	6,  // 11: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.ListAttestors:input_type -> google.cloud.binaryauthorization.v1.ListAttestorsRequest
	8,  // 12: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.DeleteAttestor:input_type -> google.cloud.binaryauthorization.v1.DeleteAttestorRequest
	9,  // 13: google.cloud.binaryauthorization.v1.SystemPolicyV1.GetSystemPolicy:input_type -> google.cloud.binaryauthorization.v1.GetSystemPolicyRequest
	10, // 14: google.cloud.binaryauthorization.v1.ValidationHelperV1.ValidateAttestationOccurrence:input_type -> google.cloud.binaryauthorization.v1.ValidateAttestationOccurrenceRequest
	12, // 15: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.GetPolicy:output_type -> google.cloud.binaryauthorization.v1.Policy
	12, // 16: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.UpdatePolicy:output_type -> google.cloud.binaryauthorization.v1.Policy
	13, // 17: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.CreateAttestor:output_type -> google.cloud.binaryauthorization.v1.Attestor
	13, // 18: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.GetAttestor:output_type -> google.cloud.binaryauthorization.v1.Attestor
	13, // 19: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.UpdateAttestor:output_type -> google.cloud.binaryauthorization.v1.Attestor
	7,  // 20: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.ListAttestors:output_type -> google.cloud.binaryauthorization.v1.ListAttestorsResponse
	15, // 21: google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1.DeleteAttestor:output_type -> google.protobuf.Empty
	12, // 22: google.cloud.binaryauthorization.v1.SystemPolicyV1.GetSystemPolicy:output_type -> google.cloud.binaryauthorization.v1.Policy
	11, // 23: google.cloud.binaryauthorization.v1.ValidationHelperV1.ValidateAttestationOccurrence:output_type -> google.cloud.binaryauthorization.v1.ValidateAttestationOccurrenceResponse
	15, // [15:24] is the sub-list for method output_type
	6,  // [6:15] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_binaryauthorization_v1_service_proto_init() }
func file_google_cloud_binaryauthorization_v1_service_proto_init() {
	if File_google_cloud_binaryauthorization_v1_service_proto != nil {
		return
	}
	file_google_cloud_binaryauthorization_v1_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAttestorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAttestorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAttestorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAttestorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAttestorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAttestorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSystemPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateAttestationOccurrenceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_binaryauthorization_v1_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateAttestationOccurrenceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_binaryauthorization_v1_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   3,
		},
		GoTypes:           file_google_cloud_binaryauthorization_v1_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_binaryauthorization_v1_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_binaryauthorization_v1_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_binaryauthorization_v1_service_proto_msgTypes,
	}.Build()
	File_google_cloud_binaryauthorization_v1_service_proto = out.File
	file_google_cloud_binaryauthorization_v1_service_proto_rawDesc = nil
	file_google_cloud_binaryauthorization_v1_service_proto_goTypes = nil
	file_google_cloud_binaryauthorization_v1_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BinauthzManagementServiceV1Client is the client API for BinauthzManagementServiceV1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BinauthzManagementServiceV1Client interface {
	// A [policy][google.cloud.binaryauthorization.v1.Policy] specifies the [attestors][google.cloud.binaryauthorization.v1.Attestor] that must attest to
	// a container image, before the project is allowed to deploy that
	// image. There is at most one policy per project. All image admission
	// requests are permitted if a project has no policy.
	//
	// Gets the [policy][google.cloud.binaryauthorization.v1.Policy] for this project. Returns a default
	// [policy][google.cloud.binaryauthorization.v1.Policy] if the project does not have one.
	GetPolicy(ctx context.Context, in *GetPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates or updates a project's [policy][google.cloud.binaryauthorization.v1.Policy], and returns a copy of the
	// new [policy][google.cloud.binaryauthorization.v1.Policy]. A policy is always updated as a whole, to avoid race
	// conditions with concurrent policy enforcement (or management!)
	// requests. Returns NOT_FOUND if the project does not exist, INVALID_ARGUMENT
	// if the request is malformed.
	UpdatePolicy(ctx context.Context, in *UpdatePolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates an [attestor][google.cloud.binaryauthorization.v1.Attestor], and returns a copy of the new
	// [attestor][google.cloud.binaryauthorization.v1.Attestor]. Returns NOT_FOUND if the project does not exist,
	// INVALID_ARGUMENT if the request is malformed, ALREADY_EXISTS if the
	// [attestor][google.cloud.binaryauthorization.v1.Attestor] already exists.
	CreateAttestor(ctx context.Context, in *CreateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error)
	// Gets an [attestor][google.cloud.binaryauthorization.v1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	GetAttestor(ctx context.Context, in *GetAttestorRequest, opts ...grpc.CallOption) (*Attestor, error)
	// Updates an [attestor][google.cloud.binaryauthorization.v1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	UpdateAttestor(ctx context.Context, in *UpdateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error)
	// Lists [attestors][google.cloud.binaryauthorization.v1.Attestor].
	// Returns INVALID_ARGUMENT if the project does not exist.
	ListAttestors(ctx context.Context, in *ListAttestorsRequest, opts ...grpc.CallOption) (*ListAttestorsResponse, error)
	// Deletes an [attestor][google.cloud.binaryauthorization.v1.Attestor]. Returns NOT_FOUND if the
	// [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	DeleteAttestor(ctx context.Context, in *DeleteAttestorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type binauthzManagementServiceV1Client struct {
	cc grpc.ClientConnInterface
}

func NewBinauthzManagementServiceV1Client(cc grpc.ClientConnInterface) BinauthzManagementServiceV1Client {
	return &binauthzManagementServiceV1Client{cc}
}

func (c *binauthzManagementServiceV1Client) GetPolicy(ctx context.Context, in *GetPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/GetPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) UpdatePolicy(ctx context.Context, in *UpdatePolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/UpdatePolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) CreateAttestor(ctx context.Context, in *CreateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error) {
	out := new(Attestor)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/CreateAttestor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) GetAttestor(ctx context.Context, in *GetAttestorRequest, opts ...grpc.CallOption) (*Attestor, error) {
	out := new(Attestor)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/GetAttestor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) UpdateAttestor(ctx context.Context, in *UpdateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error) {
	out := new(Attestor)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/UpdateAttestor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) ListAttestors(ctx context.Context, in *ListAttestorsRequest, opts ...grpc.CallOption) (*ListAttestorsResponse, error) {
	out := new(ListAttestorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/ListAttestors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Client) DeleteAttestor(ctx context.Context, in *DeleteAttestorRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/DeleteAttestor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BinauthzManagementServiceV1Server is the server API for BinauthzManagementServiceV1 service.
type BinauthzManagementServiceV1Server interface {
	// A [policy][google.cloud.binaryauthorization.v1.Policy] specifies the [attestors][google.cloud.binaryauthorization.v1.Attestor] that must attest to
	// a container image, before the project is allowed to deploy that
	// image. There is at most one policy per project. All image admission
	// requests are permitted if a project has no policy.
	//
	// Gets the [policy][google.cloud.binaryauthorization.v1.Policy] for this project. Returns a default
	// [policy][google.cloud.binaryauthorization.v1.Policy] if the project does not have one.
	GetPolicy(context.Context, *GetPolicyRequest) (*Policy, error)
	// Creates or updates a project's [policy][google.cloud.binaryauthorization.v1.Policy], and returns a copy of the
	// new [policy][google.cloud.binaryauthorization.v1.Policy]. A policy is always updated as a whole, to avoid race
	// conditions with concurrent policy enforcement (or management!)
	// requests. Returns NOT_FOUND if the project does not exist, INVALID_ARGUMENT
	// if the request is malformed.
	UpdatePolicy(context.Context, *UpdatePolicyRequest) (*Policy, error)
	// Creates an [attestor][google.cloud.binaryauthorization.v1.Attestor], and returns a copy of the new
	// [attestor][google.cloud.binaryauthorization.v1.Attestor]. Returns NOT_FOUND if the project does not exist,
	// INVALID_ARGUMENT if the request is malformed, ALREADY_EXISTS if the
	// [attestor][google.cloud.binaryauthorization.v1.Attestor] already exists.
	CreateAttestor(context.Context, *CreateAttestorRequest) (*Attestor, error)
	// Gets an [attestor][google.cloud.binaryauthorization.v1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	GetAttestor(context.Context, *GetAttestorRequest) (*Attestor, error)
	// Updates an [attestor][google.cloud.binaryauthorization.v1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	UpdateAttestor(context.Context, *UpdateAttestorRequest) (*Attestor, error)
	// Lists [attestors][google.cloud.binaryauthorization.v1.Attestor].
	// Returns INVALID_ARGUMENT if the project does not exist.
	ListAttestors(context.Context, *ListAttestorsRequest) (*ListAttestorsResponse, error)
	// Deletes an [attestor][google.cloud.binaryauthorization.v1.Attestor]. Returns NOT_FOUND if the
	// [attestor][google.cloud.binaryauthorization.v1.Attestor] does not exist.
	DeleteAttestor(context.Context, *DeleteAttestorRequest) (*emptypb.Empty, error)
}

// UnimplementedBinauthzManagementServiceV1Server can be embedded to have forward compatible implementations.
type UnimplementedBinauthzManagementServiceV1Server struct {
}

func (*UnimplementedBinauthzManagementServiceV1Server) GetPolicy(context.Context, *GetPolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicy not implemented")
}
func (*UnimplementedBinauthzManagementServiceV1Server) UpdatePolicy(context.Context, *UpdatePolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePolicy not implemented")
}
func (*UnimplementedBinauthzManagementServiceV1Server) CreateAttestor(context.Context, *CreateAttestorRequest) (*Attestor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAttestor not implemented")
}
func (*UnimplementedBinauthzManagementServiceV1Server) GetAttestor(context.Context, *GetAttestorRequest) (*Attestor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttestor not implemented")
}
func (*UnimplementedBinauthzManagementServiceV1Server) UpdateAttestor(context.Context, *UpdateAttestorRequest) (*Attestor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAttestor not implemented")
}
func (*UnimplementedBinauthzManagementServiceV1Server) ListAttestors(context.Context, *ListAttestorsRequest) (*ListAttestorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAttestors not implemented")
}
func (*UnimplementedBinauthzManagementServiceV1Server) DeleteAttestor(context.Context, *DeleteAttestorRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAttestor not implemented")
}

func RegisterBinauthzManagementServiceV1Server(s *grpc.Server, srv BinauthzManagementServiceV1Server) {
	s.RegisterService(&_BinauthzManagementServiceV1_serviceDesc, srv)
}

func _BinauthzManagementServiceV1_GetPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).GetPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/GetPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).GetPolicy(ctx, req.(*GetPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_UpdatePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).UpdatePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/UpdatePolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).UpdatePolicy(ctx, req.(*UpdatePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_CreateAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).CreateAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/CreateAttestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).CreateAttestor(ctx, req.(*CreateAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_GetAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).GetAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/GetAttestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).GetAttestor(ctx, req.(*GetAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_UpdateAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).UpdateAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/UpdateAttestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).UpdateAttestor(ctx, req.(*UpdateAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_ListAttestors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAttestorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).ListAttestors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/ListAttestors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).ListAttestors(ctx, req.(*ListAttestorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1_DeleteAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Server).DeleteAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1/DeleteAttestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Server).DeleteAttestor(ctx, req.(*DeleteAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BinauthzManagementServiceV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1",
	HandlerType: (*BinauthzManagementServiceV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPolicy",
			Handler:    _BinauthzManagementServiceV1_GetPolicy_Handler,
		},
		{
			MethodName: "UpdatePolicy",
			Handler:    _BinauthzManagementServiceV1_UpdatePolicy_Handler,
		},
		{
			MethodName: "CreateAttestor",
			Handler:    _BinauthzManagementServiceV1_CreateAttestor_Handler,
		},
		{
			MethodName: "GetAttestor",
			Handler:    _BinauthzManagementServiceV1_GetAttestor_Handler,
		},
		{
			MethodName: "UpdateAttestor",
			Handler:    _BinauthzManagementServiceV1_UpdateAttestor_Handler,
		},
		{
			MethodName: "ListAttestors",
			Handler:    _BinauthzManagementServiceV1_ListAttestors_Handler,
		},
		{
			MethodName: "DeleteAttestor",
			Handler:    _BinauthzManagementServiceV1_DeleteAttestor_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/binaryauthorization/v1/service.proto",
}

// SystemPolicyV1Client is the client API for SystemPolicyV1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SystemPolicyV1Client interface {
	// Gets the current system policy in the specified location.
	GetSystemPolicy(ctx context.Context, in *GetSystemPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
}

type systemPolicyV1Client struct {
	cc grpc.ClientConnInterface
}

func NewSystemPolicyV1Client(cc grpc.ClientConnInterface) SystemPolicyV1Client {
	return &systemPolicyV1Client{cc}
}

func (c *systemPolicyV1Client) GetSystemPolicy(ctx context.Context, in *GetSystemPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1.SystemPolicyV1/GetSystemPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SystemPolicyV1Server is the server API for SystemPolicyV1 service.
type SystemPolicyV1Server interface {
	// Gets the current system policy in the specified location.
	GetSystemPolicy(context.Context, *GetSystemPolicyRequest) (*Policy, error)
}

// UnimplementedSystemPolicyV1Server can be embedded to have forward compatible implementations.
type UnimplementedSystemPolicyV1Server struct {
}

func (*UnimplementedSystemPolicyV1Server) GetSystemPolicy(context.Context, *GetSystemPolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSystemPolicy not implemented")
}

func RegisterSystemPolicyV1Server(s *grpc.Server, srv SystemPolicyV1Server) {
	s.RegisterService(&_SystemPolicyV1_serviceDesc, srv)
}

func _SystemPolicyV1_GetSystemPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSystemPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemPolicyV1Server).GetSystemPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1.SystemPolicyV1/GetSystemPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemPolicyV1Server).GetSystemPolicy(ctx, req.(*GetSystemPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SystemPolicyV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.binaryauthorization.v1.SystemPolicyV1",
	HandlerType: (*SystemPolicyV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSystemPolicy",
			Handler:    _SystemPolicyV1_GetSystemPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/binaryauthorization/v1/service.proto",
}

// ValidationHelperV1Client is the client API for ValidationHelperV1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ValidationHelperV1Client interface {
	// Returns whether the given Attestation for the given image URI
	// was signed by the given Attestor
	ValidateAttestationOccurrence(ctx context.Context, in *ValidateAttestationOccurrenceRequest, opts ...grpc.CallOption) (*ValidateAttestationOccurrenceResponse, error)
}

type validationHelperV1Client struct {
	cc grpc.ClientConnInterface
}

func NewValidationHelperV1Client(cc grpc.ClientConnInterface) ValidationHelperV1Client {
	return &validationHelperV1Client{cc}
}

func (c *validationHelperV1Client) ValidateAttestationOccurrence(ctx context.Context, in *ValidateAttestationOccurrenceRequest, opts ...grpc.CallOption) (*ValidateAttestationOccurrenceResponse, error) {
	out := new(ValidateAttestationOccurrenceResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1.ValidationHelperV1/ValidateAttestationOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ValidationHelperV1Server is the server API for ValidationHelperV1 service.
type ValidationHelperV1Server interface {
	// Returns whether the given Attestation for the given image URI
	// was signed by the given Attestor
	ValidateAttestationOccurrence(context.Context, *ValidateAttestationOccurrenceRequest) (*ValidateAttestationOccurrenceResponse, error)
}

// UnimplementedValidationHelperV1Server can be embedded to have forward compatible implementations.
type UnimplementedValidationHelperV1Server struct {
}

func (*UnimplementedValidationHelperV1Server) ValidateAttestationOccurrence(context.Context, *ValidateAttestationOccurrenceRequest) (*ValidateAttestationOccurrenceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateAttestationOccurrence not implemented")
}

func RegisterValidationHelperV1Server(s *grpc.Server, srv ValidationHelperV1Server) {
	s.RegisterService(&_ValidationHelperV1_serviceDesc, srv)
}

func _ValidationHelperV1_ValidateAttestationOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateAttestationOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ValidationHelperV1Server).ValidateAttestationOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1.ValidationHelperV1/ValidateAttestationOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ValidationHelperV1Server).ValidateAttestationOccurrence(ctx, req.(*ValidateAttestationOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ValidationHelperV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.binaryauthorization.v1.ValidationHelperV1",
	HandlerType: (*ValidationHelperV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ValidateAttestationOccurrence",
			Handler:    _ValidationHelperV1_ValidateAttestationOccurrence_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/binaryauthorization/v1/service.proto",
}
