package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateSuspiciousEvent invokes the aegis.OperateSuspiciousEvent API synchronously
// api document: https://help.aliyun.com/api/aegis/operatesuspiciousevent.html
func (client *Client) OperateSuspiciousEvent(request *OperateSuspiciousEventRequest) (response *OperateSuspiciousEventResponse, err error) {
	response = CreateOperateSuspiciousEventResponse()
	err = client.DoAction(request, response)
	return
}

// OperateSuspiciousEventWithChan invokes the aegis.OperateSuspiciousEvent API asynchronously
// api document: https://help.aliyun.com/api/aegis/operatesuspiciousevent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateSuspiciousEventWithChan(request *OperateSuspiciousEventRequest) (<-chan *OperateSuspiciousEventResponse, <-chan error) {
	responseChan := make(chan *OperateSuspiciousEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateSuspiciousEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateSuspiciousEventWithCallback invokes the aegis.OperateSuspiciousEvent API asynchronously
// api document: https://help.aliyun.com/api/aegis/operatesuspiciousevent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateSuspiciousEventWithCallback(request *OperateSuspiciousEventRequest, callback func(response *OperateSuspiciousEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateSuspiciousEventResponse
		var err error
		defer close(result)
		response, err = client.OperateSuspiciousEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateSuspiciousEventRequest is the request struct for api OperateSuspiciousEvent
type OperateSuspiciousEventRequest struct {
	*requests.RpcRequest
	SourceIp    string `position:"Query" name:"SourceIp"`
	Data        string `position:"Query" name:"Data"`
	OperateType string `position:"Query" name:"OperateType"`
}

// OperateSuspiciousEventResponse is the response struct for api OperateSuspiciousEvent
type OperateSuspiciousEventResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOperateSuspiciousEventRequest creates a request to invoke OperateSuspiciousEvent API
func CreateOperateSuspiciousEventRequest() (request *OperateSuspiciousEventRequest) {
	request = &OperateSuspiciousEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "OperateSuspiciousEvent", "vipaegis", "openAPI")
	return
}

// CreateOperateSuspiciousEventResponse creates a response to parse from OperateSuspiciousEvent response
func CreateOperateSuspiciousEventResponse() (response *OperateSuspiciousEventResponse) {
	response = &OperateSuspiciousEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
