package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAntChainNodes invokes the baas.DescribeAntChainNodes API synchronously
// api document: https://help.aliyun.com/api/baas/describeantchainnodes.html
func (client *Client) DescribeAntChainNodes(request *DescribeAntChainNodesRequest) (response *DescribeAntChainNodesResponse, err error) {
	response = CreateDescribeAntChainNodesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAntChainNodesWithChan invokes the baas.DescribeAntChainNodes API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchainnodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainNodesWithChan(request *DescribeAntChainNodesRequest) (<-chan *DescribeAntChainNodesResponse, <-chan error) {
	responseChan := make(chan *DescribeAntChainNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAntChainNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAntChainNodesWithCallback invokes the baas.DescribeAntChainNodes API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchainnodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainNodesWithCallback(request *DescribeAntChainNodesRequest, callback func(response *DescribeAntChainNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAntChainNodesResponse
		var err error
		defer close(result)
		response, err = client.DescribeAntChainNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAntChainNodesRequest is the request struct for api DescribeAntChainNodes
type DescribeAntChainNodesRequest struct {
	*requests.RpcRequest
	AntChainId string `position:"Body" name:"AntChainId"`
}

// DescribeAntChainNodesResponse is the response struct for api DescribeAntChainNodes
type DescribeAntChainNodesResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Result    []map[string]interface{} `json:"Result" xml:"Result"`
}

// CreateDescribeAntChainNodesRequest creates a request to invoke DescribeAntChainNodes API
func CreateDescribeAntChainNodesRequest() (request *DescribeAntChainNodesRequest) {
	request = &DescribeAntChainNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeAntChainNodes", "baas", "openAPI")
	return
}

// CreateDescribeAntChainNodesResponse creates a response to parse from DescribeAntChainNodes response
func CreateDescribeAntChainNodesResponse() (response *DescribeAntChainNodesResponse) {
	response = &DescribeAntChainNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
