package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DuplicateVnInstance invokes the cloudcallcenter.DuplicateVnInstance API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/duplicatevninstance.html
func (client *Client) DuplicateVnInstance(request *DuplicateVnInstanceRequest) (response *DuplicateVnInstanceResponse, err error) {
	response = CreateDuplicateVnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DuplicateVnInstanceWithChan invokes the cloudcallcenter.DuplicateVnInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/duplicatevninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DuplicateVnInstanceWithChan(request *DuplicateVnInstanceRequest) (<-chan *DuplicateVnInstanceResponse, <-chan error) {
	responseChan := make(chan *DuplicateVnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DuplicateVnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DuplicateVnInstanceWithCallback invokes the cloudcallcenter.DuplicateVnInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/duplicatevninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DuplicateVnInstanceWithCallback(request *DuplicateVnInstanceRequest, callback func(response *DuplicateVnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DuplicateVnInstanceResponse
		var err error
		defer close(result)
		response, err = client.DuplicateVnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DuplicateVnInstanceRequest is the request struct for api DuplicateVnInstance
type DuplicateVnInstanceRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DuplicateVnInstanceResponse is the response struct for api DuplicateVnInstance
type DuplicateVnInstanceResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
}

// CreateDuplicateVnInstanceRequest creates a request to invoke DuplicateVnInstance API
func CreateDuplicateVnInstanceRequest() (request *DuplicateVnInstanceRequest) {
	request = &DuplicateVnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DuplicateVnInstance", "", "")
	request.Method = requests.GET
	return
}

// CreateDuplicateVnInstanceResponse creates a response to parse from DuplicateVnInstance response
func CreateDuplicateVnInstanceResponse() (response *DuplicateVnInstanceResponse) {
	response = &DuplicateVnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
