package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCcMode invokes the ddospro.ModifyCcMode API synchronously
// api document: https://help.aliyun.com/api/ddospro/modifyccmode.html
func (client *Client) ModifyCcMode(request *ModifyCcModeRequest) (response *ModifyCcModeResponse, err error) {
	response = CreateModifyCcModeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCcModeWithChan invokes the ddospro.ModifyCcMode API asynchronously
// api document: https://help.aliyun.com/api/ddospro/modifyccmode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCcModeWithChan(request *ModifyCcModeRequest) (<-chan *ModifyCcModeResponse, <-chan error) {
	responseChan := make(chan *ModifyCcModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCcMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCcModeWithCallback invokes the ddospro.ModifyCcMode API asynchronously
// api document: https://help.aliyun.com/api/ddospro/modifyccmode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCcModeWithCallback(request *ModifyCcModeRequest, callback func(response *ModifyCcModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCcModeResponse
		var err error
		defer close(result)
		response, err = client.ModifyCcMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCcModeRequest is the request struct for api ModifyCcMode
type ModifyCcModeRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Vip             string           `position:"Query" name:"Vip"`
	CcMode          string           `position:"Query" name:"CcMode"`
}

// ModifyCcModeResponse is the response struct for api ModifyCcMode
type ModifyCcModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"data" xml:"data"`
}

// CreateModifyCcModeRequest creates a request to invoke ModifyCcMode API
func CreateModifyCcModeRequest() (request *ModifyCcModeRequest) {
	request = &ModifyCcModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "ModifyCcMode", "", "")
	return
}

// CreateModifyCcModeResponse creates a response to parse from ModifyCcMode response
func CreateModifyCcModeResponse() (response *ModifyCcModeResponse) {
	response = &ModifyCcModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
