package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfirmSendSms invokes the dyplsapi.ConfirmSendSms API synchronously
func (client *Client) ConfirmSendSms(request *ConfirmSendSmsRequest) (response *ConfirmSendSmsResponse, err error) {
	response = CreateConfirmSendSmsResponse()
	err = client.DoAction(request, response)
	return
}

// ConfirmSendSmsWithChan invokes the dyplsapi.ConfirmSendSms API asynchronously
func (client *Client) ConfirmSendSmsWithChan(request *ConfirmSendSmsRequest) (<-chan *ConfirmSendSmsResponse, <-chan error) {
	responseChan := make(chan *ConfirmSendSmsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfirmSendSms(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfirmSendSmsWithCallback invokes the dyplsapi.ConfirmSendSms API asynchronously
func (client *Client) ConfirmSendSmsWithCallback(request *ConfirmSendSmsRequest, callback func(response *ConfirmSendSmsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfirmSendSmsResponse
		var err error
		defer close(result)
		response, err = client.ConfirmSendSms(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfirmSendSmsRequest is the request struct for api ConfirmSendSms
type ConfirmSendSmsRequest struct {
	*requests.RpcRequest
	CallId               string           `position:"Query" name:"CallId"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecretNo             string           `position:"Query" name:"SecretNo"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
}

// ConfirmSendSmsResponse is the response struct for api ConfirmSendSms
type ConfirmSendSmsResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfirmSendSmsRequest creates a request to invoke ConfirmSendSms API
func CreateConfirmSendSmsRequest() (request *ConfirmSendSmsRequest) {
	request = &ConfirmSendSmsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "ConfirmSendSms", "", "")
	request.Method = requests.POST
	return
}

// CreateConfirmSendSmsResponse creates a response to parse from ConfirmSendSms response
func CreateConfirmSendSmsResponse() (response *ConfirmSendSmsResponse) {
	response = &ConfirmSendSmsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
