package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyClusterDeletionProtection invokes the hbase.ModifyClusterDeletionProtection API synchronously
func (client *Client) ModifyClusterDeletionProtection(request *ModifyClusterDeletionProtectionRequest) (response *ModifyClusterDeletionProtectionResponse, err error) {
	response = CreateModifyClusterDeletionProtectionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyClusterDeletionProtectionWithChan invokes the hbase.ModifyClusterDeletionProtection API asynchronously
func (client *Client) ModifyClusterDeletionProtectionWithChan(request *ModifyClusterDeletionProtectionRequest) (<-chan *ModifyClusterDeletionProtectionResponse, <-chan error) {
	responseChan := make(chan *ModifyClusterDeletionProtectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyClusterDeletionProtection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyClusterDeletionProtectionWithCallback invokes the hbase.ModifyClusterDeletionProtection API asynchronously
func (client *Client) ModifyClusterDeletionProtectionWithCallback(request *ModifyClusterDeletionProtectionRequest, callback func(response *ModifyClusterDeletionProtectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyClusterDeletionProtectionResponse
		var err error
		defer close(result)
		response, err = client.ModifyClusterDeletionProtection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyClusterDeletionProtectionRequest is the request struct for api ModifyClusterDeletionProtection
type ModifyClusterDeletionProtectionRequest struct {
	*requests.RpcRequest
	Protection requests.Boolean `position:"Query" name:"Protection"`
	ClusterId  string           `position:"Query" name:"ClusterId"`
}

// ModifyClusterDeletionProtectionResponse is the response struct for api ModifyClusterDeletionProtection
type ModifyClusterDeletionProtectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyClusterDeletionProtectionRequest creates a request to invoke ModifyClusterDeletionProtection API
func CreateModifyClusterDeletionProtectionRequest() (request *ModifyClusterDeletionProtectionRequest) {
	request = &ModifyClusterDeletionProtectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ModifyClusterDeletionProtection", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyClusterDeletionProtectionResponse creates a response to parse from ModifyClusterDeletionProtection response
func CreateModifyClusterDeletionProtectionResponse() (response *ModifyClusterDeletionProtectionResponse) {
	response = &ModifyClusterDeletionProtectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
